/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import java.util.Enumeration;
import org.maachang.dbm.engine.FnvHash;
import org.maachang.dbm.engine.MDbmEnumeration;
import org.maachang.dbm.engine.MKey;
import org.maachang.dbm.engine.MValue;
import org.maachang.dbm.engine.NextKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDbmEngine {
    private MKey key = null;
    private MValue value = null;
    private final Object sync = new Object();
    private Object[] hashSync = null;

    private MDbmEngine() {
    }

    public MDbmEngine(MKey key, MValue value) throws Exception {
        if (key == null || !key.isUse() || value == null || !value.isUse()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.key = key;
        this.value = value;
        int len = 65536;
        this.hashSync = new Object[len];
        int i = 0;
        while (i < len) {
            this.hashSync[i] = new Object();
            ++i;
        }
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.sync;
        synchronized (object) {
            if (this.key != null) {
                this.key.destroy();
            }
            if (this.value != null) {
                this.value.destroy();
            }
            this.key = null;
            this.value = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws Exception {
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.key.flush();
            this.value.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(byte[] key, byte[] value) throws Exception {
        if (key == null || key.length <= 0 || value == null || value.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (key.length > 512) {
            throw new IllegalArgumentException("\u6700\u5927\u30ad\u30fc\u9577[512]\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        MKey k = null;
        MValue v = null;
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            k = this.key;
            v = this.value;
        }
        int code = FnvHash.fnv16a(key);
        int[] putPos = null;
        int[] befPos = null;
        Object object2 = this.hashSync[code];
        synchronized (object2) {
            putPos = v.put(value);
            befPos = k.put(code, key, putPos[0], putPos[1]);
            if (befPos != null) {
                v.remove(befPos[0], befPos[1]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(byte[] key) throws Exception {
        if (key == null || key.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (key.length > 512) {
            throw new IllegalArgumentException("\u6700\u5927\u30ad\u30fc\u9577[512]\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        MKey k = null;
        MValue v = null;
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            k = this.key;
            v = this.value;
        }
        int code = FnvHash.fnv16a(key);
        int[] valPos = null;
        Object object2 = this.hashSync[code];
        synchronized (object2) {
            valPos = k.remove(code, key);
            if (valPos != null) {
                v.remove(valPos[0], valPos[1]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(byte[] key) throws Exception {
        if (key == null || key.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (key.length > 512) {
            throw new IllegalArgumentException("\u6700\u5927\u30ad\u30fc\u9577[512]\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        MKey k = null;
        MValue v = null;
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            k = this.key;
            v = this.value;
        }
        int code = FnvHash.fnv16a(key);
        int[] valPos = null;
        byte[] ret = null;
        Object object2 = this.hashSync[code];
        synchronized (object2) {
            valPos = k.get(code, key);
            if (valPos != null) {
                ret = v.get(valPos[0], valPos[1]);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NextKey next(NextKey nextKey) throws Exception {
        NextKey ret = null;
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            ret = this.key.nextKey(nextKey);
        }
        return ret;
    }

    public Enumeration<byte[]> elements() {
        return new MDbmEnumeration(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int ret = -1;
        Object object = this.sync;
        synchronized (object) {
            if (this.check()) {
                ret = this.key.size();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MKey getMKey() {
        MKey ret = null;
        Object object = this.sync;
        synchronized (object) {
            if (this.check()) {
                ret = this.key;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MValue getMValue() {
        MValue ret = null;
        Object object = this.sync;
        synchronized (object) {
            if (this.check()) {
                ret = this.value;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUse() {
        boolean ret = false;
        Object object = this.sync;
        synchronized (object) {
            ret = this.check();
        }
        return ret;
    }

    private boolean check() {
        return this.key != null && this.key.isUse() && this.value != null && this.value.isUse();
    }
}

