/*
 * Decompiled with CFR 0.152.
 */
package com.nissy_ki_chi.jpicosheet.util;

import com.nissy_ki_chi.jpicosheet.core.Book;
import com.nissy_ki_chi.jpicosheet.core.Cell;
import com.nissy_ki_chi.jpicosheet.core.Group;
import com.nissy_ki_chi.jpicosheet.core.Sheet;
import com.nissy_ki_chi.jpicosheet.core.Table;
import java.io.IOException;
import java.io.InputStream;
import java.math.MathContext;
import java.math.RoundingMode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLReader {
    private XPath _xpath = XPathFactory.newInstance().newXPath();

    public Book read(InputStream is) throws Exception {
        Document document = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = builder.parse(is);
        }
        catch (ParserConfigurationException e) {
            throw new Exception(e);
        }
        catch (SAXException e) {
            throw new Exception(e);
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        Book book = null;
        try {
            Node bookNode = this.getNode(document, "/book");
            book = this.createBook(bookNode);
            NodeList sheetNodes = this.getSubnodes(bookNode, "./sheet");
            int i = 0;
            while (i < sheetNodes.getLength()) {
                Node sheetNode = sheetNodes.item(i);
                Sheet sheet = this.createSheet(book, sheetNode);
                NodeList cellNodes = this.getSubnodes(sheetNode, "./cell");
                int j = 0;
                while (j < cellNodes.getLength()) {
                    Node cellNode = cellNodes.item(j);
                    this.createCell(sheet, cellNode);
                    ++j;
                }
                NodeList tableNodes = this.getSubnodes(sheetNode, "./table");
                int k = 0;
                while (k < tableNodes.getLength()) {
                    Node tableNode = tableNodes.item(k);
                    this.createTable(sheet, tableNode);
                    ++k;
                }
                NodeList groupNodes = this.getSubnodes(sheetNode, "./group");
                int l = 0;
                while (l < groupNodes.getLength()) {
                    Node groupNode = groupNodes.item(l);
                    this.createGroup(sheet, groupNode);
                    ++l;
                }
                ++i;
            }
        }
        catch (XPathExpressionException e) {
            throw new Exception(e);
        }
        return book;
    }

    private Book createBook(Node bookNode) {
        if (bookNode == null) {
            throw new NullPointerException("book\u30ce\u30fc\u30c9\u304cnull\u3067\u3059\u3002");
        }
        Book book = null;
        String bookName = this.getAttribute(bookNode, "name");
        if (bookName != null) {
            book = new Book(bookName);
        }
        return book;
    }

    private Sheet createSheet(Book book, Node sheetNode) throws Exception {
        if (book == null) {
            throw new NullPointerException("book\u304cnull\u3067\u3059\u3002");
        }
        if (sheetNode == null) {
            throw new NullPointerException("sheetNode\u304cnull\u3067\u3059\u3002");
        }
        String sheetName = this.getAttribute(sheetNode, "name");
        String precision = this.getAttribute(sheetNode, "precision");
        String rounding = this.getAttribute(sheetNode, "roundingMode");
        if (sheetName == null) {
            throw new Exception("\u30b7\u30fc\u30c8\u540d\u304c\u3042\u308a\u307e\u305b\u3093\uff1a" + sheetNode.toString());
        }
        Sheet sheet = book.addSheet(sheetName);
        boolean validPrecision = true;
        int intPrecision = 0;
        if (precision != null) {
            try {
                intPrecision = Integer.parseInt(precision);
            }
            catch (NumberFormatException e) {
                validPrecision = false;
            }
        } else {
            validPrecision = false;
        }
        boolean validRounding = true;
        RoundingMode roundingMode = null;
        if (rounding != null) {
            String upperRounding = rounding.toUpperCase();
            if (upperRounding.equals("UP")) {
                roundingMode = RoundingMode.UP;
            } else if (upperRounding.equals("DOWN")) {
                roundingMode = RoundingMode.DOWN;
            } else if (upperRounding.equals("CEILING")) {
                roundingMode = RoundingMode.CEILING;
            } else if (upperRounding.equals("FLOOR")) {
                roundingMode = RoundingMode.FLOOR;
            } else if (upperRounding.equals("HALF_UP")) {
                roundingMode = RoundingMode.HALF_UP;
            } else if (upperRounding.equals("HALF_DOWN")) {
                roundingMode = RoundingMode.HALF_DOWN;
            } else if (upperRounding.equals("HALF_EVEN")) {
                roundingMode = RoundingMode.HALF_EVEN;
            } else {
                validRounding = false;
            }
        }
        MathContext mc = Sheet.DEFAULT_MATH_CONTEXT;
        if (validPrecision && validRounding) {
            mc = new MathContext(intPrecision, roundingMode);
        } else if (validPrecision) {
            mc = new MathContext(intPrecision, Sheet.DEFAULT_MATH_CONTEXT.getRoundingMode());
        } else if (validRounding) {
            mc = new MathContext(Sheet.DEFAULT_MATH_CONTEXT.getPrecision(), roundingMode);
        }
        sheet.setMathContext(mc);
        return sheet;
    }

    private Cell createCell(Sheet sheet, Node cellNode) throws Exception {
        if (sheet == null) {
            throw new NullPointerException("sheet\u304cnull\u3067\u3059");
        }
        if (cellNode == null) {
            throw new NullPointerException("cellNode\u304cnull\u3067\u3059");
        }
        String cellName = this.getAttribute(cellNode, "name");
        String type = this.getAttribute(cellNode, "type");
        String content = this.getContent(cellNode);
        if (cellName == null) {
            throw new Exception("\u30bb\u30eb\u540d\u304c\u3042\u308a\u307e\u305b\u3093" + cellNode.toString());
        }
        Cell cell = sheet.addCell(cellName);
        this.setCellValue(cell, type, content);
        return cell;
    }

    private void createTable(Sheet sheet, Node tableNode) throws Exception {
        if (sheet == null) {
            throw new NullPointerException("sheet\u304cnull\u3067\u3059");
        }
        if (tableNode == null) {
            throw new NullPointerException("tableNode\u304cnull\u3067\u3059");
        }
        String tableName = this.getAttribute(tableNode, "name");
        String rowNum = this.getAttribute(tableNode, "row");
        String colNum = this.getAttribute(tableNode, "col");
        if (tableName == null) {
            throw new Exception("\u30c6\u30fc\u30d6\u30eb\u540d\u304c\u3042\u308a\u307e\u305b\u3093");
        }
        int rowSize = 0;
        int colSize = 0;
        try {
            rowSize = Integer.parseInt(rowNum);
            colSize = Integer.parseInt(colNum);
        }
        catch (NumberFormatException nfe) {
            throw new Exception("\u30c6\u30fc\u30d6\u30eb\u306e\u884c\u5217\u6307\u5b9a\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002\u884c\uff1a" + rowSize + "\u5217\uff1a" + colSize);
        }
        Table table = sheet.addTable(tableName, rowSize, colSize);
        NodeList tableRowNodes = this.getSubnodes(tableNode, "./row");
        int row = 0;
        while (row < tableRowNodes.getLength()) {
            Node rowNode = tableRowNodes.item(row);
            String rowNodeNum = this.getAttribute(rowNode, "num");
            int rowNodeNumInt = 0;
            try {
                rowNodeNumInt = Integer.parseInt(rowNodeNum);
            }
            catch (NumberFormatException nfe) {
                throw new Exception("\u30c6\u30fc\u30d6\u30eb\u30c7\u30fc\u30bf\u306e\u884c\u6307\u5b9a\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\uff1a" + rowNodeNum);
            }
            NodeList tableColNodes = this.getSubnodes(rowNode, "./col");
            int col = 0;
            while (col < tableColNodes.getLength()) {
                Node colNode = tableColNodes.item(col);
                String colNodeNum = this.getAttribute(colNode, "num");
                int colNodeNumInt = 0;
                try {
                    colNodeNumInt = Integer.parseInt(colNodeNum);
                }
                catch (NumberFormatException nfe) {
                    throw new Exception("\u30c6\u30fc\u30d6\u30eb\u30c7\u30fc\u30bf\u306e\u5217\u6307\u5b9a\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\uff1a" + colNodeNum);
                }
                String type = this.getAttribute(colNode, "type");
                String colNodeContent = this.getContent(colNode);
                this.setCellValue(table.getCell(rowNodeNumInt, colNodeNumInt), type, colNodeContent);
                ++col;
            }
            ++row;
        }
    }

    private void createGroup(Sheet sheet, Node groupNode) throws XPathExpressionException {
        if (sheet == null) {
            throw new NullPointerException("sheet\u304cnull\u3067\u3059");
        }
        if (groupNode == null) {
            throw new NullPointerException("groupNode\u304cnull\u3067\u3059");
        }
        String groupName = this.getAttribute(groupNode, "name");
        NodeList groupNameNodes = this.getSubnodes(groupNode, "./cell");
        Group group = sheet.addGroup(groupName);
        int i = 0;
        while (i < groupNameNodes.getLength()) {
            Node groupCellNode = groupNameNodes.item(i);
            String groupCellName = this.getAttribute(groupCellNode, "name");
            group.addCell(groupCellName);
            ++i;
        }
    }

    private Cell setCellValue(Cell cell, String type, String content) {
        if (cell == null) {
            throw new NullPointerException("cell\u304cnull\u3067\u3059");
        }
        if (type != null) {
            if ("STR".equalsIgnoreCase(type)) {
                cell.setStringValue(content);
            } else if ("NUM".equalsIgnoreCase(type)) {
                cell.setNumberValue(content);
            } else if ("bool".equalsIgnoreCase(type)) {
                cell.setBooleanValue(Boolean.parseBoolean(content));
            } else if ("FORMULA".equalsIgnoreCase(type)) {
                cell.setFormula(content);
            } else if ("DATE".equalsIgnoreCase(type)) {
                cell.setValue(content);
            } else {
                cell.setValue(content);
            }
        } else {
            cell.setValue(content);
        }
        return cell;
    }

    private Node getNode(Document document, String xpathString) throws XPathExpressionException {
        return (Node)this._xpath.evaluate(xpathString, document, XPathConstants.NODE);
    }

    private Node getNode(Document document, XPathExpression expr) throws XPathExpressionException {
        return (Node)expr.evaluate(document, XPathConstants.NODE);
    }

    private NodeList getNodes(Document document, String xpathString) throws XPathExpressionException {
        return (NodeList)this._xpath.evaluate(xpathString, document, XPathConstants.NODESET);
    }

    private NodeList getNodes(Document document, XPathExpression expr) throws XPathExpressionException {
        return (NodeList)expr.evaluate(document, XPathConstants.NODESET);
    }

    private NodeList getSubnodes(Node node, String xpathString) throws XPathExpressionException {
        return (NodeList)this._xpath.evaluate(xpathString, node, XPathConstants.NODESET);
    }

    private String getAttribute(Node node, String attrName) {
        if (node == null) {
            throw new NullPointerException("node\u304cnull\u3067\u3059\u3002");
        }
        if (!node.hasAttributes() || node.getAttributes().getNamedItem(attrName) == null) {
            return null;
        }
        return node.getAttributes().getNamedItem(attrName).getNodeValue();
    }

    private String getContent(Node node) {
        return node.getTextContent();
    }
}

