/*
 * Decompiled with CFR 0.152.
 */
package com.nissy_ki_chi.jpicosheet.util;

import com.nissy_ki_chi.jpicosheet.core.Book;
import com.nissy_ki_chi.jpicosheet.core.Cell;
import com.nissy_ki_chi.jpicosheet.core.ConcurrentBookWrapper;
import com.nissy_ki_chi.jpicosheet.core.Group;
import com.nissy_ki_chi.jpicosheet.core.Sheet;
import com.nissy_ki_chi.jpicosheet.core.Table;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SimpleWriter {
    public static String OPTION_MARK = "@";
    private ConcurrentBookWrapper _bookWrapper;

    public SimpleWriter(ConcurrentBookWrapper cbr) {
        this._bookWrapper = cbr;
    }

    public void write(Writer w) throws IOException {
        try {
            ReentrantReadWriteLock.WriteLock writeLock = this._bookWrapper.getWriteLock();
            StringBuilder sb = new StringBuilder();
            Book book = this._bookWrapper.getBook(writeLock);
            sb.setLength(0);
            sb.append(OPTION_MARK).append("Book:name").append("\t").append(book.getName());
            this.output(w, sb);
            for (Sheet sheet : book.getSheets()) {
                sb.setLength(0);
                sb.append(OPTION_MARK).append(sheet.getName()).append(":Name").append("\t").append(sheet.getName());
                this.output(w, sb);
                sb.setLength(0);
                sb.append(OPTION_MARK).append(sheet.getName()).append(":MathContext").append("\t").append(sheet.getMathContext().toString());
                this.output(w, sb);
                for (Cell cell : sheet.getCells()) {
                    if (cell.getName().indexOf("#") >= 0) continue;
                    sb.setLength(0);
                    sb = this.getCellValueLine(cell, sb);
                    this.output(w, sb);
                    sb.setLength(0);
                    if (cell.getLabel().equals("")) continue;
                    sb.append(OPTION_MARK).append(cell.getFullyQualifiedName()).append(":Label").append("\t").append(cell.getLabel());
                    this.output(w, sb);
                }
                for (Table table : sheet.getTables()) {
                    sb.setLength(0);
                    sb.append(OPTION_MARK).append(table.getFullyQualifiedName()).append(":Table").append("\t").append(table.getRowSize()).append(",").append(table.getColSize());
                    this.output(w, sb);
                    for (Cell tableCell : table.getCells()) {
                        sb.setLength(0);
                        sb = this.getCellValueLine(tableCell, sb);
                        this.output(w, sb);
                    }
                }
                for (Group group : sheet.getGroups()) {
                    sb.setLength(0);
                    StringBuilder groupCellsSb = new StringBuilder();
                    for (Cell groupCell : group.getCells()) {
                        groupCellsSb.append(groupCell.getFullyQualifiedName()).append(",");
                    }
                    if (groupCellsSb.length() > 1) {
                        groupCellsSb.deleteCharAt(groupCellsSb.length() - 1);
                    }
                    sb.append(OPTION_MARK).append(group.getFullyQualifiedName()).append(":Group").append("\t").append(groupCellsSb.toString());
                    this.output(w, sb);
                }
            }
            w.flush();
        }
        finally {
            this._bookWrapper.releaseWriteLock();
        }
    }

    private StringBuilder getCellValueLine(Cell cell, StringBuilder sb) {
        sb.append(cell.getFullyQualifiedName());
        sb.append("\t");
        switch (cell.getCellType()) {
            case FORMULA: {
                sb.append(cell.getFormula());
                break;
            }
            case NUMBER: {
                sb.append(cell.getValue().getNumber().toString());
                break;
            }
            case STRING: {
                sb.append(cell.getValue().getString());
                break;
            }
            case BOOLEAN: {
                sb.append(cell.getValue().getString());
                break;
            }
            case EMPTY: {
                sb.append("");
                break;
            }
            default: {
                assert (false) : "\u51e6\u7406\u3055\u308c\u306a\u3044\u30bb\u30eb\u30bf\u30a4\u30d7\uff1a" + cell.getCellType().toString();
                break;
            }
        }
        return sb;
    }

    private void output(Writer w, StringBuilder sb) throws IOException {
        int c = 0;
        while (c < sb.length()) {
            switch (sb.charAt(c)) {
                case '\n': {
                    sb.replace(c, c + 1, "\\n");
                    ++c;
                    break;
                }
                case '\\': {
                    sb.replace(c, c + 1, "\\");
                    ++c;
                }
            }
            ++c;
        }
        w.write(sb.append("\n").toString());
    }
}

