/*
 * Decompiled with CFR 0.152.
 */
package com.nissy_ki_chi.jpicosheet.function;

import com.nissy_ki_chi.jpicosheet.core.Cell;
import com.nissy_ki_chi.jpicosheet.core.Element;
import com.nissy_ki_chi.jpicosheet.core.Function;
import com.nissy_ki_chi.jpicosheet.core.ReferenceNotFoundException;
import com.nissy_ki_chi.jpicosheet.core.Resolver;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Collection;

public class SUM
extends Function {
    public Element call(Element[] elements, MathContext mc, Resolver resolver) {
        BigDecimal result = BigDecimal.ZERO;
        Element[] elementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Element elem = elementArray[n2];
            try {
                switch (elem.getType()) {
                    case NUMBER: 
                    case BOOLEAN: {
                        result = result.add(elem.getNumber(), mc);
                        break;
                    }
                    case GROUP_REFERENCE: 
                    case TABLE_REFERENCE: {
                        Collection<Cell> collection = null;
                        if (elem.getType() == Element.ElementType.GROUP_REFERENCE) {
                            collection = resolver.getCellsFromGroup(this.getGroupReference(elem));
                        } else if (elem.getType() == Element.ElementType.TABLE_REFERENCE) {
                            collection = resolver.getCellsFromTable(this.getTableReference(elem));
                        }
                        for (Cell cell : collection) {
                            if (cell.getValueType() != Element.ElementType.NUMBER && cell.getValueType() != Element.ElementType.BOOLEAN) continue;
                            result = result.add(cell.getValue().getNumber());
                        }
                    }
                }
            }
            catch (ReferenceNotFoundException e) {
                return Element.newElement(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_REFERENCES);
            }
            ++n2;
        }
        return Element.newElement(Element.ElementType.NUMBER, result);
    }
}

