/*
 * Decompiled with CFR 0.152.
 */
package com.nissy_ki_chi.jpicosheet.core;

import com.nissy_ki_chi.jpicosheet.core.Calculator;
import com.nissy_ki_chi.jpicosheet.core.Element;
import com.nissy_ki_chi.jpicosheet.core.FormulaParser;
import com.nissy_ki_chi.jpicosheet.core.Resolver;
import com.nissy_ki_chi.jpicosheet.core.Sheet;
import com.nissy_ki_chi.jpicosheet.core.Table;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cell
implements Comparable<Cell> {
    private static Element emptyElement = Element.newElement(Element.ElementType.EMPTY);
    private static final String EMPTY_LABEL = "";
    private String _formula;
    private Element[] _formulaRPN;
    private String _name;
    private String _label;
    private Sheet _sheet;
    private CellType _cellType = CellType.EMPTY;
    private CellStatus _status = CellStatus.CALCULATED;
    private Element _value;
    static final String CELL_NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*";
    private static Pattern _cellNamePattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    static final String FULLY_QUALIFIED_CELL_NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*";
    private static Pattern _fullyQualifiedCellNamePattern = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*![a-zA-Z_][a-zA-Z0-9_]*");

    Cell(String cellName, Sheet sheet) throws IllegalArgumentException {
        this(cellName, sheet, false);
    }

    Cell(String cellName, Sheet sheet, boolean createForTableCell) throws IllegalArgumentException {
        if (createForTableCell) {
            if (!Table.isValidTableNameWithAddress(cellName)) {
                throw new IllegalArgumentException("invalid cell name for Table \"" + cellName + "\"");
            }
        } else if (!Cell.isValidCellName(cellName)) {
            throw new IllegalArgumentException("invalid cell name \"" + cellName + "\"");
        }
        this._name = cellName;
        this._label = EMPTY_LABEL;
        this._formula = null;
        this._value = emptyElement;
        this._sheet = sheet;
    }

    public String getFormula() {
        if (this._cellType == CellType.FORMULA) {
            return "=" + this._formula;
        }
        return null;
    }

    Element[] getFormulaRPN() {
        return this._formulaRPN;
    }

    public String getName() {
        return this._name;
    }

    public String getLabel() {
        return this._label;
    }

    public String getFullyQualifiedName() {
        return String.valueOf(this._sheet.getName()) + "!" + this._name;
    }

    public Sheet getSheet() {
        return this._sheet;
    }

    public CellStatus getStatus() {
        return this._status;
    }

    public String getValueString() {
        switch (this._value.getType()) {
            case EMPTY: {
                return EMPTY_LABEL;
            }
            case DATE: {
                return Element.DEFAULT_DATETIME_FORMAT.format(new Date(this._value.getNumber().longValue() - (long)TimeZone.getDefault().getRawOffset()));
            }
            case ERROR: {
                return this._value.toString();
            }
            case NUMBER: {
                return this._value.getNumber().toString();
            }
            case STRING: {
                return this._value.getString();
            }
        }
        assert (false) : "unexpected value type: " + this._value.toString();
        return EMPTY_LABEL;
    }

    public Element.ElementType getValueType() {
        return this._value.getType();
    }

    public CellType getCellType() {
        return this._cellType;
    }

    public Element getValue() {
        return this._value;
    }

    void setFormulaRPN(Element[] formulaRPN) {
        this._formulaRPN = formulaRPN;
    }

    void setName(String cellName) {
        this.setName(cellName, false);
    }

    void setName(String cellName, boolean createForTableCell) throws IllegalArgumentException {
        if (createForTableCell) {
            if (!Table.isValidTableNameWithAddress(cellName)) {
                throw new IllegalArgumentException("invalid cell name for Table \"" + cellName + "\"");
            }
        } else if (!Cell.isValidCellName(cellName)) {
            throw new IllegalArgumentException("invalid cell name \"" + cellName + "\"");
        }
        this._name = cellName;
    }

    public Cell setLabel(String newLabel) {
        this._label = newLabel;
        return this;
    }

    void setStatus(CellStatus status) {
        this._status = status;
    }

    void setValue(Element value) {
        this._value = value;
    }

    public Cell setValue(String value) {
        if (value == null || value.equals(EMPTY_LABEL)) {
            this.setValue(emptyElement);
        } else if (this.isNumString(value)) {
            this.setNumberValue(value);
        } else if (this.isFormulaString(value)) {
            this.setFormula(value);
        } else if (this.isDateString(value)) {
            Date parsedDate = null;
            SimpleDateFormat[] simpleDateFormatArray = Element.READABLE_DATETIME_FORMATS;
            int n = Element.READABLE_DATETIME_FORMATS.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    SimpleDateFormat sdf = simpleDateFormatArray[n2];
                    try {
                        parsedDate = sdf.parse(value);
                    }
                    catch (ParseException e) {
                        break block11;
                    }
                    this.setDateValue(parsedDate);
                    break;
                }
                ++n2;
            }
        } else {
            this.setStringValue(value);
        }
        return this;
    }

    public Cell createUndefinedReferenceCells() {
        if (this.getCellType() != CellType.FORMULA) {
            return this;
        }
        Resolver resolver = this._sheet.getBook().getResolver();
        Element[] elementArray = this.getFormulaRPN();
        int n = elementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Element elem = elementArray[n2];
            if (elem.getType() == Element.ElementType.REFERENCE) {
                String refName = elem.getCellReference();
                if (resolver.isFullyQualifiedName(refName)) {
                    Sheet otherSheet = this._sheet.getBook().getSheet(resolver.getSheetNameFromFullyQualifiedName(refName));
                    otherSheet.addCell(refName);
                } else {
                    this._sheet.addCell(refName);
                }
            }
            ++n2;
        }
        this._status = CellStatus.REQUIRE_CALCULATION;
        this.getCalculator().calc(this);
        this._sheet.removeErrorCell(this);
        return this;
    }

    private boolean isNumString(String numString) {
        try {
            new BigDecimal(numString);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private boolean isFormulaString(String formulaString) {
        return formulaString != null && formulaString.length() > 0 && formulaString.substring(0, 1).equals("=");
    }

    private boolean isDateString(String dateString) {
        boolean isDateString = false;
        SimpleDateFormat[] simpleDateFormatArray = Element.READABLE_DATETIME_FORMATS;
        int n = Element.READABLE_DATETIME_FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                SimpleDateFormat sdf = simpleDateFormatArray[n2];
                try {
                    sdf.parse(dateString);
                }
                catch (ParseException e) {
                    break block3;
                }
                isDateString = true;
                break;
            }
            ++n2;
        }
        return isDateString;
    }

    public Cell setNumberValue(String numString) {
        this._cellType = CellType.NUMBER;
        this.removeReferenceFromResolver();
        this._value = Element.newElement(Element.ElementType.NUMBER, new BigDecimal(numString, this._sheet.getMathContext()));
        this.getCalculator().calc(this);
        this.clearForumlaMembers();
        return this;
    }

    public Cell setStringValue(String string) {
        this._cellType = CellType.STRING;
        this.removeReferenceFromResolver();
        this._value = Element.newElement(Element.ElementType.STRING, string);
        this.getCalculator().calc(this);
        this.clearForumlaMembers();
        return this;
    }

    public Cell setBooleanValue(boolean bool) {
        this._cellType = CellType.BOOLEAN;
        this.removeReferenceFromResolver();
        this._value = Element.newElement(Element.ElementType.BOOLEAN, bool);
        this.getCalculator().calc(this);
        this.clearForumlaMembers();
        return this;
    }

    public Cell setDateValue(Date date) {
        this._cellType = CellType.DATE;
        this.removeReferenceFromResolver();
        this._value = Element.newElement(Element.ElementType.DATE, date.getTime() + (long)TimeZone.getDefault().getRawOffset());
        this.getCalculator().calc(this);
        this.clearForumlaMembers();
        return this;
    }

    public Cell setFormula(String formula) {
        this._cellType = CellType.FORMULA;
        this.removeReferenceFromResolver();
        if (formula != null && formula.length() > 0 && formula.substring(0, 1).equals("=")) {
            formula = formula.substring(1);
        }
        this._formula = formula;
        Element[] infixElem = FormulaParser.split(this._formula, this._sheet.getMathContext(), this.getCalculator().getFunctionFactory());
        if (infixElem.length == 1 && infixElem[0].getType() == Element.ElementType.ERROR) {
            this._status = CellStatus.ERROR;
            this._value = infixElem[0];
            this._sheet.addErrorCell(this);
            this.getCalculator().recalcReferencingCells(this);
            return this;
        }
        Element errorElem = FormulaParser.checkInfixNotation(infixElem);
        if (errorElem != null) {
            this._status = CellStatus.ERROR;
            this._value = errorElem;
            this._sheet.addErrorCell(this);
            this.getCalculator().recalcReferencingCells(this);
            return this;
        }
        this._formulaRPN = FormulaParser.infixToRPN(infixElem, this._sheet.getMathContext());
        if (this._formulaRPN.length == 1 && this._formulaRPN[0].getType() == Element.ElementType.ERROR) {
            this._status = CellStatus.ERROR;
            this._value = this._formulaRPN[0];
            this._formulaRPN = null;
            this._sheet.addErrorCell(this);
            this.getCalculator().recalcReferencingCells(this);
            return this;
        }
        Resolver resolver = this._sheet.getBook().getResolver();
        Element[] elementArray = this._formulaRPN;
        int n = this._formulaRPN.length;
        int n2 = 0;
        while (n2 < n) {
            Element elem = elementArray[n2];
            switch (elem.getType()) {
                case REFERENCE: {
                    resolver.registReferences(this, elem.getCellReference());
                    break;
                }
                case GROUP_REFERENCE: {
                    resolver.registGroupReferences(this, elem.getGroupReference());
                    break;
                }
                case TABLE_REFERENCE: {
                    resolver.registTableReferences(this, elem.getTableReference());
                    break;
                }
            }
            ++n2;
        }
        this._status = CellStatus.REQUIRE_CALCULATION;
        this.getCalculator().calc(this);
        this._sheet.removeErrorCell(this);
        return this;
    }

    public Cell setEmptyValue() {
        this._cellType = CellType.EMPTY;
        this.setValue(emptyElement);
        return this;
    }

    private void removeReferenceFromResolver() {
        Resolver resolver = this.getSheet().getBook().getResolver();
        if (this._formulaRPN != null) {
            Element[] elementArray = this._formulaRPN;
            int n = this._formulaRPN.length;
            int n2 = 0;
            while (n2 < n) {
                Element elem = elementArray[n2];
                switch (elem.getType()) {
                    case REFERENCE: {
                        resolver.removeReferences(this, elem.getCellReference());
                    }
                }
                ++n2;
            }
        }
    }

    public static boolean isValidCellName(String cellName) {
        return _cellNamePattern.matcher(cellName).matches();
    }

    public static boolean isValidFullyQualifiedCellName(String fullyQualifiedCellName) {
        return _fullyQualifiedCellNamePattern.matcher(fullyQualifiedCellName).matches();
    }

    private Calculator getCalculator() {
        return this._sheet.getBook().getCalculator();
    }

    private void clearForumlaMembers() {
        this._formula = null;
        this._formulaRPN = null;
    }

    public String toString() {
        return String.valueOf(this._name) + "=" + this._value.toString();
    }

    @Override
    public int compareTo(Cell o) {
        return this.getFullyQualifiedName().compareTo(o.getFullyQualifiedName());
    }

    public boolean equals(Object obj) {
        return obj instanceof Cell && this.hashCode() == ((Cell)obj).hashCode();
    }

    public int hashCode() {
        return this.getFullyQualifiedName().hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CellStatus {
        REQUIRE_CALCULATION,
        UNDER_CALCULATION,
        CALCULATED,
        ERROR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CellType {
        EMPTY,
        FORMULA,
        NUMBER,
        STRING,
        BOOLEAN,
        DATE;

    }
}

