/*
 * Decompiled with CFR 0.152.
 */
package com.nissy_ki_chi.jpicosheet.core;

import com.nissy_ki_chi.jpicosheet.core.Book;
import com.nissy_ki_chi.jpicosheet.core.Cell;
import com.nissy_ki_chi.jpicosheet.core.Element;
import com.nissy_ki_chi.jpicosheet.core.Function;
import com.nissy_ki_chi.jpicosheet.core.FunctionFactory;
import com.nissy_ki_chi.jpicosheet.core.ReferenceNotFoundException;
import com.nissy_ki_chi.jpicosheet.core.Resolver;
import com.nissy_ki_chi.jpicosheet.core.Sheet;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Calculator {
    private Book _book;
    private boolean _recalcEnabled;
    private FunctionFactory _functionFactory;

    public Calculator(Book book) {
        this._book = book;
        this._recalcEnabled = true;
        this._functionFactory = new FunctionFactory();
        this._functionFactory.loadBuiltinFunctions();
    }

    void calc(String cellname) throws ReferenceNotFoundException {
        this.calc(this._book.getResolver().getCell(cellname));
    }

    void calc(Cell cell) {
        if (this._recalcEnabled) {
            this.doCalc(cell);
            this.recalcReferencingCells(cell);
        }
    }

    void calc(Set<Cell> cells) {
        for (Cell cell : cells) {
            this.calc(cell);
        }
    }

    void recalcEnable() {
        this._recalcEnabled = true;
        ArrayList<Cell> recalcCells = new ArrayList<Cell>();
        for (Sheet sheet : this._book.getSheets()) {
            for (Cell cell : sheet.getCells()) {
                if (!cell.getCellType().equals((Object)Cell.CellType.FORMULA)) continue;
                cell.setStatus(Cell.CellStatus.REQUIRE_CALCULATION);
                recalcCells.add(cell);
            }
        }
        for (Cell cell : recalcCells) {
            this.doCalc(cell);
        }
    }

    void recalcDisable() {
        this._recalcEnabled = false;
    }

    boolean isRecalcEnable() {
        return this._recalcEnabled;
    }

    void recalcReferencingCells(Cell cell) {
        Resolver resolver = this._book.getResolver();
        Set<Cell> recalcCells = resolver.getReferencingCells(cell);
        this.recalcReferencingCells(recalcCells);
    }

    void recalcReferencingCells(Collection<Cell> recalcCells) {
        for (Cell refCell : recalcCells) {
            refCell.setStatus(Cell.CellStatus.REQUIRE_CALCULATION);
        }
        for (Cell refCell : recalcCells) {
            this.doCalc(refCell);
        }
    }

    FunctionFactory getFunctionFactory() {
        return this._functionFactory;
    }

    private void doCalc(Cell cell) {
        if (cell.getCellType() != Cell.CellType.FORMULA) {
            return;
        }
        if (cell.getStatus() != Cell.CellStatus.REQUIRE_CALCULATION) {
            return;
        }
        cell.setStatus(Cell.CellStatus.UNDER_CALCULATION);
        if (cell.getFormulaRPN().length == 0) {
            cell.setEmptyValue();
            cell.setStatus(Cell.CellStatus.CALCULATED);
            return;
        }
        MathContext mc = cell.getSheet().getMathContext();
        Stack<Element> calcStack = new Stack<Element>();
        Element lastValue = null;
        boolean useLastValue = false;
        int i = 0;
        while (i < cell.getFormulaRPN().length) {
            Element token = cell.getFormulaRPN()[i];
            block2 : switch (token.getType()) {
                case NUMBER: {
                    calcStack.push(token);
                    break;
                }
                case STRING: {
                    calcStack.push(token);
                    break;
                }
                case BOOLEAN: {
                    calcStack.push(token);
                    break;
                }
                case REFERENCE: {
                    Element refCelValue = this.getReferencesCellValue(token, cell.getSheet());
                    if (refCelValue.getType() != Element.ElementType.ERROR) {
                        calcStack.push(refCelValue);
                        break;
                    }
                    cell.setValue(refCelValue);
                    cell.setStatus(Cell.CellStatus.ERROR);
                    return;
                }
                case GROUP_REFERENCE: {
                    Collection<Cell> cells;
                    try {
                        cells = this._book.getResolver().getCellsFromGroup(token.getGroupReference());
                        this.recalcIfRequired(cells);
                        calcStack.push(token);
                        break;
                    }
                    catch (ReferenceNotFoundException e) {
                        cell.setValue(Element.newElement(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_REFERENCES));
                        cell.setStatus(Cell.CellStatus.ERROR);
                        return;
                    }
                }
                case TABLE_REFERENCE: {
                    Collection<Cell> cells;
                    try {
                        cells = this._book.getResolver().getCellsFromTable(token.getTableReference());
                        this.recalcIfRequired(cells);
                        calcStack.push(token);
                        break;
                    }
                    catch (ReferenceNotFoundException e) {
                        cell.setValue(Element.newElement(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_REFERENCES));
                        cell.setStatus(Cell.CellStatus.ERROR);
                        return;
                    }
                }
                case FUNCTION: {
                    this.operateFunction(calcStack, token, mc, this._book.getResolver());
                    break;
                }
                case OPERATOR: {
                    switch (token.getOperator()) {
                        case USE_LAST_RVALUE: {
                            useLastValue = true;
                            break block2;
                        }
                        case COMMA: {
                            calcStack.push(token);
                            break block2;
                        }
                        case LEFT_PARENTHESIS: 
                        case RIGHT_PARENTHESIS: 
                        case PLUS: 
                        case MINUS: 
                        case TIMES: 
                        case DIVIDE: 
                        case POWER: 
                        case UNARY_PLUS: 
                        case UNARY_MINUS: {
                            lastValue = this.operateArithmetic(calcStack, token, mc, this._book.getResolver());
                            useLastValue = false;
                            break block2;
                        }
                        case LESS_THAN: 
                        case LESS_EQUAL: 
                        case EQUALS: 
                        case NOT_EQUALS: 
                        case GRATER_EQUAL: 
                        case GRATOR_THAN: {
                            lastValue = useLastValue ? this.operateComparison(calcStack, token, mc, this._book.getResolver(), lastValue) : this.operateComparison(calcStack, token, mc, this._book.getResolver(), null);
                            useLastValue = false;
                            break block2;
                        }
                        case CONCATENATE: {
                            lastValue = this.operateString(calcStack, token, mc, this._book.getResolver());
                            useLastValue = false;
                            break block2;
                        }
                    }
                    assert (false) : "\u51e6\u7406\u3055\u308c\u306a\u3044\u30aa\u30da\u30ec\u30fc\u30bf\uff1a" + token.toString();
                    break;
                }
                default: {
                    assert (false) : "\u51e6\u7406\u3055\u308c\u306a\u3044\u30a8\u30ec\u30e1\u30f3\u30c8\uff1a" + token.toString();
                    break;
                }
            }
            ++i;
        }
        assert (calcStack.size() == 1) : "\u8a08\u7b97\u7d42\u4e86\u6642\u70b9\u3067\u8a08\u7b97\u30b9\u30bf\u30c3\u30af\u4e2d\u306eElement\u6570\u304c1\u3067\u306a\u3051\u308c\u3070\u306a\u3089\u306a\u3044";
        cell.setValue((Element)calcStack.pop());
        cell.setStatus(Cell.CellStatus.CALCULATED);
    }

    private Element getReferencesCellValue(Element referenceElement, Sheet referencesSheet) {
        Cell referCell = this.getReferencesCell(referenceElement, referencesSheet);
        if (referCell == null) {
            return Element.newElement(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_REFERENCES);
        }
        this.recalcIfRequired(referCell);
        return referCell.getValue();
    }

    private Cell getReferencesCell(Element referenceElement, Sheet referencesSheet) {
        Cell referCell;
        try {
            String referenceCellName = !Cell.isValidFullyQualifiedCellName(referenceElement.getCellReference()) ? String.valueOf(referencesSheet.getName()) + "!" + referenceElement.getCellReference() : referenceElement.getCellReference();
            referCell = this._book.getResolver().getCell(referenceCellName);
        }
        catch (ReferenceNotFoundException e) {
            return null;
        }
        catch (IllegalStateException e) {
            throw new AssertionError((Object)e.getMessage());
        }
        return referCell;
    }

    private void recalcIfRequired(Collection<Cell> cells) {
        for (Cell cell : cells) {
            this.recalcIfRequired(cell);
        }
    }

    private void recalcIfRequired(Cell cell) {
        if (cell.getStatus() == Cell.CellStatus.UNDER_CALCULATION) {
            cell.setValue(Element.newElement(Element.ElementType.ERROR, (Object)Element.ErrorType.CIRCULER_REFERENCE));
            cell.setStatus(Cell.CellStatus.ERROR);
        }
        if (cell.getStatus() == Cell.CellStatus.REQUIRE_CALCULATION) {
            this.doCalc(cell);
        }
    }

    private Element operateArithmetic(Stack<Element> calcStack, Element operatorElem, MathContext mc, Resolver resolver) {
        assert (operatorElem.getType() == Element.ElementType.OPERATOR && operatorElem.getOperator().isArithmeticOperator()) : "\u4e0d\u6b63\u306a\u6f14\u7b97\u5b50\u30a8\u30ec\u30e1\u30f3\u30c8\uff1a" + operatorElem.toString();
        switch (operatorElem.getOperator()) {
            case PLUS: 
            case MINUS: 
            case TIMES: 
            case DIVIDE: 
            case POWER: {
                Element rElem = calcStack.pop();
                Element lElem = calcStack.pop();
                if (rElem.getType() != Element.ElementType.NUMBER && rElem.getType() != Element.ElementType.BOOLEAN && rElem.getType() != Element.ElementType.DATE && rElem.getType() != Element.ElementType.EMPTY || lElem.getType() != Element.ElementType.NUMBER && lElem.getType() != Element.ElementType.BOOLEAN && lElem.getType() != Element.ElementType.DATE && lElem.getType() != Element.ElementType.EMPTY) {
                    calcStack.push(Element.newElement(Element.ElementType.ERROR, (Object)Element.ErrorType.WRONG_VALUE));
                    break;
                }
                BigDecimal rValue = rElem.getNumber();
                BigDecimal lValue = lElem.getNumber();
                Element.ElementType newElemType = null;
                newElemType = rElem.getType() == Element.ElementType.DATE || lElem.getType() == Element.ElementType.DATE ? Element.ElementType.DATE : Element.ElementType.NUMBER;
                switch (operatorElem.getOperator()) {
                    case PLUS: {
                        BigDecimal resultValue = lValue.add(rValue, mc);
                        calcStack.push(Element.newElement(newElemType, resultValue));
                        break;
                    }
                    case MINUS: {
                        BigDecimal resultValue = lValue.subtract(rValue, mc);
                        calcStack.push(Element.newElement(newElemType, resultValue));
                        break;
                    }
                    case TIMES: {
                        BigDecimal resultValue = lValue.multiply(rValue, mc);
                        calcStack.push(Element.newElement(newElemType, resultValue));
                        break;
                    }
                    case DIVIDE: {
                        if (rValue.signum() == 0) {
                            calcStack.push(Element.newElement(Element.ElementType.ERROR, (Object)Element.ErrorType.DIVIDE_BY_ZERO));
                            break;
                        }
                        BigDecimal resultValue = lValue.divide(rValue, mc);
                        calcStack.push(Element.newElement(newElemType, resultValue));
                        break;
                    }
                    case POWER: {
                        BigDecimal resultValue = new BigDecimal(Math.pow(lValue.doubleValue(), rValue.doubleValue()));
                        calcStack.push(Element.newElement(newElemType, resultValue));
                    }
                }
                break;
            }
            case UNARY_PLUS: 
            case UNARY_MINUS: {
                Element rElem = calcStack.pop();
                if (rElem.getType() != Element.ElementType.NUMBER) {
                    calcStack.push(Element.newElement(Element.ElementType.ERROR, (Object)Element.ErrorType.WRONG_VALUE));
                }
                switch (operatorElem.getOperator()) {
                    case UNARY_PLUS: {
                        calcStack.push(rElem);
                        break;
                    }
                    case UNARY_MINUS: {
                        BigDecimal rValue = rElem.getNumber();
                        BigDecimal resultValue = rValue.negate();
                        calcStack.push(Element.newElement(Element.ElementType.NUMBER, resultValue));
                    }
                }
                break;
            }
            default: {
                assert (false) : "\u51e6\u7406\u3055\u308c\u306a\u3044\u30aa\u30da\u30ec\u30fc\u30bf\uff1a" + operatorElem.toString();
                break;
            }
        }
        return calcStack.peek();
    }

    private Element operateComparison(Stack<Element> calcStack, Element operatorElem, MathContext mc, Resolver resolver, Element lastValue) {
        assert (operatorElem.getType() == Element.ElementType.OPERATOR && operatorElem.getOperator().isComparisonOperator()) : "\u4e0d\u6b63\u306a\u6f14\u7b97\u5b50\u30a8\u30ec\u30e1\u30f3\u30c8\uff1a" + operatorElem.toString();
        Element rElem = calcStack.pop();
        Element lElem = calcStack.pop();
        Element rOperand = rElem;
        Element lOperand = null;
        lOperand = lastValue != null ? lastValue : lElem;
        if (lOperand.getType() != rOperand.getType()) {
            calcStack.push(Element.newElement(Element.ElementType.BOOLEAN, false));
            return rElem;
        }
        boolean result = false;
        block0 : switch (operatorElem.getOperator()) {
            case EQUALS: {
                switch (lOperand.getType()) {
                    case NUMBER: {
                        result = lOperand.getNumber().compareTo(rOperand.getNumber()) == 0;
                        break block0;
                    }
                    case STRING: {
                        result = lOperand.getString().equals(rOperand.getString());
                        break block0;
                    }
                    case BOOLEAN: {
                        result = lOperand.getBoolean().equals(rOperand.getBoolean());
                        break block0;
                    }
                    case DATE: {
                        result = false;
                    }
                }
                assert (false) : "\u4e0d\u6b63\u306a\u30a8\u30ec\u30e1\u30f3\u30c8\uff1a" + operatorElem.toString();
                break;
            }
            case NOT_EQUALS: {
                switch (lOperand.getType()) {
                    case NUMBER: {
                        result = lOperand.getNumber().compareTo(rOperand.getNumber()) != 0;
                        break block0;
                    }
                    case STRING: {
                        result = !lOperand.getString().equals(rOperand.getString());
                        break block0;
                    }
                    case BOOLEAN: {
                        result = !lOperand.getBoolean().equals(rOperand.getBoolean());
                        break block0;
                    }
                    case DATE: {
                        result = false;
                    }
                }
                assert (false) : "\u4e0d\u6b63\u306a\u30a8\u30ec\u30e1\u30f3\u30c8\uff1a" + operatorElem.toString();
                break;
            }
            case LESS_THAN: {
                switch (lOperand.getType()) {
                    case NUMBER: {
                        result = lOperand.getNumber().compareTo(rOperand.getNumber()) < 0;
                        break block0;
                    }
                    case STRING: {
                        result = false;
                        break block0;
                    }
                    case BOOLEAN: {
                        result = false;
                        break block0;
                    }
                    case DATE: {
                        result = false;
                    }
                }
                assert (false) : "\u4e0d\u6b63\u306a\u30a8\u30ec\u30e1\u30f3\u30c8\uff1a" + operatorElem.toString();
                break;
            }
            case LESS_EQUAL: {
                switch (lOperand.getType()) {
                    case NUMBER: {
                        result = lOperand.getNumber().compareTo(rOperand.getNumber()) <= 0;
                        break block0;
                    }
                    case STRING: {
                        result = false;
                        break block0;
                    }
                    case BOOLEAN: {
                        result = false;
                        break block0;
                    }
                    case DATE: {
                        result = false;
                    }
                }
                assert (false) : "\u4e0d\u6b63\u306a\u30a8\u30ec\u30e1\u30f3\u30c8\uff1a" + operatorElem.toString();
                break;
            }
            case GRATOR_THAN: {
                switch (lOperand.getType()) {
                    case NUMBER: {
                        result = lOperand.getNumber().compareTo(rOperand.getNumber()) > 0;
                        break block0;
                    }
                    case STRING: {
                        result = false;
                        break block0;
                    }
                    case BOOLEAN: {
                        result = false;
                        break block0;
                    }
                    case DATE: {
                        result = false;
                    }
                }
                assert (false) : "\u4e0d\u6b63\u306a\u30a8\u30ec\u30e1\u30f3\u30c8\uff1a" + operatorElem.toString();
                break;
            }
            case GRATER_EQUAL: {
                switch (lOperand.getType()) {
                    case NUMBER: {
                        result = lOperand.getNumber().compareTo(rOperand.getNumber()) >= 0;
                        break block0;
                    }
                    case STRING: {
                        result = false;
                        break block0;
                    }
                    case BOOLEAN: {
                        result = false;
                        break block0;
                    }
                    case DATE: {
                        result = false;
                    }
                }
                assert (false) : "\u4e0d\u6b63\u306a\u30a8\u30ec\u30e1\u30f3\u30c8\uff1a" + operatorElem.toString();
                break;
            }
            default: {
                assert (false) : "\u51e6\u7406\u3055\u308c\u306a\u3044\u30aa\u30da\u30ec\u30fc\u30bf\uff1a" + operatorElem.toString();
                break;
            }
        }
        if (lastValue != null) {
            assert (lElem.getType() == Element.ElementType.BOOLEAN) : "lElem\u304cBOOLEAN\u3067\u306a\u3044\uff1a" + lElem.toString();
            result = lElem.getBoolean() != false && result;
        }
        calcStack.push(Element.newElement(Element.ElementType.BOOLEAN, result));
        return rElem;
    }

    private Element operateString(Stack<Element> calcStack, Element operatorElem, MathContext mc, Resolver resolver) {
        assert (operatorElem.getType() == Element.ElementType.OPERATOR && operatorElem.getOperator().isStringOperator()) : "\u4e0d\u6b63\u306a\u6f14\u7b97\u5b50\u30a8\u30ec\u30e1\u30f3\u30c8\uff1a" + operatorElem.toString();
        Element rElem = calcStack.pop();
        Element lElem = calcStack.pop();
        calcStack.push(Element.newElement(Element.ElementType.STRING, String.valueOf(lElem.getString()) + rElem.getString()));
        return calcStack.peek();
    }

    private Element operateFunction(Stack<Element> calcStack, Element operatorElem, MathContext mc, Resolver resolver) {
        switch (operatorElem.getType()) {
            case FUNCTION: {
                Element topElem;
                int argCount = 0;
                while (calcStack.size() > 0 && (topElem = calcStack.peek()).getType() == Element.ElementType.OPERATOR && topElem.getOperator() == Element.Operator.COMMA) {
                    ++argCount;
                    calcStack.pop();
                }
                Element[] args = new Element[argCount];
                int i = argCount - 1;
                while (i >= 0) {
                    args[i] = calcStack.pop();
                    --i;
                }
                Function func = this._functionFactory.getFunctionInstance(operatorElem.getString());
                if (func == null) {
                    calcStack.push(Element.newElement(Element.ElementType.ERROR, (Object)Element.ErrorType.INVALID_FORMULA));
                }
                calcStack.push(func.call(args, mc, resolver));
            }
        }
        return Element.newElement(Element.ElementType.EMPTY);
    }
}

