<?php
/*
 * Following templatevars are not supported
 * karma, daylink, karmaposlink, karmaneglink, new, popup, relevance
 */
class jp_Nucleus_template extends jeans {
/*
 * Templates: Category Lists

The category lists are formatted as listed below:

categorylist header
  categorylist listitem (repeated)
categorylist footer

Available variables: (in the header and footer, only blogid, blogurl and self are allowed)
Name 	Description
blogid 	ID of the weblog
blogurl 	URL of the blog (as defined in blogsettings)
self 	Current page, without parameters (e.g. index.php)
catlink 	a link to the most recent items for a category, which you can embed in a <a href=".."> tag.
catid 	Category ID
catname 	Category name
catdesc 	Category description
catiscurrent 	yes if category is currently selected, no if it is not. Useful to style current category.
currentcat 	Synonym of catiscurrent
 */
	static private function select_template(&$data){
		if (preg_match('/([a-zA-Z0-9]+)\.inc$/',$data['skin'],$m)) return $m[1];
		else return 'unknown';
	}
	static public function tag_blogid(&$data){
		self::p($data['jp']['nucleus']['blogid']);
	}
	static public function tag_blogurl(&$data){
		switch(self::select_template($data)){
			case 'catlist':
				return self::p(blog::setting('url',$data['jp']['nucleus']['blogid']));
			case 'bloglist':
				return self::p($data['link']);	
		}
	}
	static public function tag_self(&$data){
		self::p(_CONF_SELF);
	}
	static public function tag_catlink(&$data){
		self::p($data['link']);
	}
	static public function tag_catid(&$data){
		self::p($data['id']);
	}
	static public function tag_catname(&$data){
		self::p($data['name']);
	}
	static public function tag_catdesc(&$data){
		self::p($data['desc']);
	}
	static public function if_catiscurrent(&$data){
		return $_GET['sgid']==$data['id'];
	}
	static public function if_currentcat(&$data){
		return self::if_catiscurrent($data);
	}
/*
 * Templates: Blog Lists

The blog lists are formatted as listed below:

bloglist header
  bloglist listitem (repeated)
bloglist footer

Available variables in list item field:
Name 	Description
bloglink 	URL of the blog (as generated by createBlogIdLink() function)
blogurl 	URL of the blog (as defined in blogsettings)
blogdesc 	Description of the blog
blogname 	Name of the blog (either full or short, depending on skinvar parameter).

Available variables in header and footer fields:
Name 	Description
siteurl 	URL of the site (as defined in global settings)
sitename 	Name of the site (as defined in global settings).
 */	
	static public function tag_bloglink(&$data){
		self::p($data['link']);
	}
	/*static public function tag_blogurl(&$data){
	 * see above;
	}*/
	static public function tag_blogdesc(&$data){
		self::p($data['desc']);
	}
	static public function tag_blogname(&$data){
		self::p($data['name']);
	}
	static public function tag_siteurl(&$data){
		self::p(_CONF_URL_INDEX);
	}
	static public function tag_sitename(&$data){
		self::p(_CONF_SITE_NAME);
	}
/*
 * Template variables: Basic variables

All these variables concern the item that's currently being parsed.
Name 	Description
title 	item title
body 	body text
more 	extended text
category 	name of the category
categorylink 	raw link to the category
karma 	karma score
authorlink 	raw link to the author
itemlink 	raw permanent link for the item
author 	name of the author
smartbody 	either the body text or the extended text
morelink 	'read more'-link
date 	Formatted date
time 	Formatted time
daylink 	raw link to the daily archive
comments 	comments block or commentcount
itemid 	ID of the item
blogurl 	URL of the blog

Template variables: Advanced variables
Name 	Description
authorid 	ID of the current items author
blogid 	ID of the blog
catid 	ID of the category for the current item
query 	search query (if there is one)
syndicate_title 	Syndicated title
syndicate_description 	Syndicated body text
karmaposlink 	raw vote link
karmaneglink 	raw vote link
new 	'New Item!'-text
include 	includes a file, whithout parsing
parsedinclude 	includes a file, parsing it
phpinclude 	includes a file, parsing by PHP
plugin 	executes a plugin
edit 	inserts an 'edit this item' link
editlink 	raw 'edit item' link (links to bookmarklet)
editpopupcode 	javascript code to open a popup window for editlink
skinfile 	includes the correct URL for a file belonging to an imported skin
set 	sets a parser property
image 	inline image from media library
popup 	popup image from media dir
media 	other media object from media dir
relevance 	Includes the 'search hit relevance' in templates that display search results
 */
	public static function tag_more(&$data){
		self::echo_html($data['more']);
	}
	public static function tag_editlink(&$data){
		self::p(_CONF_URL_ADMIN.'?page=edititem&itemid='.$data['id']);
	}
	public static function tag_editpopupcode(&$data){
		self::p('window.open(this.href);return false;');
	}
	public static function tag_morelink(&$data){
		if (0<strlen($data['more'])) view::tag_template($data,'more');
	}
	public static function tag_comments(&$data,$maxtoshow=0){
		$skin=preg_replace('/_item\.inc$/','_comment.inc',$data['skin']);
		if ($data['comments']==0) {
			view::tag_template($data,'none',$skin);
		} elseif ($maxtoshow<$data['comments']) {
			view::tag_template($data,'many',$skin);
		} else {
			comments::tag_comments($data,$skin);
		}
	}
	public static function tag_body(&$data){
		self::echo_html($data['body']);
	}
	public static function tag_smartbody(&$data){
		if (0<strlen($data['more'])) self::echo_html($data['more']);
		else self::echo_html($data['body']);
	}
	public static function tag_itemid(&$data){
		self::p($data['id']);
	}
	public static function tag_authorid(&$data){
		self::p($data['author']);
	}
	public static function tag_edit(&$data){
		if (!member::is_admin()) return;
		view::tag_template($data,'edit');
	}
	public static function tag_author(&$data){
		self::p($data['aname']);
	}
	public static function tag_authorlink(&$data){
		self::p($data['alink']);
	}
	public static function tag_category(&$data){
		self::p($data['cname']);
	}
	public static function tag_categorylink(&$data){
		self::p($data['clink']);
	}
	public static function tag_itemlink(&$data){
		self::p($data['link']);
	}
	public static function tag_date(&$data){
		view::tag_strftime($data,'date');
	}
	public static function tag_time(&$data){
		view::tag_strftime($data,'time');
	}
	public static function tag_title(&$data,$format = ''){
		switch($format){
			case 'raw':
				return self::echo_html($data['title']);
			case 'xml':
			case 'attribute':
			default:
				return self::p($data['title']);
		}
	}
/*
 * Template variables: Comments
Name 	Description
body 	comment body
user 	user name
userid 	users URL or e-mail address
userlink 	a smart link to either the e-mail or URL for non members, or the member detail page for members. Note: this link already includes the <a href="..."> and </a> tags ! (when no valid URL or e-mail is available, only the name of the member will be shown)
userlinkraw 	same as above, but without the <a href.., empty when no valid URL or e-mail available
useremail 	the e-mail address of the user, empty if the e-mail address was not provided by the user
userwebsite 	the URL of the users website, empty if the URL was not provided by the user
userwebsitelink 	a smart link to URL for non members, or the member detail page for members. Note: this link already includes the <a href="..."> and </a> tags ! (when no valid URL, only the name of the member will be shown)
memberid 	ID of the member (0 for non-members)
commentcount 	total amount of comments for the item
commentword 	1 'comment', 2 'comments'
date 	date on which comment was added
time 	time at which comment was added
host 	host from where comment was added
ip 	IP-address from where comment was added
commentid 	ID of the current comment
itemid 	ID of the current item
itemlink 	link to the detailed item page
itemtitle 	Title of the current item
blogid 	ID of the weblog
blogurl 	URL of the weblog
authtext 	the extra text for members, empty for non members
short 	a cut off version of the body, which truncates after the first line break. A link is added at the end according to the template
excerpt 	the body of the comment, cut at 60 characters and appended with '...'
timestamp 	time at which comment was added
include 	includes a file, whithout parsing
parsedinclude 	includes a file, parsing it
phpinclude 	includes a file, parsing by PHP
plugin 	executes a plugin
skinfile 	includes the correct URL for a file belonging to an imported skin
set 	sets a parser property
 */
	/*
	 * 
	 */
	static public function tag_memberid(&$data){
		self::p($data['author']);
	}
	static public function tag_userlinkraw(&$data){
		self::p($data['link']);
	}
	static public function tag_ip(&$data){
		self::p($data['ip']);
	}
	static public function tag_user(&$data){
		self::p($data['user']);
	}
	static public function tag_commentcount(&$data){
		self::p($data['comments']);
	}
	static public function tag_commentword(&$data){
		switch($data['comments']){
			case 0:
			case 1:
				return view::tag_template($data,'one');
			default:
				return view::tag_template($data,'two');
		}
	}
	static public function tag_itemtitle(&$data){
		self::p($data['title']);
	}
/*
 * Templates: Archive Lists

The archive lists are formatted as listed below:

archivelist header
  archivelist listitem (repeated for each archive)
archivelist footer

Available variables: (in the header and footer, only blogid is allowed)
Name 	Description
blogid 	ID of the weblog
archivelink 	link to the archive, which you can embed in a <a href=".."> tag.
month 	Number of the month (2 digits: 01-12)
year 	Year (4 digits)
day 	Day of month (2 digits; only when in day mode)
 */
	static public function tag_archivelink(&$data){
		self::p($data['link']);
	}
}