<?php
/*
 * Jeans CMS (GPL license)
 * $Id: jp_Nucleus_skin.php 280 2010-09-13 23:48:54Z kmorimatsu $
 */
/*
 * Notes:
 * 
 * The template must be stored in skin directry as follows.
 * For example, 'default/index' will be changed to 'templates/default_index_item.inc' etc. 
 */

class jp_Nucleus_skin extends jeans {
	static private function convert_template($skin,$type){
		if (substr($skin,-4)=='.inc') return $skin;
		return 'templates/'.preg_replace('/[^a-zA-Z0-9]/','_',$skin)."_$type.inc";
	}
	static public function tag_additemform(&$data){
		view::tag_parse($data,'/jp/nucleus/forms/additemform.inc');
	}
	static public function tag_addlink(&$data){
		if (!member::is_admin()) return;
		self::p(_CONF_URL_ADMIN.'?page=edititem&itemid=0&sgid='.group::setting('id'));
	}
	static public function tag_addpopupcode(&$data){
		?>
			if (event &amp;&amp; event.preventDefault) event.preventDefault();
			winbm=window.open(this.href,&amp;jeansbm&amp;,&amp;scrollbars=yes,width=600,height=500,left=10,top=10,status=yes,resizable=yes&amp;);
			winbm.focus();
			return false;
		<?php
	}
	static public function tag_adminurl(&$data){
		self::p(_CONF_URL_ADMIN);
	}
	static public function tag_archive(&$data,$skin,$category=false,$blogid=false){
		$skin=self::convert_template($skin,'item');
		if ($category) {
			$temp_globals=new jp_Nucleus_temp_global('_GET','sgid',$category);
		}
		blog::tag_narrowby($data,'archive');
		self::blog($data,$skin,$blogid);
	}
	static public function tag_archivedate(&$data,$locale=false,$format=false){
		if (!$format) {
			switch(strlen($_GET['archive'])){
				case 4:
					$format='%Y';
					break;
				case 7:
					$format='%m/%Y';
					break;
				case 10:
					$format='%m/%d/%Y';		
			}
		}
		blog::tag_archivedate($data,$format);
	}
	static public function tag_archivedaylist(&$data){
		self::tag_archivelist($data,$template,false,'day');
	}
	static public function tag_archivelink(&$data,$linktext=false){
		if (self::usetemplate($data)) return jp_Nucleus_template::tag_archivelink($data);
		$url=view::create_link(array('archivelist'=>blog::setting('id')));
		if ($linktext==false) $html='<%url%>';
		else $html='<a href="<%url%>"><%text%></a>';
		$array=array('url'=>$url,'text'=>$linktext);
		self::echo_html($html,$array);
	}
	static public function tag_archivelist(&$data,$template,$blogid=false,$mode='month'){
		$skin=self::convert_template($template,'archivelist');
		$ut=new jp_nucleus_use_template($data);
		blog::tag_archivelist($data,$skin,$blogid,$mode);
	}
	static public function tag_archivetype(&$data){
		/*Skinvar: archivetype
		Either day or month, indicating which type of archive is currently being shown
		Arguments
		None
		Skintypes
		archive*/
		switch(strlen($_GET['archive'])){
			case 4:
				return self::t('_JEANS_YEAR');
			case 7:
				return self::t('_JEANS_MONTH');
			case 10:
				return self::t('_JEANS_DAY');
		}
		self::p("<%archivetype%>","hsc");
	}
	static public function tag_archiveyearlist(&$data){
		self::tag_archivelist($data,$template,false,'year');
	}
	static public function tag_blog(&$data,$template,$amount=10,$category=false,$blogid=false){
		$skin=self::convert_template($template,'item');
		if ($category) {
			$temp_globals=new jp_Nucleus_temp_global('_GET','sgid',$category);
		}
		blog::tag_narrowby($data,'category');
		self::blog($data,$skin,$blogid,$amount);
	}
	static private function blog(&$data,$skin,$blogid=false,$amount=10){
		$ut=new jp_nucleus_use_template($data);
		blog::tag_blog($data,$skin,$amount,true,$blogid);
	}
	static private function usetemplate(&$data){
		return !empty($data['jp']['nucleus']['usetemplate']);
	}
	static public function tag_bloglist(&$data,$template){
		/*Skinvar: bloglist
		 * Optional parameters, bnametype, orderby, and direction cannot be used.
		 */
		$ut=new jp_nucleus_use_template($data);
		$skin=self::convert_template($template,'bloglist');
		blog::tag_bloglist($data,$skin);
	}
	static public function tag_blogsetting(&$data,$type){
		/*Skinvar: blogsetting
			$type: either id, url, name, or desc (short cannot be used)
		*/
		self::p(blog::setting($type));
	}
	static public function tag_category(&$data,$type='name'){
		if (self::usetemplate($data)) return jp_Nucleus_template::tag_category($data);
		blog::tag_sgsetting($data,$type);
	}
	static public function tag_categorylist(&$data,$template,$blogid=false){
		/*Skinvar: categorylist
			blogname cannot be used.  Instead, use blogid.
		*/
		$ut=new jp_nucleus_use_template($data);
		$blogid=blog::setting('id',$blogid);
		$data['jp']['nucleus']['blogid']=$blogid;
		$skin=self::convert_template($template,'catlist');
		blog::tag_categorylist($data,$skin,$blogid);
	}
	static public function tag_charset(&$data){
		self::p('UTF-8');
	}
	static public function tag_commentform(&$data){
		/*Skinvar: commentform
		 * destinationurl is not supported
		 */
		view::tag_parse($data,'/jp/nucleus/forms/commentform.inc');
	}
	static public function tag_comments(&$data,$skin_or_maxtoshow=false){
		if (self::usetemplate($data)) return jp_Nucleus_template::tag_comments($data,$skin_or_maxtoshow);
		$ut=new jp_nucleus_use_template($data);
		comments::tag_comments($data,self::convert_template($skin_or_maxtoshow,'comment'));
	}
	static public function tag_error(&$data){
		return self::tag_errormessage($data);
	}
	static public function tag_errormessage(&$data){
		self::p(implode("\n",error::get_note()));
	}
	static public function tag_image(&$data,$type='imgtag'){
		/*Skinvar: image
		 * The type is fixed to 'imgtag'.
		 */
		if (showmedia::if_popupdb()) return showmedia::tag_imgdb($data);
		else return showmedia::tag_img($data);
	}
	static public function tag_imagepopup(&$data){
	}
	static public function tag_imagetext(&$data){
		showmedia::tag_popuptext();
	}
	static public function tag_include(&$data,$skin){
		view::tag_include($data,$skin,'html');
	}
	static public function tag_item(&$data,$template){
		$ut=new jp_nucleus_use_template($data);
		item::tag_item($data,self::convert_template($template,'item'));
	}
	static public function tag_itemid(&$data){
		if (self::usetemplate($data)) return jp_Nucleus_template::tag_itemid($data);
		item::tag_data($data,'id');
	}
	static public function tag_itemlink(&$data){
		if (self::usetemplate($data)) return jp_Nucleus_template::tag_itemlink($data);
		item::tag_data($data,'link');
	}
	static public function tag_itemtitle(&$data){
		if (self::usetemplate($data)) return jp_Nucleus_template::tag_itemtitle($data);
		item::tag_data($data,'title');
	}
	static public function tag_loginform(&$data){
		view::tag_parse($data,'/jp/nucleus/forms/loginform.inc');
	}
	static public function tag_member(&$data,$type){
		/*Skinvar: member
		 * The types, yournotes and notes cannot be used.
		 */
		if (preg_match('/^your([a-z]+)$/',$type,$m)) {
			$memberinfo=false;
			$type=strtolowerer($m[1]);
		} else {
			$memberinfo=true;
			$type=strtolower($type);
		}
		switch($type){
			case 'realname':
				$type='name';
				break;
			case 'url':
				$type='web';
				break;
			default:
				break;
		}
		if ($memberinfo) memberinfo::tag_memberinfo($data,$type);
		else member::tag_setting($data,$type);
	}
	static public function tag_membermailform(&$data){
		/*Skinvar: membermailform
		 * The options, rows, cols, and destinaion cannot be used.
		 */
		view::tag_parse($data,'/jp/nucleus/forms/membermailform.inc');
	}
	static public function tag_nextarchive(&$data){
		/*Skinvar: nextarchive
		 * This skin var is not supported.
		 * Instead, use <%nextlink%>
		 */
		self::p("<%nextarchive%>","hsc");
	}
	static public function tag_nextitem(&$data){
		item::tag_newer($data,'id');
	}
	static public function tag_nextitemtitle(&$data){
		item::tag_newer($data,'title');
	}
	static public function tag_nextlink(&$data,$linktext=false){
		if ($linktext!==false) self::echo_html('<a href="');
		if (isset($_GET['itemid'])) item::tag_newer($data,'link');
		elseif (isset($_GET['archive'])) blog::tag_archivelink($data,'newer');
		if ($linktext!==false) self::echo_html('"><%0%></a>',$linktext);
	}
	static public function tag_nucleusbutton(&$data,$file='/jeans/images/jeans.gif',$width=85,$height=31){
		$array=array('file'=>view::skinfile($data,$file), 'width'=>$width, 'height'=>$height);
		$html='<a href="http://jeanscms.sourceforge.jp/">';
		$html.='<img src="<%file%>" alt="Jeans button" width="<%width%>" height="<%height%>" />';
		$html.='</a>';
		self::echo_html($html,$array);
	}
	static public function tag_otherarchive(&$data,$blogid,$template,$category=false){
		self::tag_archive($data,$template,$category,$blogid);
	}
	static public function tag_otherarchivedaylist(&$data,$blogid,$template){
		self::tag_archivelist($data,$template,$blogid,'day');
	}
	static public function tag_otherarchivelist(&$data,$blogid,$template){
		self::tag_archivelist($data,$template,$blogid);
	}
	static public function tag_otherarchiveyearlist(&$data,$blogid,$template){
		self::tag_archivelist($data,$template,$blogid,'year');
	}
	static public function tag_otherblog(&$data,$blogid,$template,$amount=10,$category=false){
		self::tag_blog($data,$template,$amount,$category,$blogid);
	}
	static public function tag_othersearchresults(&$data,$blogid,$template,$limit=10,$category=false){
		blog::tag_narrowby($data,'search');
		self::tag_blog($data,$template,$limit,$category,$blogid);
	}
	static public function tag_parsedinclude(&$data,$skin){
		/*Skin/Templatevar: parsedinclude
		Includes a file into the output. The contents of the file is parsed by the Nucleus skin/template parser, so you can use skin/templatevars. (see phpinclude and include for other include options)
		Arguments
			filename: the name of the file to be included (either relative to the position of index.php, or absolute)
		Notes
			This tag is affected by the parser settings IncludeMode and IncludePrefix
			From inside the included file, you can call <%parsedinclude(filename)%> again. To avoid endless loops, the maximum depth level you can go is 3.
		Skintypes
		all
		Examples
		<%parsedinclude(filename.txt)%>
		<%parsedinclude(/home/user/myself/filename.txt)%>*/
		view::tag_parse($data,$skin);
	}
	static public function tag_phpinclude(&$data,$skin){
		/*Skin/Templatevar: phpinclude
		Includes a php-file into the output. The contents of the file is parsed by the PHP parser, so be careful. Nucleus skin/templatevars are not parsed! (see parsedinclude and include for other include options).
		Arguments
			filename: the name of the file to be included (either relative to the position of index.php, or absolute)
		Notes
			This tag is affected by the parser settings IncludeMode and IncludePrefix
			Your file will be included using the standard php include() command. This command will be called from inside a class method, so you'll need to declare which global variables you want to access yourself. Most of the standard variables are automatically declared global by Nucleus itself.
		Skintypes
		all
		Examples
		<%phpinclude(filename.php)%>
		<%phpinclude(/home/user/myself/filename.php)%>*/
		view::tag_parse($data,$skin);
	}
	static public function tag_plugin(&$data){
		/*Skin/Templatevar: plugin
		 * This skinvar is not supported.
		 * Instead, use <%jp.xxxxx%>
		 */
		self::p("<%plugin%>","hsc");
	}
	static public function tag_prevarchive(&$data){
		/*Skinvar: prevarchive
		 * This skinvar is not supported.
		 * Instead, use <%prevlink%>
		 */
		self::p("<%prevarchive%>","hsc");
	}
	static public function tag_preview(&$data){
		/*
		 * This skinvar is not supported
		 */
		self::p("<%preview%>","hsc");
	}
	static public function tag_previtem(&$data){
		item::tag_older($data,'id');
	}
	static public function tag_previtemtitle(&$data){
		item::tag_older($data,'title');
	}
	static public function tag_prevlink(&$data,$linktext=false){
		if ($linktext!==false) self::echo_html('<a href="');
		if (isset($_GET['itemid'])) item::tag_older($data,'link');
		elseif (isset($_GET['archive'])) blog::tag_archivelink($data,'older');
		if ($linktext!==false) self::echo_html('"><%0%></a>',$linktext);
	}
	static public function tag_query(&$data){
		self::p($_GET['query_text'],'hsc');
	}
	static public function tag_referer(&$data){
		if (isset($_SERVER['HTTP_REFERER'])) self::p($_SERVER['HTTP_REFERER']);
	}
	static public function tag_searchform(&$data,$gid=0){
		if ($gid) view::tag_parse($data,'/jp/nucleus/forms/searchform.inc',$gid);
		else view::tag_parse($data,'/jp/nucleus/forms/searchform.inc');
	}
	static public function tag_searchresults(&$data,$template,$limit=10){
		blog::tag_narrowby($data,'search');
		self::tag_blog($data,$template,$limit);
	}
	static public function tag_self(&$data){
		self::p(_CONF_SELF);
	}
	static public function tag_set(&$data){
		/*
		 * This skinvar is not supported.
		 */
		self::p("<%set%>","hsc");
	}
	static public function tag_sitevar(&$data,$type){
		switch($type){
			case 'url':
				return self::p(_CONF_URL_INDEX);
			case 'name':
				return self::p(_CONF_SITE_NAME);
			case 'admin':
				return self::p(_CONF_ADMIN_EMAIL);
		}
	}
	static public function tag_skinfile(&$data,$filename){
		return view::tag_skinfile($data,$filename);
	}
	static public function tag_skinname(&$data){
		if (preg_match('#$/([^/]+)/#',$data['skin'],$m)) self::p($m[1]);
	}
	static public function tag_sticky(&$data,$itemid,$template){
		$ut=new jp_nucleus_use_template($data);
		$skin=self::convert_template($template,'item');
		$query=self::query_select('i.id=<%itemid%> AND NOT (i.flags & <%const:sql::FLAG_INVALID%>)');
		$array=array('itemid'=>$itemid);
		view::show_using_query($data,$query,$array,$skin,array('blog','_blog_cb'),array('blog','_blog_cb2'));
	}
	static public function tag_todaylink(&$data,$linktext=false){
		if ($linktext==false) $html='<%url%>';
		else $html='<a href="<%url%>"><%text%></a>';
		$array=array('url'=>blog::setting('url'),'text'=>$linktext);
		self::echo_html($html,$array);
	}
	static public function tag_version(&$data){
		self::p('Jeans CMS ver '._JEANS_VERSION);
	}
/*
 * Skinvars: if/ifnot/else/elseif/elseifnot/endif
 * hasplugin and PluginName are not supported.
 */
	static public function if_nextitem(&$data){
		return item::if_neweris($data);
	}
	static public function if_previtem(&$data){
		return item::if_olderis($data);
	}
	static public function if_blogsetting(&$data,$key,$value){
		return blog::setting($key)==$value;
	}
	static public function if_category(&$data,$type=false,$value=false){
		switch($type){
			case 'catid':
				return blog::sgsetting('id')==$value;
			case 'catname':
				return blog::sgsetting('name')==$value;
			case false:
			default:
				return 0<blog::sgsetting('id');
		}
	}
	static public function if_skintype(&$data,$type){
		return blog::if_skintype($data,$type);
	}
	static public function if_loggedin(){
		return member::logged_in();
	}
	static public function if_archiveprevexists(&$data){
		/*
		 * Not yet implemented
		 */
		return true;	
	}
	static public function if_archivenextexists(&$data){
		/*
		 * Not yet implemented
		 */
		return true;	
	}
	static public function if_admin(){
		return member::is_admin();
	}
	static public function if_onteam(){
		return member::is_admin();
	}
	static public function if_hasplugin(){
		return false;
	}
}

class jp_Nucleus_temp_global {
	/*
	 * Usage: new jp_Nucleus_temp_global(var,key,value[,var,key,value[,var,key,value ... ]]])
	 * For example,
	 * $temp_globals=new jp_Nucleus_temp_global('_GET','sgid',$category);
	 */
	private $org_globals=array(),$args;
	public function __construct(){
		$this->args=$args=func_get_args();
		while(2<count($args)){
			$var=array_shift($args);
			$key=array_shift($args);
			$value=array_shift($args);
			if (!isset($this->org_globals[$var])) $this->org_globals[$var]=array();
			if (isset($GLOBALS[$var][$key])) $this->org_globals[$var][$key]=$GLOBALS[$var][$key];
			$GLOBALS[$var][$key]=$value;
		}
	}
	public function __destruct(){
		while(2<count($this->args)){
			$var=array_shift($this->args);
			$key=array_shift($this->args);
			$value=array_shift($this->args);
			if (isset($this->org_globals[$var][$key])) $GLOBALS[$var][$key]=$this->org_globals[$var][$key];
			else unset($GLOBALS[$var][$key]);
		}
	}
}
class jp_nucleus_use_template {
	private $data,$before;
	public function __construct(&$data){
		$this->data=&$data;
		$this->before=!empty($data['jp']['nucleus']['usetemplate']);
		$data['jp']['nucleus']['usetemplate']=true;
	}
	public function __destruct(){
		$this->data['jp']['nucleus']['usetemplate']=$this->before;
	}
}