<?php
/*
 * Jeans CMS (GPL license)
 * $Id: jp_Nucleus_admin.php 280 2010-09-13 23:48:54Z kmorimatsu $
 */

class jp_Nucleus_admin extends jeans {
	static public function init(){
		if (!member::is_admin()) {
			error::quit('_ADMIN_NO_PERMISSION');
		}
	}
	static public function tag_nucskinlist(&$data,$skin=false){
		$array=array();
		$skins=dir(_DIR_SKINS);
		while($skin=$skins->read()){
			if (!preg_match('/^[a-z0-9]+$/',$skin)) continue;
			if (!self::local_file_exists(_DIR_SKINS,$skin.'/skinbackup.xml')) continue;
			if (self::local_file_exists(_DIR_SKINS,$skin.'/skin.inc')) continue;
			$array[]=array('name'=>$skin);
		}
		view::show_using_array($data,$array,$skin);
	}
	static public function action_post_convert(){
		$skin=$_POST['jp_nucleus_skin_name'];
		$xml=self::local_file_contents(_DIR_SKINS,$skin.'/skinbackup.xml');
		if (!$xml) {
			return error::note('_JP_NUCLEUS_SKINBACKUP_DOES_NOT_EXIST');
		}
		if (!is_writable(_DIR_SKINS.$skin)) {
			return error::note('_JP_NUCLEUS_SKIN_CHECK_PERMISSION',$skin);
		}
		$xml=new SimpleXMLElement($xml);
		// Convert skin scripts
		self::convert_skin($skin,$xml);
		// Convert template scripts
		self::convert_template($skin,$xml);
		// Finally, create skin.inc
		self::skin_inc($skin);
		// All done.
		if (self::local_file_exists(_DIR_SKINS,$skin.'/skin.inc')) {
			error::note('_JP_NUCLEUS_CONVERETED',$skin);
		} else {
			error::note('_JP_NUCLEUS_FAILED',$skin);
		}
	}
	static private function convert_skin($skin,$xml){
		$skins=array();
		foreach(array('archive','archivelist','error','imagepopup','item','member','search') as $type){
			$skins[$type]='<%view.include(jindex.inc)%>';
		}
		foreach($xml->skin->part as $part){
			$skins[(string)$part['name']]=(string)$part;
		}
		foreach($skins as $file=>$script){
			file_put_contents(_DIR_SKINS.$skin.'/j'.$file.'.inc',$script);
		}
	}
	static private function convert_template($skin,$xml){
		@mkdir(_DIR_SKINS.$skin.'/templates');
		foreach($xml->template as $template){
			$prefix=preg_replace('/[^a-zA-Z0-9]/','_',(string)$template['name']).'_';
			// Pickup all template entries
			self::$templates=array();
			foreach($template->part as $part){
				self::$templates[(string)$part['name']]=(string)$part;
			}
			// Just a tiny modification for archivelist template
			if (isset(self::$templates['ARCHIVELIST_LISTITEM'])) {
				self::$templates['ARCHIVELIST_LISTITEM']=preg_replace('/([^<])(%[a-zA-Z])/','$1<%date.strftime($2)%>',self::$templates['ARCHIVELIST_LISTITEM']);
			}
			// Construct template inc files.
			self::template_item($skin,$prefix);
			self::template_comment($skin,$prefix);
			self::template_archivelist($skin,$prefix);
			self::template_bloglist($skin,$prefix);
			self::template_catlist($skin,$prefix);
		}
	}
	static private $templates=array();
	static private function addtab($type,$key1,$key2=false,$key3=false){
		if (isset(self::$templates[$key1])) $text=self::$templates[$key1];
		else $text='';
		if ($key2 && isset(self::$templates[$key2])) $text.=self::$templates[$key2];
		if ($key3 && isset(self::$templates[$key3])) $text.=self::$templates[$key3];
		if (strlen($text)==0) return '';
		$text=preg_replace('/(^|\r|\n)([^\r\n])/','$1'."\t".'$2',$text);
		return "<%case($type)%>\n$text\n";
	}
	static private function template_item($skin,$prefix){
		$script='';
		$script.=self::addtab('body','ITEM_HEADER','ITEM','ITEM_FOOTER');
		$script.=self::addtab('more','MORELINK');
		$script.=self::addtab('edit','EDITLINK');
		$script.=self::addtab('new','NEW');
		$script.=self::addtab('date','DATE_HEADER','FORMAT_DATE','DATE_FOOTER');
		$script.=self::addtab('time','FORMAT_TIME');
		if (strlen($script)==0) return;
		$script="<%select(template)%>\n$script<%endselect%>";
		file_put_contents(_DIR_SKINS.$skin.'/templates/'.$prefix.'item.inc',$script);
	}
	static private function template_comment($skin,$prefix){
		$script='';
		$script.=self::addtab('head','COMMENTS_HEADER');
		$script.=self::addtab('body','COMMENTS_BODY');
		$script.=self::addtab('foot','COMMENTS_FOOTER');
		$script.=self::addtab('none','COMMENTS_NONE');
		$script.=self::addtab('one','COMMENTS_ONE');
		$script.=self::addtab('two','COMMENTS_CONTINUED');
		$script.=self::addtab('many','COMMENTS_TOOMUCH');
		$script.=self::addtab('auth','COMMENTS_AUTH');
		if (strlen($script)==0) return;
		$script="<%select(template)%>\n$script<%endselect%>";
		file_put_contents(_DIR_SKINS.$skin.'/templates/'.$prefix.'comment.inc',$script);
	}
	static private function template_archivelist($skin,$prefix){
		$script='';
		$script.=self::addtab('head','ARCHIVELIST_HEADER');
		$script.=self::addtab('body','ARCHIVELIST_LISTITEM');
		$script.=self::addtab('foot','ARCHIVELIST_FOOTER');
		if (strlen($script)==0) return;
		$script="<%select(template)%>\n$script<%endselect%>";
		file_put_contents(_DIR_SKINS.$skin.'/templates/'.$prefix.'archivelist.inc',$script);
	}
	static private function template_bloglist($skin,$prefix){
		$script='';
		$script.=self::addtab('head','BLOGLIST_HEADER');
		$script.=self::addtab('body','BLOGLIST_LISTITEM');
		$script.=self::addtab('foot','BLOGLIST_FOOTER');
		if (strlen($script)==0) return;
		$script="<%select(template)%>\n$script<%endselect%>";
		file_put_contents(_DIR_SKINS.$skin.'/templates/'.$prefix.'bloglist.inc',$script);
	}
	static private function template_catlist($skin,$prefix){
		$script='';
		$script.=self::addtab('head','CATLIST_HEADER');
		$script.=self::addtab('body','CATLIST_LISTITEM');
		$script.=self::addtab('foot','CATLIST_FOOTER');
		if (strlen($script)==0) return;
		$script="<%select(template)%>\n$script<%endselect%>";
		file_put_contents(_DIR_SKINS.$skin.'/templates/'.$prefix.'catlist.inc',$script);
	}

	static private function skin_inc($skin){
		$script=
'<%using(jp.nucleus.skin,jp.nucleus.template)%>
<%select(template)%>
<%case(item)%>
<%view.parse(jitem.inc)%>
<%case(archive)%>
<%view.parse(jarchive.inc)%>
<%case(archivelist)%>
<%view.parse(jarchivelist.inc)%>
<%case(search)%>
<%view.parse(jsearch.inc)%>
<%case(member)%>
<%view.parse(jmember.inc)%>
<%case(imagepopup)%>
<%view.parse(jimagepopup.inc)%>
<%case(error)%>
<%view.parse(jerror.inc)%>
<%case.else%>
<%view.parse(jindex.inc)%>
<%endselect%>';
		file_put_contents(_DIR_SKINS.$skin.'/skin.inc',$script);
	}
}