#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Control.pm 1138 2007-09-15 13:16:37Z hikarin $
#

package Zeromin2::Translate::JBBS::Control;

use strict;
use Zeromin2::Translate::JBBS::Parser qw();

sub work {
    my ( $zClass, $iKernel, $argument ) = @_;
    my $zTJP = Zeromin2::Translate::JBBS::Parser->new();
    my $tree;

    $zTJP->set_url( $argument->{-url} );
    $zTJP->set_password( $argument->{-pass} || $argument->{-password} );

    if ( $zTJP->try_post_form( \$tree, 'control', { CTRL => 'deny_hosts' } )
        and my $zFRH = $argument->{host} )
    {
        my $tag = $tree->look_down(
            '_tag' => 'textarea',
            'name' => 'DENY_HOSTS'
        );
        map { $_ and $zFRH->add($_) } @{ $tag->content() || [] };
        $zFRH->save();
    }

    if ($zTJP->try_post_form(
            \$tree, 'control', { CTRL => 'deny_terminal' }
        )
        and my $zFRH = $argument->{host}
        )
    {
        my $tag = $tree->look_down(
            '_tag' => 'textarea',
            'name' => 'DENY_TERMINAL'
        );
        map { $_ and $zFRH->add($_) } @{ $tag->content() || [] };
        $zFRH->save();
    }

    if ( $zTJP->try_post_form( \$tree, 'control', { CTRL => 'ngwords' } )
        and my $zNGW = $argument->{ngword} )
    {
        my $tag
            = $tree->look_down( '_tag' => 'textarea', 'name' => 'NGWORDS' );
        map { $_ and $zNGW->add( $_, 1, '' ) } @{ $tag->content() || [] };
        $zNGW->save();
    }

    return 1;
}

1;
__END__
