#/*
# *  Copyright 2007-2009 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: IP.pm 1826 2009-04-08 15:23:25Z hikarin $
#

package Img0ch::Plugin::Filter::IP;

use strict;
use Img0ch::Filter::IP qw();

sub check {
    my ($iApp) = @_;

    if ( !$iApp->cap()->can_pass_proxy_access() ) {
        my $iFIP = Img0ch::Filter::IP->new( $iApp->bbs );
        $iFIP->load();
        if ( !$iFIP->write_ok( $iApp->get_ip() ) ) {
            $iApp->set_error('POST_FROM_DENIED_HOST');
            return 0;
        }
    }
    return 1;
}

1;
__END__
