#!/usr/local/bin/perl
#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: img0ch-fcgi.pl 1555 2007-11-13 15:55:09Z hikarin $
#

use strict;
no  lib qw(.);
use Getopt::Long;
use Pod::Usage;

my $help = 0;
my ( $listen, $nproc, $pidfile, $config, $keep_stderr, $inc );

GetOptions(
    'help|?'      => \$help,
    'listen|l=s'  => \$listen,
    'nproc|n=i'   => \$nproc,
    'pidfile|p=s' => \$pidfile,
    'config|c=s'  => \$config,
    'keeperr|e'   => \$keep_stderr,
    'include|i=s' => \$inc,
);
$help and pod2usage(1);

$nproc  ||= 5;
$config ||= 'img0ch-config.cgi';
$inc    ||= 'img0ch';
lib->import( "${inc}/3", "${inc}/ext" );

require Img0ch::FCGI::Server;
Img0ch::FCGI::Server->run(
    {   number_of_processes => $nproc,
        pid_file_path       => $pidfile,
        img0ch_config_path  => $config,
        fcgi_socket_path    => $listen,
        keep_stderr         => $keep_stderr,
    }
);

1;
__END__

=head1 NAME

img0ch-fcgi.pl - Img0ch FastCGI invoker

=head1 SYNOPSIS

img0ch-fcgi.pl [options]

 Options:
   -? -help        この画面を表示します
   -l -listen      ソケットのパスを指定します。
                   /PATH、:PORT、HOST:PORTの形式でも指定可能
   -n -nproc       リクエストごとに何個のプロセスを保有するかを
                   指定します。
   -p -pidfile     PIDファイルのパスを指定します
   -c -config      img0ch-config.cgiのパスを指定します
   -e -keep_stderr エラー出力を標準出力に保持するかを指定します
   -i -include     Img0chの動作に必要なライブラリのパスを指定します

=head1 DESCRIPTION

*caution* This script is written in UTF-8.

img0chのアプリケーションをFastCGIの外部サーバとして動作させるスクリプトです。
起動後はデーモンとして動作します。以下は外部サーバとして起動させる場合の設定例です。
この場合I<-l>はI</tmp/img0ch-fcgi.socket>となります。

  # Apacheの例
  FastCgiExternalServer /tmp/img0ch.fcgi -socket /tmp/img0ch-fcgi.socket

  # lighttpdの例
  fastcgi.server = (
    ".cgi" => (
      "localhost" => (
        "socket"      => "/tmp/img0ch-fcgi.socket",
        "check-local" => "disable"
      )
    )
  )

=head1 AUTHOR

hkrn E<lt>hikarin@users.sourceforge.jpE<gt>

=cut
