<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN"
  "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja">
<head>
<title><?cs var:html_escape(BBS_TITLE) ?> - 指定されたスレッドを読み込むことが出来ません</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta name="generator" content="<?cs var:html_escape(VERSION) ?>" />
<link media="screen" href="<?cs var:html_escape(StaticURI) ?>/tdiary/base.css" rel="stylesheet" />
<link media="screen" href="<?cs var:html_escape(StaticURI) ?>/tdiary/<?cs if:BBS_TYPE_THEME ?><?cs var:html_escape(BBS_TYPE_THEME) ?>/<?cs var:html_escape(BBS_TYPE_THEME) ?>.css<?cs else ?>default/default.css<?cs /if ?>" rel="stylesheet" />
<style type="text/css">
@charset "utf-8";
fieldset { border: 0px; }
img { border: 0px; }
.center { text-align:center !important;  }
.clear { clear: both !important; }
.icon-align { vertical-align: top; }
.image { border: none; float: left; margin-right: 4px; margin-bottom: 1px; }
.right { text-align: right !important; }
.res_body {
  font-size: 12pt;
  font-family: "Mona","IPA モナー Pゴシック","IPA MONAPGOTHIC","MS PGothic","ＭＳ Ｐゴシック","MS Pゴシック","MS Pゴシック",sans-serif;
  line-height: 120% !important;
}
</style>
</head>
<body>

<h1>ERROR!</h1>
<hr class="sep" />

<?cs if:IsError ?>

<div class="day" id="error">
 <h2><span class="title"><?cs var:html_escape(ShortErrorStr) ?></span></h2>
 <div class="body">
  <div class="caption"><?cs var:html_escape(LongErrorStr) ?></div>
  <div class="section">
   <p>
    エラーが発生したため、処理を継続することが出来ません。
    <a href="<?cs var:html_escape(BBSURI) ?>/">掲示板に戻る</a>
   </p>
  </div>
 </div>
</div>

<?cs elif:IsPooled ?>

<?cs if:Banner ?>
<hr class="sep" />
<div class="day" id="mainBanner">
 <h2><span class="title">告知欄</span></h2>
 <div class="body">
  <div class="section">
   <?cs var:Banner ?>
  </div>
 </div>
</div>
<?cs /if ?>

<div class="day">
 <h2 class="thread_header">
  <span class="title thread_subject">■「<?cs var:html_escape(Subject) ?>」は倉庫(プール)に保管されています</span>
 </h2>
 <div class="form">
  <div class="caption">
   <a href="<?cs var:html_escape(BBSURI) ?>/">■掲示板に戻る■</a>
   <a href="<?cs var:html_escape(ReadCGIURI) ?>/">全部</a>
   <a href="<?cs var:html_escape(ReadCGIURI) ?>/1-100">1-</a>
   <a href="<?cs var:html_escape(ReadCGIURI) ?>/l50">最新50</a>
  </div>
  <div class="section">
   <p>
   現在表示しているスレッドのdatのレス数は<strong><?cs var:html_escape(ResCount) ?></strong>、大きさは<strong><?cs var:html_escape(DatKByteSize) ?></strong>KBです。<br />
   <?cs if:IsArchived ?>また、過去ログ倉庫に<a href="<?cs var:html_escape(Archive) ?>/<?cs var:html_escape(Token1) ?>/<?cs var:html_escape(Token2) ?>/<?cs var:html_escape(KEY) ?>.html"><?cs var:html_escape(KEY) ?>.html</a>として保存されています。<?cs /if ?>
   </p>
  </div>
 </div>
 <div class="body thread_body" id="t_<?cs var:html_escape(KEY) ?>">
  <?cs each:res = Thread ?>
   <div class="section" id="r_<?cs var:html_escape(res.resno) ?>">
    <div class="caption res_header">
     <?cs var:html_escape(res.resno) ?>
     名前：<span class="commentator">
     <?cs if:res.mail ?>
      <a href="mailto:<?cs var:html_escape(res.mail) ?>" rel="nofollow"><b><?cs var:res.name ?></b></a>
     <?cs else ?>
      <span class="nomail"><b><?cs var:res.name ?></b></span>
     <?cs /if ?>
     </span>:<span class="commenttime"><?cs var:res.date ?></span>
    </div>
    <p class="res_body"><?cs var:res.text ?></p>
   </div>
  <?cs /each ?>
 </div>
</div>

<?cs else ?>

<div class="day" id="error">
 <h2><span class="title">スレッドの読み込みに失敗しました</span></h2>
 <div class="body">
  <div class="caption">そのようなスレッドは存在しません</div>
  <div class="section">
   <p>
    スレッドが存在しないため、処理を継続することが出来ません。<br />
    <?cs if:IsArchived ?>ひょっとして過去ログ倉庫に保存されている<a href="<?cs var:html_escape(Archive) ?>/<?cs var:html_escape(Token1) ?>/<?cs var:html_escape(Token2) ?>/<?cs var:html_escape(KEY) ?>.html"><?cs var:html_escape(KEY) ?>.html</a>をお探しですか？<?cs else ?>過去ログ倉庫にも存在しないため、スレッドが削除されたかもしれません。<?cs /if ?>
    <br /><br /><a href="<?cs var:html_escape(BBSURI) ?>/">掲示板に戻る</a>
   </p>
  </div>
 </div>
</div>

<?cs /if ?>

<hr class="sep" />
<div class="footer">
 <a href="http://img0ch.sourceforge.jp"><?cs var:html_escape(VERSION) ?></a>
</div>

</body>
</html>
