= Ruby/WinTrayIcon
Windowsのタスクバーの通知領域(タスクトレイ)にアイコンを表示させる拡張ライブラリです。

== バージョン
* 0.2.0

== 配布ライセンス
* ((<Ruby's License|URL:http://www.ruby-lang.org/ja/LICENSE.txt>))

== 動作環境
* Windows上のRuby 1.8以降(1.8.4以降を推奨)

== インストール
=== バイナリをコピーする場合
  $ ruby install.rb

を実行すると、環境に応じたバイナリを適切な場所にコピーします。

「cannot find wintrayicon.so for your platform.」と表示された場合は、配布物にお使いのRubyに対応するバイナリがないことを示します。この場合は((<自分でビルドする場合>))を参照してビルドする必要があります。

=== 自分でビルドする場合
  $ ruby extconf.rb
  $ make
  $ make install

== リファレンス
=== 定数
:WinTrayIcon::VERSION
  WinTrayIconのバージョンを文字列で返します。

=== クラスメソッド
--- WinTrayIcon.new()
    タスクトレイにアイコン領域を確保します。
    この時点ではアイコンが設定されていないので、空白になります。
    何らかの理由で失敗した場合はRuntimeErrorを投げます。

=== メソッド
==== 制御
--- WinTrayIcon#live?
    タスクトレイが存在してればtrueを返します。

--- WinTrayIcon#update()
    メッセージ処理を行います。
    これを呼ばないとクリックに反応しません。

--- WinTrayIcon#close()
    タスクトレイからアイコンを消します。
    例外処理などを行って、必ず呼ぶようにしてください。
    呼ばれなかった場合は、タスクトレイにアイコンが残ってしまう場合があります。

==== メニュー関連

--- WinTrayIcon#add_menu( text ) { |tray| ... }
    メニューに項目を追加します。
    (({((|text|)).to_s}))がメニューに表示される文字列となります。
    文字列中に「&」を入れると、アンダーバー表示ができます。

    ブロックを渡した場合、そのメニューが選択されたときにブロックを実行するように
    なります。ブロックには引数としてWinTrayIcon自体が渡されます。

    例えば、メニュー選択で終了したければ、
      tray.add_menu( '終了' ) { |x| x.close }
    とすればよいことになります。

    一度追加したメニューの削除はできません。

--- WinTrayIcon#add_separater
    メニューに区切り線を追加します。

--- WinTrayIcon#enable( index )
    ((|index|))で指定されたメニュー項目を使用可能にします。
    ((|index|))で指定する番号は、メニューを追加した順番になります。
      tray.add_menu('menu1')
      tray.add_menu('menu2')
      tray.add_separater
      tray.add_menu('menu3')
    などとした場合は、
      menu1が0
      menu2が1
      menu3が3
    となります。

--- WinTrayIcon#disable( index )
    ((|index|))で指定されたメニュー項目を使用不可能にします。

--- WinTrayIcon#get_state( index )
--- WinTrayIcon#[]( index )
    ((|index|))で指定されたメニュー項目のチェック状態をtrue/falseで返します。

--- WinTrayIcon#set_state( index, flag )
--- WinTrayIcon#[]=( index, flag )
    ((|index|))で指定されたメニュー項目のチェック状態を設定します。
    ((|flag|))がtrueならチェックをいれ、true以外ならチェックをはずします。

==== アイコン関連
--- WinTrayIcon#load_icon( path, w, h )
    ((|path|))で指定されたファイルから幅((|w|))高さ((|h|))のアイコンを
    読み出して、タスクトレイに表示するようにします。

    成功した場合はtrue、失敗した場合はfalseを返します。
    失敗した場合はアイコンを変更しません。
 
--- WinTrayIcon#get_icon( id, w, h )
    ((|id|))をリソースIDとみなして幅((|w|))高さ((|h|))のアイコンを取り出して、
    タスクトレイに表示するようにします。

    成功した場合はtrue、失敗した場合はfalseを返します。
    失敗した場合はアイコンを変更しません。

    通常のRubyスクリプトではリソースをいじれるわけではないのであまり意味を
    持ちませんが、Exerbなどでリソースを埋め込んだ実行ファイルにした場合に
    多少便利かもしれません。

==== ツールチップ関連
--- WinTrayIcon#tip()
    現在設定されているツールチップの内容をStringで返します。

--- WinTrayIcon#tip=(v)
    ((|v|)).to_sの先頭63文字分をツールチップに表示するようにします。
    マルチバイト処理していないため、63文字目にマルチバイト境界が来ると
    文字化けするので注意してください。

==== その他
--- WinTrayIcon#window_handle()
    WinTrayIconが使用しているウインドウのハンドル(HWND)をIntegerで返します。

--- WinTrayIcon#menu_handle()
    WinTrayIconが使用しているポップアップメニューのハンドル(HMENU)を
    Integerで返します。
