// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		RootBoardContainer.java
//	DATE:		2003.6.11	initial version
//	CREATOR:		Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.view;

import java.io.File;

import java.awt.Component;
import java.awt.Frame;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.GUIUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.TerminateManager;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.Usherable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ComponentUsher;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ProblemUnmarshalable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.SaveCanceledException;

/**
 *	MVCViewɑΉ鍜iۃNX
 *	
 *	View͊Kw\琬ÃNX͊Kw̃[gɓ
 *	[g͏ȂƂ1̔Ֆʂ̕`ΏۂƂȂTuR|[lgȂΐȂB
 */
public abstract class RootBoardContainer implements BoardView, Usherable, ProblemUnmarshalable {
	/** ^Cg */
	private static String sInitialTitle = "<untitled>";
	
	/** qView */
	protected BoardView mDecorated;
	
	/** R|[lg */
	private Frame mComponent;
	
	/** ̃R|[lgfocus邩ǂtO */
	private boolean mFocused;
	
	/**
	 *	RXgN^
	 *
	 *	@param	inComponent	BoardContainerŃbvR|[lg
	 */
	protected RootBoardContainer(Frame inComponent) {
		mComponent = inComponent;
	}
	
	/**
	 *	Ֆʂ̏s
	 *	̃\bhĂ΂AinitializeSelf()
	 *	addBoard()ĂсA
	 *	Ֆʂ̕\sR|[lgZbgĂ
	 *	TuR|[lgZbgĂȂꍇA
	 *	IllegalStateExceptionoB
	 *
	 *	@exception	IllegalStateException
	 */
	public final void initialize() {
		initializeSelf();
		throwIfUninitialized();
		
		mDecorated.initialize();
		
		mComponent.pack();
		
	}
	
	/**
	 *	̃R|[lg
	 */
	protected abstract void initializeSelf();
	
	/**
	 *	TuR|[lgB
	 *
	 *	@param	inSubBoard TuR|[lg
	 */
	protected final void addBoard(BoardView inSubBoard) {
		mComponent.add(inSubBoard.getComponent());
		
		mDecorated = inSubBoard;
		
		inSubBoard.setParent(this);
	}
	
	/**
	 *	̃R|[lg̐eZbg
	 *	Rootɑ΂e݂͑Ȃ߁A
	 *	̎ł́AUnsupportedOperationException𑗏oB
	 *
	 *	@param	inParent ̃R|[lg̐e
	 *
	 *	@exception	UnsupportedOperationException
	 *				TuR|[lgĂȂꍇ
	 */
	public void setParent(BoardView inParent) {
		throw new UnsupportedOperationException(
			"The Parent of root board is no existance."
		);
	}
	
	/**
	 *	Board̃TCYύX
	 *	̎ł́Asubcomponentɏ]
	 *
	 *	@param	inWidth ύX̕
	 *	@param	inHeight ύX̍
	 *
	 *	@exception	UnsupportedOperationException
	 *				TuR|[lgĂȂꍇ
	 */	
	 public final void createBoard(final int inWidth, final int inHeight) {
		throwIfUninitialized();
		
	 	mDecorated.createBoard(inWidth, inHeight);
	 }
	
	/**
	 *	@return Board̕Ԃ
	 *	̎ł́Asubcomponentɏ]
	 *
	 *	@exception	UnsupportedOperationException
	 *				TuR|[lgĂȂꍇ
	 */
	public final int getBoardWidth() {
		throwIfUninitialized();
		
		return mDecorated.getBoardWidth();
	}

	/**
	 *	@return Board̍Ԃ
	 *	̎ł́Asubcomponentɏ]
	 *
	 *	@exception	UnsupportedOperationException
	 *				TuR|[lgĂȂꍇ
	 */
	public final int getBoardHeight() {
		throwIfUninitialized();
		
		return mDecorated.getBoardHeight();
	}

	/**
	 *	ՖʂύXĂ邩ǂ`FbNB
	 *	̎ł́Asubcomponentɏ]
	 *
	 *	@exception	UnsupportedOperationException
	 *				TuR|[lgĂȂꍇ
	 */
	public final boolean isModified() {
		throwIfUninitialized();
		
		return mDecorated.isModified();
	}
	
	/**
	 *	w肵t@CɁA쐬蕶ۑ
	 *
	 *	@param	inFile ۑƂȂt@C
	 *	@return	ۑɊւ
	 *
	 *	@exception	UnsupportedOperationException
	 *				TuR|[lgĂȂꍇ
	 */
	public final void save(File inFile) throws SaveCanceledException {
		if (inFile.getName().equals(sInitialTitle)) {
			saveAs();
			repaint();
		}
		else {
			throwIfUninitialized();
		
			// ۑsubcomponentɓ]B
			mDecorated.save(inFile);
		}
	}
	
	/**
	 *	w肵t@Cɖ蕶ۑ
	 *	蕶Save_CAOŎw肵t@CɕۑB
	 *
	 *	@throws	SaveCanceledException ۑLZꂽꍇɂ΂B
	 */
	public final void saveAs() throws SaveCanceledException {
		javax.swing.JFileChooser aChooser = GUIUtility.createFileChooser();

		// Save Dialog\B
		final int aSignal = aChooser.showSaveDialog(mComponent);
		
		if (aSignal == javax.swing.JFileChooser.CANCEL_OPTION) {
			throw new SaveCanceledException("The save operation is canceled.");
		}
		else if (aSignal == javax.swing.JFileChooser.APPROVE_OPTION) {
			// ۑsubcomponentɓ]B
			mDecorated.save(aChooser.getSelectedFile());
		}	
	}

	/**
	 *	w肵蕶load
	 *	̎ł́Asubcomponentɏ]
	 *
	 *	@param inInfo 
	 *
	 *	@exception	UnsupportedOperationException
	 *				TuR|[lgĂȂꍇ
	 */
	public final void load(ProblemInfo inInfo) {
		throwIfUninitialized();
		
		mDecorated.load(inInfo);
	}
	
	/**
	 *	w肵蕶load
	 *
	 *	@param inInfo 
	 */
	public final void loadProblem(File inFile, ProblemInfo inInfo) {
		if (this != ComponentUsher.getInstance().getActiveComponent()) {
			ComponentUsher.getInstance().setActiveComponent(this);
		}
		
		setTitle(inFile.getAbsolutePath());
		load(inInfo);
	}
	
	/**
	 *	ՖʂԂɖ߂
	 *	̎ł́Asubcomponentɏ]
	 *
	 *	@exception	UnsupportedOperationException
	 *				TuR|[lgĂȂꍇ
	 */
	public final void clear() {
		throwIfUninitialized();
		
		mDecorated.clear();
	}
	
	/**
	 *	@return	gƊ֘AtꂽComponentԂ
	 */
	public final Component getComponent() {
		return mComponent;
	}
	
	/**
	 *	Framẽ^Cgw肵ɕύX
	 *	̎ł́Aw肵ɃvOtĂB
	 *
	 *	@param	inTitle ^CgƂĐݒ肷镶
	 */
	public final void setTitle(String inTitle) {
		mComponent.setTitle(modifiyTitleString(inTitle));
	}
	
	/**
	 *	^CgƂăZbg镶ɏC
	 *
	 *	@param inOldTitle CO̕
	 *	@return	C̕
	 */
	protected abstract String modifiyTitleString(String inOldTitle);
	
	/**
	 *	@return	݂̃^Cg擾
	 */
	public final String getTitle() {
		return mComponent.getTitle();
	}

	/**
	 *	̃{[hɍĕ`w
	 *	̎ł́ATuR|[lgɏ]
	 *
	 *	@exception	UnsupportedOperationException
	 *				TuR|[lgĂȂꍇ
	*/	 
	public final void repaint() {
		throwIfUninitialized();
		
		mDecorated.repaint();
	}
	
	/**
	 *	Ֆʂ̊es[X̃TCYw肵TCYɕύX
	 *
	 *	@param	inSize ύX̃TCY
	 */
	public final void setPieceSize(final int inSize) {
	}
	
	/**
	 *	Board1s[X̃TCYԂ
	 *
	 *	@return ZTCY
	 */
	public int getPieceSize() {
		return mDecorated.getPieceSize();
	}
	
	/**
	 *	̃R|[lg̃TCYύX
	 *
	 *	@param	inWidth		
	 *	@param	inHeight	
	 */
	public final void setComponentSize(final int inWidth, final int inHeight) {
		mComponent.pack();

		java.awt.Dimension aScreenSize = GUIUtility.getEffectiveScreenSize();
		
		// frameTCYscreen傫Ƃscreen sizeɂ킹
		int aWidth = mComponent.getWidth();
		int aHeight = mComponent.getHeight();
		
		if (aWidth > aScreenSize.width) aWidth = aScreenSize.width;
		if (aHeight > aScreenSize.height) aHeight = aScreenSize.height;

		if (new java.awt.Dimension(aWidth, aHeight).equals(mComponent.getSize())) return;
		
		mComponent.setSize(aWidth, aHeight);
	}
	
	/**
	 *	̃R|[lg폜
	 */
	protected final void dispose() {
		mComponent.dispose();
	}
	
	/**
	 *	̃R|[lgɃtH[JX邩ǂ`FbN
	 *
	 *	@return	tH[JXtrueԂB
	 */
	public final boolean isFocused() {
		return mFocused;
	}
	
	/**
	 *	̃R|[lg̃tH[JXLw肵boollɕύX
	 *
	 *	@param	̃R|[lgɃtH[JXꍇAtruew肷B
	 */
	public final void setFocus(boolean inFocused) {
		mFocused = inFocused;
	}
	
	/**
	 *	ۑLZꂽꍇɌĂԃ\bh
	 *	ʏAOASaveCanceledExceptioncatchߓŌĂ
	 */
	protected final void saveCanceled() {
		TerminateManager aManager = TerminateManager.getInstance();
		if (aManager.isTerminateThread()) {
			aManager.cancel();
		}
	}
	
	/**
	 *	TuR|[lgĂ邩ǂ`FbNA
	 *	ĂȂꍇAO𑗏o
	 *
	 *	@exception	IllegalStateException
	 */
	private void throwIfUninitialized() {
		if (null == mDecorated) {
			throw new IllegalStateException(
					"The subcompoment is initialized."
					+ "To Call with addBoard() method lead to register it."
			);
		}
	}
	
	/**
	 *	Frame\
	 */
	public void show() {
		mComponent.show();
	}
}