// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		BoardContainer.java
//	DATE:		2003.6.9
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.view;

import java.io.File;

import java.awt.Component;
import java.awt.Container;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.SaveCanceledException;

/**
 *	R|[lgpropertŷւ񂱂hook邽߂̍iNX
 */
 public abstract class BoardContainer implements BoardView {
	
	/** ̊Kw̐evf */
	private BoardView mParent;
	
	/** ̊Kw̎qvf */
	private BoardView mDecorated;
	
	/** Board componentŃbvĂawt container */
	private Container mContainer;
	
	/**
	 *	RXgN^
	 *
	 *	@param	inContainer	Board componentŃbvawt container
	 */
	public BoardContainer(Container inContainer) {
		mContainer = inContainer;
	}
	
	/**
	 *	Ֆʂ̏s
	 */
	public final void initialize() {
		initializeSelf();
		
		mDecorated.initialize();
	}
	
	/**
	 *	̔Ֆʂ̏s
	 */
	protected abstract void initializeSelf();
	
	/**
	 *	Board̃TCYύX
	 *
	 *	@param	inWidth ύX̕
	 *	@param	inHeight ύX̍
	 */	
	 public final void createBoard(final int inWidth, final int inHeight) {
	 	mDecorated.createBoard(inWidth, inHeight);
	 }
	
	/**
	 *	@return Board̕Ԃ
	 */
	public final int getBoardWidth() {
		return mDecorated.getBoardWidth();
	}

	/**
	 *	@return Board̍Ԃ
	 */
	public final int getBoardHeight() {
		return mDecorated.getBoardHeight();
	}

	/**
	 *	ՖʂύXĂ邩ǂ`FbNB
	 */
	public final boolean isModified() {
		return mDecorated.isModified();
	}
	
	/**
	 *	w肵t@CɁA쐬蕶ۑ
	 *	̎ł́Asubcomponentɕۑ]邾łB
	 *
	 *	@param	inFile ۑƂȂt@C
	 */
	public final void save(File inFile) throws SaveCanceledException 
	{
		mDecorated.save(inFile);
	}
	
	/**
	 *	w肵蕶load
	 *
	 *	@param inInfo 
	 */
	public final void load(ProblemInfo inInfo) {
		mDecorated.load(inInfo);
	}

	/**
	 *	ՖʂԂɖ߂
	 */
	public final void clear() {
		mDecorated.clear();
	}
	
	/**
	 *	BoardKwƂÅKw̎qݒ肷
	 *
	 *	@param	inBoard	̊Kw̎qƂȂBoard
	 */
	public void addBoard(BoardView inSubBoard) {
		mContainer.add(inSubBoard.getComponent());
		
		mDecorated = inSubBoard;
		
		inSubBoard.setParent(this);
	}

	/**
	 *	BoardKwƂÅKw̐eݒ肷
	 *
	 *	@param	inBoard	̊Kw̐eƂȂBoard
	 */
	public void setParent(BoardView inParentBoard) {
		mParent = inParentBoard;
	}
	
	/**
	 *	@return	gƊ֘AtꂽComponentԂ
	 */
	public final Component getComponent() {
		return mContainer;
	}
	
	/**
	 *	w肵^CgZbg
	 *
	 *	@param	^Cg
	 */
	public final void setTitle(String inTitle) {
		mParent.setTitle(inTitle);
	}

	/**
	 *	Board̃^CgԂ
	 *
	 *	@return	^Cg
	 */
	public final String getTitle() {
		return mParent.getTitle();
	}

	/**
	 *	Boardĕ`悷
	 */
	public final void repaint() {
		mDecorated.repaint();
	}

	/**
	 *	Board1s[X̃TCYZbg
	 *
	 *	@param	inSize ZTCY
	 */
	public final void setPieceSize(final int inSize) {
		final int aSize = setPieceSizeSelf(inSize);
		
		mParent.setPieceSize(aSize);
	}
	
	/**
	 *	Boardɑ΂Ă1s[X̃TCYZbg
	 *
	 *	@param	inSize ZTCY
	 */
	protected abstract int setPieceSizeSelf(final int inSize);
	
	/**
	 *	Board1s[X̃TCYԂ
	 *
	 *	@return ZTCY
	 */
	public final int getPieceSize() {
		return mDecorated.getPieceSize();
	}
	
	/**
	 *	R|[lg̃TCYύX
	 *	ƂēnĺAsubcomponent̃TCYłB
	 *	
	 *	@param	inWidth		subcomponent̕
	 *	@param	inHeight	subcomponent̍
	 *	@return	component̃TCY
	 */
	 public final void setComponentSize(final int inWidth, final int inHeight) {
		setComponentSizeSelf(inWidth, inHeight);
		
		final int aWidth = getComponent().getWidth();
		final int aHeight = getComponent().getHeight();
		
		mParent.setComponentSize(aWidth, aHeight);
	}
	
	/**
	 *	Board̃TCYZbg
	 *
	 *	@param	inWidth 
	 *	@param	inHeight 
	 */	
	protected abstract void setComponentSizeSelf(final int inWidth, final int inHeight);
	
	/**
	 *	BoardɃtH[JXڂǂ߂
	 */
	public void setFocus(boolean inFocused) {
		mParent.setFocus(inFocused);
	}
	
	/**
	 *	BoardɃtH[JX݂邩ǂ`FbN
	 *
	 *	@return	tH[JXꍇtrueԂB
	 */
	public final boolean isFocused() {
		return mParent.isFocused();
	}
}