// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
//	NAME:		UtilityFuncs.java
//	DATE:		2003.5.12	initial version
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.util;

import java.awt.event.KeyEvent;

import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

public class UtilityFuncs {
	/**
	 *	w肵܂́AłΑΉStateEventCodeԂ
	 *	łȂ΁AJڂȂƂStateEventCodeԂ
	 *
	 *	@param	inDirection 
	 *	@return	StateEventCode̎
	 */
	public static StateEventCode resolveTransitCode(Direction inDirection) {
		if (Direction.NORTH == inDirection || Direction.SOUTH == inDirection) 
		{
			return HashikakeStateEventCode.createVerticalCode();
		}
		else if (Direction.EAST == inDirection || Direction.WEST == inDirection)
		{
			return HashikakeStateEventCode.createHorizontalCode();
		} 
		
		return HashikakeStateEventCode.createNoTransitCode();
	}
	
	/**
	 *	w肳ꂽɑΉAStateEventCodeԂ
	 *
	 *	@param	inDirection 
	 *	@return	StateEventCode̎
	 */
	public static StateEventCode getDirectionEventCode(Direction inDirection) {
		return DirectionStateEventCode.createDirectionCode(inDirection);
	}
	
	/**
	 *	IԂɑΉStateEventCodeԂ
	 *
	 *	@return	StateEventCode̎
	 */
	public static StateEventCode getSelectionEventCode() {
		return SelectionStateEventCode.getInstance();
	}
	
	/**
	 *	w肵J[\L[key codeɑΉԂ
	 *	Ȃꍇ́ADirection.NOԂ
	 *
	 *	@param	inKeyCode key code
	 *	@return	key codeɑΉ
	 */
	public static Direction resolveDirectionOf(final int inKeyCode) {
		if (inKeyCode == KeyEvent.VK_LEFT) return Direction.WEST;
		if (inKeyCode == KeyEvent.VK_RIGHT) return Direction.EAST;
		if (inKeyCode == KeyEvent.VK_UP) return Direction.NORTH;
		if (inKeyCode == KeyEvent.VK_DOWN) return Direction.SOUTH;
		
		return Direction.NO;
	}
	
	/**
	 *	@return	w肵Ƌt̕Ԃ
	 */
	public static Direction inverseDirection(Direction inDirection) {
		if (Direction.WEST == inDirection) return Direction.EAST;
		if (Direction.EAST == inDirection) return Direction.WEST;
		if (Direction.NORTH == inDirection) return Direction.SOUTH;
		if (Direction.SOUTH == inDirection) return Direction.NORTH;
		
		return Direction.NO;
	}
	

}
