// ***************************************************************************************
//	name	HashiCreStateEventCode.java
//	date	2003.5.25
//	creator	Kazuhiko TAMURA
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.util;

import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

public class HashikakeStateEventCode implements StateEventCode {
	public final static String VERTICAL_ID = "vert";
	public final static String HORIZONTAL_ID = "horiz";
	
	public final static String SPACE_ID = "s";
	public final static String NS_BRIDGE_ID = "i";
	public final static String BIG_NS_BRIDGE_ID = "ii";
	public final static String WE_BRIDGE_ID = "-";
	public final static String BIG_WE_BRIDGE_ID = "=";
	public final static String NULL_ID = "";
	public final static String NO_INTERNAL_TRANSIT = "";
	
	private static java.util.Map aTable = new java.util.HashMap();
		
	private String mValue;
	
	/**
	 *	w肵IDɑΉStateEventCode쐬
	 *
	 *	@param	inValue IDl
	 *	@return	StateEventCode̎
	 */
	public static StateEventCode valueOf(final String inValue) {
		StateEventCode aCode = null;
		
		if (! aTable.containsKey(inValue)) {
			aCode = new HashikakeStateEventCode(inValue);
			aTable.put(inValue, aCode);
		}
		else {
			aCode = (StateEventCode)aTable.get(inValue);
		}
		
		return aCode;
	}
	
	/**
	 *	󔒂ӖR[h쐬
	 *
	 *	@return	StateEventCode̎
	 */
	public static StateEventCode createSpaceCode() {
		return valueOf(SPACE_ID);
	}
	
	/**
	 *	ӖR[h쐬
	 *
	 *	@return	StateEventCode̎
	 */
	public static StateEventCode createHorizontalCode() {
		return valueOf(HORIZONTAL_ID);
	}
	
	/**
	 *	ӖR[h쐬
	 *
	 *	@return	StateEventCode̎
	 */
	public static StateEventCode createVerticalCode() {
		return valueOf(VERTICAL_ID);
	}
	
	/**
	 *	w肵ɑΉR[h쐬
	 *	kw肳ꂽꍇAӖR[h
	 *	w肳ꂽꍇAӖR[hꂼԂ
	 *	ȊO̕w肳ꂽꍇAcreateNoTransitCode()Ă
	 *
	 *	@return	StateEventCode̎
	 */
	public static StateEventCode createParallelCode(Direction inDirection) {
		if (Direction.NORTH == inDirection || Direction.SOUTH == inDirection) {
			return createVerticalCode();
		}
		else if (Direction.EAST == inDirection || Direction.WEST == inDirection) {
			return createHorizontalCode();
		}
		
		return createNoTransitCode();
	}
	/**
	 *	JڂȂӖR[h쐬
	 *
	 *	@return	StateEventCode̎
	 */
	public static StateEventCode createNoTransitCode() {
		return valueOf(NO_INTERNAL_TRANSIT);
	}
	
	public String getValue() {
		return mValue;
	}
	
	private HashikakeStateEventCode(String inValue) {
		mValue = inValue;
	}
	
}


