// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
//	NAME:		DirectionStateEventCode.java (package private class)
//	DATE:		2003.5.25	initial version
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.util;

import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

class DirectionStateEventCode implements StateEventCode {
	private static final DirectionStateEventCode NORTH
			 = new DirectionStateEventCode(Direction.NORTH);

	private static final DirectionStateEventCode SOUTH
			 = new DirectionStateEventCode(Direction.SOUTH);
	
	private static final DirectionStateEventCode EAST
			 = new DirectionStateEventCode(Direction.EAST);
	
	private static final DirectionStateEventCode WEST
			 = new DirectionStateEventCode(Direction.WEST);
	
	private static final DirectionStateEventCode NO 
			 = new DirectionStateEventCode(Direction.NO);
			 
	public static StateEventCode createDirectionCode(Direction inDirection) {
		if (Direction.NORTH == inDirection) {
			return NORTH;
		}
		else if (Direction.SOUTH == inDirection) {
			return SOUTH;
		}
		else if (Direction.EAST == inDirection) {
			return EAST;
		}
		else if (Direction.WEST == inDirection) {
			return WEST;
		}
		
		return NO;
	}
			 
	private Direction mDirection; 
	
	private DirectionStateEventCode(Direction inDirection) {
		mDirection = inDirection;
	}
	
	public String getValue() {
		return mDirection.getName();
	}
}
