// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
//	NAME:		BranchState.java
//	DATE:		2003.5.27
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.fsm;

import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

/**
 *	炳ɕ̏Ԃɕ򂷂邱Ƃ\
 */
public class BranchState extends AbstractState {
	public static class TransitHint {
		final State mState;
		final StateEventCode mEventCode;
		
		public TransitHint(State inState, StateEventCode inEvent) {
			mState = inState;
			mEventCode = inEvent;
		}
	}

	private TransitHint[] mBranches;
	
	/**
	 *	RXgN^
	 *	
	 *	@param	inBranches 򂩂vԂւ̓JڂɊւqg
	 */
	public BranchState(TransitHint[] inBranches) {
		mBranches = inBranches;
	}
	
	/**
	 *	̎ł́ATransitHintɊÂAinEventƓJڃR[hԂԂB
	 *
	 *	@param	inEvent Jڂւ̃qg
	 *
	 *	@return	Jڂ̏
	 */
	public State onEnter(StateEventCode inEvent) {
		for (int i = 0; i < mBranches.length; ++i) {
			if (mBranches[i].mEventCode == inEvent) {
				return mBranches[i].mState;
			}
		}
		
		throw new IllegalArgumentException("The inEvent value is Illegal.");
	}
	
}
