// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		RendererFactory.java (package private class)
//	DATE:		2003.5.27
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.creator.view;

import java.awt.Graphics;
import java.awt.Rectangle;

import jp.gr.java_conf.ktz.puzzle.framework.DefaultRenderer;
import jp.gr.java_conf.ktz.puzzle.framework.RenderListener;
import jp.gr.java_conf.ktz.puzzle.framework.RenderEvent;
import jp.gr.java_conf.ktz.puzzle.framework.State;

import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.*;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppColors;

class RendererFactory {
	/**
	 *	Renderer쐬ARenderListenero^
	 *
	 *	@return	쐬RendererԂ
	 */
	static DefaultRenderer create() {
		DefaultRenderer aRenderer = new DefaultRenderer();
		
		aRenderer.setDefaultRenderListener(new RenderListener() {
			public void render(RenderEvent inEvent) {
				Graphics aGra = inEvent.getGraphics();
				Rectangle aBounds = inEvent.getBounds();
				
				aGra.setColor(AppColors.SPACE);
				aGra.fillRect(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
				
				aGra.setColor(AppColors.WALL_COLOR);
				aGra.drawRect(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
			}
		});
		
		aRenderer.addRenderListener(NumberState.class, new RenderListener() {
			public void render(RenderEvent inEvent) {
				// w肳ꂽZ̒ɕ`悷
				Graphics aGra = inEvent.getGraphics();
				Rectangle aBounds = inEvent.getBounds();
				State aState = inEvent.getState();
				
				aGra.setColor(AppColors.ISLAND);
				aGra.fillRect(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
				
				final int aNum = ((NumberState)aState).getValue();
				aGra.setColor(AppColors.ISLAND_NUMBER);
				String aStr = String.valueOf(aNum);
				java.awt.geom.Rectangle2D aStrBounds = aGra.getFontMetrics().getStringBounds(aStr, aGra);

				final int aX = (int)(aBounds.x + (aBounds.width-aStrBounds.getWidth())/2);
				final int aY = (int)(aBounds.y - aStrBounds.getY() + (aBounds.width-aStrBounds.getHeight())/2);
				aGra.drawString(aStr, aX, aY);
			}
		});
		
		aRenderer.addRenderListener(SelectionState.class, new RenderListener() {
			public void render(RenderEvent inEvent) {
				Graphics aGra = inEvent.getGraphics();
				Rectangle aBounds = inEvent.getBounds();
				State aState = inEvent.getState();
				DefaultRenderer aRenderer = (DefaultRenderer)inEvent.getSource();
				
				// Listener̎擾
				State aDecorated = ((SelectionState)aState).getDecorated();
				RenderListener aListener = aRenderer.lookup(aDecorated);
				
				// decorateꂽԂ`悷B
				aListener.render(new RenderEvent(aRenderer, aGra, aBounds, aDecorated));
				
				// IԂ`悷
				aGra.setColor(AppColors.ACTIVE_COLOR);
				aGra.fillRect(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
			}
		});
		
		return aRenderer;
	}
}