// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		MenuManager.java
//	DATE:		2003.6.11
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.creator.view;

import java.awt.MenuBar;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.MenuShortcut;

import java.awt.Frame;

import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;

import java.awt.event.KeyEvent;

import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;


import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;

import jp.gr.java_conf.ktz.puzzle.hashikake.creator.SizeChangeDialog;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.OpenProblemDialog;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.TerminateManager;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.Usherable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ComponentUsher;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.GUIUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.SaveCanceledException;

/**
 *	Menu쐬AMenuɑ΂CxgdispatchNX
 */
class MenuManager {
	public static final String MENU_FILE = "File";
	public static final String ITEM_NEW = "New";
	public static final String ITEM_LOAD = "Load";
	public static final String ITEM_SAVE = "Save";
	public static final String ITEM_ARCHIVE = "Archive";
	public static final String ITEM_QUIT = "Quit";
	
	public static final String MENU_EDIT = "Edit";
	public static final String ITEM_CLEAR = "Clear";
	public static final String ITEM_RESIZE = "Resize...";
	
	private static final String MENU_INFO_PROPERTY = "property/menu_info.xml";
	
	private static java.util.Map sLookupManager = new java.util.HashMap(); 
	private static MenuDispatcher sDispatcher = new MenuDispatcher();
	
/*	
	private static MenuInfoBean sInfo;
	
	static {
		try {
			sInfo = createMenuInfo();
		}
		catch (java.io.FileNotFoundException e) {
			System.out.println(
				"The property file : " + MENU_INFO_PROPERTY + "is no existance"
			);
			
			e.printStackTrace(System.out);
			System.exit(-1);
		}
		catch (JiBXException e) {
			System.out.println(
				"Cannot make MenuInfoBean from the property file : "
				 + MENU_INFO_PROPERTY + "."
			);
			
			e.printStackTrace(System.out);
			System.exit(-1);
		}
	}

	private static MenuInfoBean createMenuInfo() 
				throws JiBXException, java.io.FileNotFoundException 
	{
		java.io.File aPropertyFile = new java.io.File(MENU_INFO_PROPERTY);
		
		IBindingFactory aFactory = 
			BindingDirectory.getFactory(MenuInfoBean.class);
		
		IUnmarshallingContext aContext = 
			aFactory.createUnmarshallingContext();
		
		return (MenuInfoBean)aContext.unmarshalDocument(new java.io.FileInputStream(aPropertyFile), null);
	}
*/
	
	public static MenuManager currentMenuManager() {
		BoardView aComp = (BoardView)ComponentUsher.getInstance().getActiveComponent();
		
		// w肵Frameɑ΂MenuManagerȂꍇA
		// IllegalStateException𑗏oAIB
		if (! sLookupManager.containsKey(aComp.getComponent())) {
			throw new IllegalStateException(
				"The MenuManager for the specified frame isnot registered.\n"
				+"Calling MenuManager.createMenuManager() leads to register the manager for specified the frame ."
			);
		}
		
		return (MenuManager)sLookupManager.get(aComp.getComponent());
	}
	
	public static MenuBar createMenuManager(Frame inFrame) {
		MenuManager aManager = null;
	
		// ɓo^Ăꍇ́Aēo^Ȃ
		if (sLookupManager.containsKey(inFrame)) {
			aManager = (MenuManager)sLookupManager.get(inFrame);
		}
		else {
			aManager = new MenuManager();
			aManager.initialize();		
//			aManager.init();
			sLookupManager.put(inFrame, aManager);
		}
		
		return aManager.getMenuBar();
	}
	
	private java.util.Map mLookupMenu = new java.util.HashMap(); 
	private MenuBar mMenuBar;

/*	
	private void init() {
		mMenuBar = new MenuBar();
	
		java.util.List aMList = sInfo.getList();
		for (int i = 0; i < aMList.size(); ++i) {
			MenuInfoBean.MenuBean aMBean = (MenuInfoBean.MenuBean)aMList.get(i);
			
			Menu aMenu = new Menu(aMBean.getName());
			mMenuBar.add(aMenu);
			mLookupMenu.put(aMBean.getName(), aMenu);
		}
	}
*/
	
	protected void initialize() {
		if (! sDispatcher.isInit()) sDispatcher.initialize();
		
		mMenuBar = new MenuBar();
		Menu aMenu;
		
		aMenu = new Menu(MENU_FILE);
		mMenuBar.add(aMenu);
		mLookupMenu.put(MENU_FILE, aMenu);
		{
			MenuItem aItem;
			
			aItem = new MenuItem(ITEM_NEW);
			aItem.addActionListener(sDispatcher);
			aItem.setShortcut(new MenuShortcut(KeyEvent.VK_N));
			aMenu.add(aItem);
			mLookupMenu.put(ITEM_NEW, aItem);
			
			aItem = new MenuItem(ITEM_LOAD);
			aItem.addActionListener(sDispatcher);
			aItem.setShortcut(new MenuShortcut(KeyEvent.VK_O));
			aMenu.add(aItem);
			mLookupMenu.put(ITEM_LOAD, aItem);
			
			aItem = new MenuItem(ITEM_SAVE);
			aItem.addActionListener(sDispatcher);
			aItem.setShortcut(new MenuShortcut(KeyEvent.VK_S));
			aItem.setEnabled(false);
			aMenu.add(aItem);
			mLookupMenu.put(ITEM_SAVE, aItem);
			
			aItem = new MenuItem(ITEM_ARCHIVE);
			aItem.addActionListener(sDispatcher);
			aMenu.add(aItem);
			mLookupMenu.put(ITEM_ARCHIVE, aItem);
	
			aItem = new MenuItem(ITEM_QUIT);
			aItem.addActionListener(sDispatcher);
			aItem.setShortcut(new MenuShortcut(KeyEvent.VK_Q));
			aMenu.add(aItem);
			mLookupMenu.put(ITEM_QUIT, aItem);
		}
		
		aMenu = new Menu(MENU_EDIT);
		mMenuBar.add(aMenu);
		mLookupMenu.put(MENU_EDIT, aMenu);
		{
			MenuItem aItem;
			
			aItem = new MenuItem(ITEM_CLEAR);
			aItem.addActionListener(sDispatcher);
			aMenu.add(aItem);
			mLookupMenu.put(ITEM_CLEAR, aItem);
			
			aItem = new MenuItem(ITEM_RESIZE);
			aItem.addActionListener(sDispatcher);
			aMenu.add(aItem);
			mLookupMenu.put(ITEM_RESIZE, aItem);
		}
	}
	
	public MenuBar getMenuBar() {
		return mMenuBar;
	}
	
	public void setEnabledFor(String inMenuID, final boolean inEnabled) {
		if (! mLookupMenu.containsKey(inMenuID)) {
			throw new IllegalArgumentException(
						"The Menu with the specified ID is no existance.");
		}
		
		MenuItem aItem = (java.awt.MenuItem)mLookupMenu.get(inMenuID);
		aItem.setEnabled(inEnabled);
	}
	
	public void setCheckMark(String inMenuID, final boolean inChecked) {
		if (! mLookupMenu.containsKey(inMenuID)) {
			throw new IllegalArgumentException(
						"The Menu with the specified ID is no existance.");
		}
		
		MenuItem aItem = (MenuItem)mLookupMenu.get(inMenuID);
		
		if (aItem instanceof java.awt.CheckboxMenuItem) {
			((java.awt.CheckboxMenuItem)aItem).setState(inChecked);
		}
	}

	private static class MenuDispatcher implements java.awt.event.ActionListener {
		private boolean mInitialized = false;;
		
		java.util.Map mRealListenerMap = new java.util.HashMap();
		
		boolean isInit() {
			return mInitialized;
		}
		
		public void actionPerformed(java.awt.event.ActionEvent inEvent) {
			new Thread(new MenuDispatchThread(inEvent)).start();
		}
		
		void initialize() {
			mInitialized = true;
			
			mRealListenerMap.put("New", new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent inEvent) {
					HashiCreatorRoot.showRootBoard();				
				}
			});
			
			mRealListenerMap.put("Load", new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent inEvent) {
					BoardView aComp = (BoardView)ComponentUsher.getInstance().getActiveComponent();

					// ՖʂɕύXĂƂ́AɔՖʂۑ邩ǂq˂
					if (aComp.isModified()) {
						// t@C̎擾
						String aFileName = HashiCreatorRoot.INITIAL_TITLE;
						
						final int aIndex = aComp.getTitle().lastIndexOf(" - " + HashiCreatorRoot.APP_NAME);
						if (0 < aIndex) {
							aFileName = aComp.getTitle().substring(0, aIndex);
						}
						
						final int aSignal = GUIUtility.showBoardModifiedNotice(aComp.getComponent(), aFileName, false);
						
						try {
							if (aSignal == javax.swing.JOptionPane.YES_OPTION) {
									aComp.save(new java.io.File(aFileName));
							}
							else if (aSignal == javax.swing.JOptionPane.CANCEL_OPTION) {
								throw new SaveCanceledException("load process is canceled");
							}
						}
						catch (SaveCanceledException e) {
							// ۑLZꂽꍇ́Aǂݍ܂Ȃ
							aComp.repaint();
							return;
						}
					}	
									
					OpenProblemDialog.getInstance();
				}
			});
			
			mRealListenerMap.put("Save", new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent inEvent) {
					BoardView aComp = (BoardView)ComponentUsher.getInstance().getActiveComponent();
					
					try {
						// t@C̎擾
						String aFileName = HashiCreatorRoot.INITIAL_TITLE;
						
						final int aIndex = aComp.getTitle().lastIndexOf(" - " + HashiCreatorRoot.APP_NAME);
						if (0 < aIndex) {
							aFileName = aComp.getTitle().substring(0, aIndex);
						}
						 
						aComp.save(new java.io.File(aFileName));
						
						// ۑꍇ́ASave menuenableɂĂ
						MenuManager.currentMenuManager().setEnabledFor(MenuManager.ITEM_SAVE, false);
					}
					catch(SaveCanceledException e) {
						System.out.println(e);
					}
					
				}
			});
			
			mRealListenerMap.put("Archive", new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent inEvent) {
				}
			});
			
			mRealListenerMap.put("Quit", new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent inEvent) {
					// TerminationManager̋N
					TerminateManager aManager = TerminateManager.getInstance();
					aManager.start();
					
					Usherable[] allFrames = ComponentUsher.getInstance().getAllComponents();
					
					for (int i = 0; i < allFrames.length; ++i) {
						Frame aFrame = (Frame)((BoardView)allFrames[i]).getComponent();
						aManager.pushEvent(new WindowEvent(aFrame, WindowEvent.WINDOW_CLOSING));
					}
					
					// windowׂĕ̂҂
					// ۂ̏ÍAWindowListenerōsĂ
					aManager.waitTermination();
					
					BoardView aComp = (BoardView)ComponentUsher.getInstance().getActiveComponent();
					aComp.repaint();
				}
			});
			
			mRealListenerMap.put("Clear", new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent inEvent) {
					System.out.println("clear : initialized board");
					
					BoardView aComp = (BoardView)ComponentUsher.getInstance().getActiveComponent();
					aComp.clear();
				}
			});
			
			mRealListenerMap.put("Resize...", new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent inEvent) {
					System.out.println("size changed"); 
					
					BoardView aComp = (BoardView)ComponentUsher.getInstance().getActiveComponent();
					final int aWidth = aComp.getBoardWidth();
					final int aHeight = aComp.getBoardHeight();
					
					SizeChangeDialog.showDialog(aComp, aWidth, aHeight);
				}
			});
		}
		
		private class MenuDispatchThread implements Runnable {
			private java.awt.event.ActionEvent mEvent;
			
			MenuDispatchThread(java.awt.event.ActionEvent inEvent) {
				mEvent = inEvent;
			}
			
			public void run() {
				String aCommand = ((java.awt.MenuItem)mEvent.getSource()).getActionCommand();
				
				java.awt.event.ActionListener aListener = 
						(java.awt.event.ActionListener)mRealListenerMap.get(aCommand);
				
				aListener.actionPerformed(mEvent);
			}
		}
	}
}

class ArchiveAction implements java.awt.event.ActionListener {
	public void actionPerformed(java.awt.event.ActionEvent inEvent) {
		System.out.println("archive process");
	}
}
