// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		KeyScrollEvent.java (package private class)
//	DATE:		2003.6.18
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.creator.view;

import java.awt.Rectangle;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;

/**
 *	L[ɂXN[dispatchCxg
 */
class KeyScrollEvent extends java.awt.AWTEvent implements java.awt.ActiveEvent {
	private static final int EVENT_ID = RESERVED_ID_MAX +1;
	BoardView mDest;
	Direction mDirection;
	Rectangle mBounds;
	
	KeyScrollEvent(BoardView inDest, Direction inDirection, Rectangle inActivePiece) {
		super(inDest, EVENT_ID);
		
		mDest = inDest;
		mDirection = inDirection;
		mBounds = inActivePiece;
	}
	
	public void dispatch() {
		if (mDest instanceof BoardScroller) {
			((BoardScroller)mDest).processKeyScroll(this);
		}
	}
}