// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		HashiCreatorRoot.java 
//	DATE:		2003.6.16	initial version
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.creator.view;

import java.awt.Component;
import java.awt.Frame;

import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;

import java.io.File;

import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardContainer;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.RootBoardContainer;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.ComponentUsher;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.SaveCanceledException;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.GUIUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.TerminateManager;

/**
 *	FrameAroot viewKw
 */
public class HashiCreatorRoot extends RootBoardContainer {
	/** ftHg̔Ֆʂ̕ */
	private static final int DEFAULT_BOARD_WIDTH = 9;

	/** ftHg̔Ֆʂ̍ */
	private static final int DEFAULT_BOARD_HEIGHT = 9;
	
	/** ^Cg */
	static final String INITIAL_TITLE = GUIUtility.INITIAL_TITLE;
	
	/** vO */
	static final String APP_NAME = "hashicreator";
	
	public static void showRootBoard() {
		RootBoardContainer aRoot
			 = new HashiCreatorRoot(new java.awt.Frame());
		aRoot.initialize();
		aRoot.createBoard(DEFAULT_BOARD_WIDTH, DEFAULT_BOARD_HEIGHT);
		
		aRoot.show();
	}
	
	private HashiCreatorRoot(Frame inComponent) {
		super(inComponent);
	}
	
	/**
	 *	̃R|[lg
	 */
	 
	protected void initializeSelf() {
		// ^Cg̎w
		setTitle(INITIAL_TITLE);
		
		Frame aComponent = (Frame)getComponent();
		
		// j[̍\z
		java.awt.MenuBar aMenuBar = MenuManager.createMenuManager(aComponent);
		aComponent.setMenuBar(aMenuBar);
		
		// Listener̓o^
		WindowHandler aHandler = new WindowHandler();
		aComponent.addWindowListener(aHandler);
		
		// ComponentUsherɓo^
		ComponentUsher.getInstance().install(this);	
		
		// Component Tree̍\z
		java.awt.ScrollPane aScroller = new java.awt.ScrollPane(java.awt.ScrollPane.SCROLLBARS_ALWAYS);
		BoardContainer aContainer = new BoardScroller(aScroller);
		addBoard(aContainer);
	}

	/**
	 *	^CgƂăZbg镶ɏC
	 *
	 *	@param inOldTitle CO̕
	 *	@return	C̕
	 */
	protected String modifiyTitleString(String inOldTitle) {
		return inOldTitle  + " - " + APP_NAME;
	}

	private class WindowHandler implements WindowListener {
		public void windowClosing(WindowEvent inEvent) {	
			if (isModified()) {
				try {
					String aFileName = INITIAL_TITLE;
					String aTitle = getTitle();
					
					final int aIndex
							 = aTitle.lastIndexOf(" - " + APP_NAME);
					if (0 < aIndex) {
						aFileName = aTitle.substring(0, aIndex);
					}
					
					final int aSignal = 
						GUIUtility.showBoardModifiedNotice(getComponent(), aFileName, true);
					
					if (javax.swing.JOptionPane.YES_OPTION == aSignal) {
						save(new java.io.File(aFileName));
					}
					else if (javax.swing.JOptionPane.CANCEL_OPTION == aSignal) {
						throw new SaveCanceledException("frame closing process is canceled");
					}
				}
				catch (SaveCanceledException e) {
					TerminateManager.getInstance().cancel();
					return;
				}
			}
				
			// Frame
			ComponentUsher.getInstance().uninstall(HashiCreatorRoot.this);
			dispose();
			
			// ׂẴt[ꂽꍇ́AAvI
			if (0 == ComponentUsher.getInstance().getComponentCount()) {
				System.out.println("all frame is closed");
				System.exit(0);
			}
		}
		
		public void windowActivated(WindowEvent inEvent) {
			ComponentUsher.getInstance().setActiveComponent(getComponent());
		}
		
		public void windowDeactivated(WindowEvent inEvent) {
			ComponentUsher.getInstance().setActiveComponent();
		}
		
		public void windowOpened(WindowEvent inEvent) {}
		public void windowClosed(WindowEvent inEvent) {}
		public void windowIconified(WindowEvent inEvent) {}
		public void windowDeiconified(WindowEvent inEvent) {}
	}
}