//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
//	NAME:		SelectStateManagerImpl.java
//	DATE:		2003.7.1
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.creator.model;

import jp.gr.java_conf.ktz.puzzle.framework.StateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.framework.DecoratedStateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.State;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.SelectionState;

public class SelectStateManagerImpl extends DecoratedStateManagerImpl {
	/**
	 *	RXgN^
	 *
	 *	@param	ʂɔzuManager
	 */
	public SelectStateManagerImpl(StateManagerImpl inManager) {
		super(inManager);
	}
	
	/**
	 *	w肳ꂽIDɑΉԂ쐬B
	 *
	 *	̃\bh́AcreateStateOfĂ΂B
	 *
	 *	@param	inStateID ԂɑΉID
	 *	@return 쐬ꂽ
	 */
	protected State createStateOfSelf(String inStateID) {
		throw new UnsupportedOperationException();
	}

	/**
	 *	ftHg̏Ԃ쐬B
	 *
	 *	̃\bh́AcreateDefaultStateOfSelfĂ΂B
	 *
	 *	@param	inStateID ԂɑΉID
	 *	@return 쐬ꂽ
	 */
	protected State createDefaultStateSelf() {
		throw new UnsupportedOperationException();
	}
	
	/**
	 *	w肵ԂKwĂꍇA
	 *	ȌԂ𔍂B
	 *	AAȌԂAManagerƊ֘AtĂȂꍇ͉A
	 *	̂܂ܕԂ
	 *
	 *	̃\bh́AfindIdentityOfĂ΂B
	 *
	 *	@param	inState	Ώۂ̏
	 *
	 *	@return	̏
	 */
	protected State dewrapState(State inState) {
		return (inState instanceof SelectionState ? 
			((SelectionState)inState).getDecorated() : inState
		);
	}
	
	/**
	 *	w肵ԂɑΉAIDԂB
	 *	́AcreateStateOf̋t̑łB
	 *
	 *	̃\bh́AfindIdentityOfĂ΂B
	 *
	 *	@param	inState ϊ
	 *	@return	ԂɑΉAID
	 */
	protected String findIdentityOfSelf(State inState) {
		throw new UnsupportedOperationException();
	}
	
	/**
	 *	Ԃ1i߂B
	 *
	 *	̃\bh́AgetNextStateĂ΂B
	 *
	 *	@param inState ݂̏
	 *	@return ̏
	 */
	protected State getNextStateSelf(State inState) {
		throw new UnsupportedOperationException();
	}
	
	/**
	 *	Ԃ1i߂B
	 *	ŁAinEventlɏ]ēJڂs
	 *
	 *	̃\bh́AgetNextStateĂ΂B
	 *
	 *	@param inState ݂̏
	 *	@param inEvent JڂɊւCxgl
	 *	@return ̏
	 */	
	protected State getNextStateSelf(State inState, StateEventCode inEvent) {
		return  new SelectionState(inState);
	}
	
	/**
	 *	Ԃ1߂B
	 *
	 *	̃\bh́AgetPrevStateSelfĂ΂B
	 *
	 *	@param inState ݂̏
	 *	@return ̏
	 */
	protected State getPrevStateSelf(State inState) {
		throw new UnsupportedOperationException();
	}
	
	/**
	 *	Ԃ1߂B
	 *	ŁAinEventlɏ]ēJڂs
	 *
	 *	̃\bh́AgetPrevStateĂ΂B
	 *
	 *	@param inState ݂̏
	 *	@param inEvent JڂɊւCxgl
	 *	@return ̏
	 */
	protected State getPrevStateSelf(State inState, StateEventCode inEvent) {
		return new SelectionState(inState);
	}
	
	/**
	 *	w肳ꂽԂł邩ǂׂ
	 *
	 *	̃\bh́AisNumberStateĂ΂B
	 *
	 *	@param	inState 
	 *	@return	łtrueԂB
	 */
	protected boolean isNumberStateSelf(State inState) {
		throw new UnsupportedOperationException();
	}
	
	/**
	 *	w肳ꂽԂ󔒂ł邩ǂׂ
	 *
	 *	̃\bh́AisSpaceStateĂ΂B
	 *
	 *	@param	inState 
	 *	@return	󔒂łtrueԂB
	 */
	protected boolean isSpaceStateSelf(State inState) {
		throw new UnsupportedOperationException();
	}
	
	/**
	 *	w肳ꂽԂAJڂł邩ǂ`FbNB
	 *	̎ł́AJڂ܂ł̃`FbN͍sȂB
	 *
	 *	̃\bh́AisTransitĂ΂B
	 *
	 *	@param inState `FbNState object
	 *	@return Jڂł̂ł΁AtrueԂB
	 */
	protected boolean isTransitSelf(State inState) {
		throw new UnsupportedOperationException();
	}
	
	/**
	 *	w肳ꂽԂAJڂł邩ǂ`FbNB
	 *
	 *	̃\bh́AisTransitĂ΂B
	 *
	 *	@param inState `FbNState object
	 *	@param inEvent ɓJڂ҂̂łΎw肷B
	 *	@return Jڂł̂ł΁AtrueԂB
	 */
	protected boolean isTransitSelf(State inState, StateEventCode inEvent) {
		return false;
	}
	
	/**
	 *	w肵StateEventCodeStateManagerŏł邩ǂ`FbN
	 *
	 *	@param	inEvent	Cxg̎
	 *	@return	łꍇAtrueԂ
	 *
	 *	@see DecoratedStateManagerImpl#isTransit(State, StateEventCode)
	 *	@see DecoratedStateManagerImpl#getNextState(State, StateEventCode)
	 *	@see DecoratedStateManagerImpl#getPrevState(State, StateEventCode)
	 */
	protected boolean acceptableEventCode(StateEventCode inEvent) {
		return (inEvent == UtilityFuncs.getSelectionEventCode());
	}
}		
