// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		ValidDocumentat.java
//	DATE:		2003.6.20
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.creator;

import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

/**
 *	w肵Formatterœ͂镶tB^DocumentNX
 */
class ValidDocumentat extends PlainDocument {
	/** tB^sFomatter */
	private Formatter mFomatter;
	
	/**
	 *	RXgN^
	 *
	 *	@param	inFomatter	tB^sFomatter
	 */
	ValidDocumentat(Formatter inFomatter) {
		mFomatter = inFomatter;
	}
	
	/**
	 *	DocumentɎw肵}
	 *	̎ł́A͕؂AÓł΁Aۂɓ͂s
	 */
	public void insertString(int inOffs, String inText, AttributeSet inAtt) {
		try {
			String aText = getText(0, getLength());
		
			if (mFomatter.validate(aText+inText)) {
				super.insertString(inOffs, inText, inAtt);
			}
		}
		catch (BadLocationException e) {
		}
	}
}
