// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		SizeChangeDialog.java
//	DATE:		2003.6.8
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.creator;

import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.JFrame;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.awt.event.FocusListener;
import java.awt.event.FocusEvent;

import java.awt.event.KeyListener;
import java.awt.event.KeyEvent;

import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;

/**
 *	Ֆʂ̋搔ύXDialog
 */
public class SizeChangeDialog extends JFrame {
	/**
	 *	Dialog\
	 *
	 *	@param	inOwner		ύXƂȂView
	 *	@param	inInitWidth	݂̔Ֆʂ̕
	 *	@param	inInitHeight	݂̔Ֆʂ̍
	 */
	public static void showDialog(
					final BoardView inOwner, 
					final int inInitWidth, 
					final int inInitHeight) 
	{
		if (java.awt.EventQueue.isDispatchThread()) {
			SizeChangeDialog aDialog = new SizeChangeDialog();
			aDialog.initialize(inOwner, inInitWidth, inInitHeight);
			aDialog.show();
		}
		else {
			Runnable aAction = new Runnable() {
				public void run() {
					showDialog(inOwner, inInitWidth, inInitHeight);
				}
			};
			
			java.awt.EventQueue.invokeLater(aAction);
		}		
	}
	
	private BoardView mOwnerFrame;
	private JTextField mWidthField;
	private JTextField mHeightField;
	
	/**
	 *	\񓙂̏
	 */
	public void initialize(
				final BoardView inOwner, 
				final int inInitWidth, 
				final int inInitHeight) 
	{
			mOwnerFrame = inOwner;
			mWidthField.setText(String.valueOf(inInitWidth));
			mHeightField.setText(String.valueOf(inInitHeight));
	}
	
	/**
	 *	Dialog̍쐬
	 */
	protected void frameInit() {
		// Text FieldfocusڂƂA͕SI
		class FocusHandler implements FocusListener {
			public void focusGained(FocusEvent inEvent) {
				JTextField aField = (JTextField)inEvent.getSource();
				
				aField.selectAll();
			}
			
			public void focusLost(FocusEvent inEvent) {}
		}
		
		// EnterL[AEscL[ɂOKA Cancelhandling
		class ApproveHandler implements KeyListener {
			public void keyPressed(KeyEvent inEvent) {
				final int aPressedKey = inEvent.getKeyCode();
				
				switch (aPressedKey) {
				case KeyEvent.VK_ESCAPE :
					// EscL[Cancel{^ɘA
					cancelAction();
					break;
				
				case KeyEvent.VK_ENTER :
					approveAction();
					break;
				}
			}
			
			public void keyReleased(KeyEvent inEvent) {}
			public void keyTyped(KeyEvent inEvent) {}
		}
		
		super.frameInit();
		
		java.awt.Container aPane = getContentPane();
		
		javax.swing.JPanel aPanel;
		
		aPanel = new javax.swing.JPanel(new java.awt.GridLayout(2, 2));
		aPane.add(aPanel, java.awt.BorderLayout.CENTER);
		{
			aPanel.add(new JLabel("width : ", JLabel.RIGHT));
			mWidthField = new JTextField();
			mWidthField.setDocument(new ValidDocumentat(new PositiveIntFormatter(2)));
			mWidthField.addFocusListener(new FocusHandler());
			mWidthField.addKeyListener(new ApproveHandler());
			aPanel.add(mWidthField);
			
			aPanel.add(new JLabel("height : ", JLabel.RIGHT));
			mHeightField = new JTextField();
			mHeightField.setDocument(new ValidDocumentat(new PositiveIntFormatter(2)));
			mHeightField.addFocusListener(new FocusHandler());
			mHeightField.addKeyListener(new ApproveHandler());
			aPanel.add(mHeightField);
		}
		
		aPanel = new javax.swing.JPanel();
		aPane.add(aPanel, java.awt.BorderLayout.SOUTH);
		{
			JButton aButton;
			
			aButton = new JButton("OK");
			aPanel.add(aButton);
			aButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent inEvent) {
					approveAction();
				}
			});
			aButton.addKeyListener(new ApproveHandler());
			
			aButton = new JButton("Cancel");
			aPanel.add(aButton);
			aButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent inEvent) {
					cancelAction();
				}
			});
			aButton.addKeyListener(new ApproveHandler());
		}
		
		pack();
	}
	
	private void approveAction() {
		try {
			final int aWidth = Integer.parseInt(mWidthField.getText());
			final int aHeight = Integer.parseInt(mHeightField.getText());
			
			mOwnerFrame.createBoard(aWidth, aHeight);
			mOwnerFrame.repaint();
			
			dispose();
		}
		catch (NumberFormatException e) {
			// ȊO͂ꂽƂ͊m肵ȂB
		}	
	}
	
	private void cancelAction() {
		dispose();
	}
	
	private SizeChangeDialog() {
	} 
}