// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		HashikakeRoot.java 
//	DATE:		2003.6.26	initial version
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.app.view.experimental;

import java.awt.Component;
import java.awt.Frame;

import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;

import java.io.File;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardContainer;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.RootBoardContainer;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.ComponentUsher;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.SaveCanceledException;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.GUIUtility;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.view.Board;

/**
 *	FrameAroot viewKw
 */
public class HashikakeRoot extends RootBoardContainer implements CommandContainer {
	/** application name */
	private static final String APP_NAME = "Hash wo ikakero";
	
	/** View */
	private CommandContainer mDecorated;
	
	private java.util.Map mTable;
	
	/**
	 *	RXgN^
	 *
	 *	@param	inContainer	wrapawt component
	 */	public HashikakeRoot(Frame inComponent) {
		super(inComponent);
	}
	
	/**
	 *	̃R|[lg
	 */
	protected void initializeSelf() {
		// ^Cg̎w
		setTitle(APP_NAME);
		
		// ComponentUsherɓo^
		ComponentUsher.getInstance().install(this);	
		
		// Listener̓o^
		((Frame)getComponent()).addWindowListener(new WindowHandler());
				
		// Component Tree̍\z
		java.awt.ScrollPane aScroller = new java.awt.ScrollPane(java.awt.ScrollPane.SCROLLBARS_ALWAYS);
		BoardScroller aContainer = new BoardScroller(aScroller);
		addBoard(aContainer);
		
		// addBoard(new Board());
		
		mDecorated = aContainer;
	}
	
	/**
	 *	Commands
	 *	̎ł́ÃvZXŏłȂƂA
	 *	艺ʂCommandContainerŎw肵CommandƂA
	 *	Command]
	 *
	 *	@param	inCommand	Command
	 */	
	 public void processCommand(Command inCommand) {
		// w肵Command̏܂ĂȂ
		// ACommandContainerŏłꍇ
		if (! inCommand.isConsumed()) {
			processCommandImpl(inCommand);
		}
		
		if (! inCommand.isConsumed()) {
			if (inCommand instanceof AbstractTopDownCommand) {
				mDecorated.processCommand(inCommand);
			}
		}
	}
	
	/**
	 *	Command̎
	 */
	protected void processCommandImpl(Command inCommand) {
		final Class aClass = inCommand.getClass();
		
		if (aClass == CheckResultCommand.class) {
			boolean aCorrected = ((CheckResultCommand)inCommand).isCorrected();
			
			System.out.println("checked ? : " + aCorrected);
			if (aCorrected) System.out.println("congratulations !!!");
		}
		else if (aClass == BoardSizeCommand.class) {
			final int aWidth = ((BoardSizeCommand)inCommand).getWidth();
			final int aHeight = ((BoardSizeCommand)inCommand).getHeight();
			
			setComponentSize(aWidth, aHeight);
			inCommand.consume();
		}
	}
	
	/**
	 *	^CgƂăZbg镶ɏC
	 *
	 *	@param inOldTitle CO̕
	 *	@return	C̕
	 */
	protected String modifiyTitleString(String inOldTitle) {
		return inOldTitle  + " - " + APP_NAME;
	}
	
	private class WindowHandler implements WindowListener {
		public void windowClosing(WindowEvent inEvent) {
			ComponentUsher.getInstance().uninstall(HashikakeRoot.this);
			((Frame)getComponent()).dispose();
			
			if (0 == ComponentUsher.getInstance().getComponentCount()) {
				System.exit(0);
			}
		}
		
		public void windowActivated(WindowEvent inEvent) {
			ComponentUsher.getInstance().setActiveComponent(getComponent());
		}

		public void windowOpened(WindowEvent inEvent) {}
		public void windowClosed(WindowEvent inEvent) {}
		public void windowDeactivated(WindowEvent inEvent) {}
		public void windowDeiconified(WindowEvent inEvent) {}
		public void windowIconified(WindowEvent inEvent) {}
	}
}

