// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		BoardScroller.java
//	DATE:		2003.5.27
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.app.view.experimental;

import java.awt.Rectangle;
import java.awt.ScrollPane;

import java.awt.event.AdjustmentEvent;

import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardContainer;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.view.Board;

/**
 *	scrolltbNViewKw
 */
class BoardScroller extends BoardContainer implements CommandContainer {
	/** View */
	private CommandContainer mDecorated;
	
	/** View */
	private CommandContainer mParent;
	
	/**
	 *	RXgN^
	 *
	 *	@param	inContainer	wrapawt component
	 */
	BoardScroller(java.awt.Container inContainer) {
		super(inContainer);
	}
	
	/**
	 *	̔Ֆʂ̏s
	 */
	protected void initializeSelf() {

		Board aBoard = new Board();
		addBoard(aBoard);
	}
	
	/**
	 *	BoardKwƂÅKw̎qݒ肷
	 *
	 *	@param	inBoard	̊Kw̎qƂȂBoard
	 */
	public void addBoard(BoardView inSubBoard) {
		super.addBoard(inSubBoard);
		
		if (inSubBoard instanceof CommandContainer) {
			mDecorated = (CommandContainer)inSubBoard;
		}
	}
	
	/**
	 *	BoardKwƂÅKw̐eݒ肷
	 *
	 *	@param	inBoard	̊Kw̐eƂȂBoard
	 */
	public void setParent(BoardView inParentBoard) {
		super.setParent(inParentBoard);
		
		if (inParentBoard instanceof CommandContainer) {
			mParent = (CommandContainer)inParentBoard;
		} 
	}
	
	/**
	 *	Commands
	 *	̎ł́ÃvZXŏłȂƂA
	 *	ʂ܂͂艺ʂCommandContainerŎw肵CommandƂ
	 *	Command]
	 *
	 *	@param	inCommand	Command
	 */
	public void processCommand(Command inCommand) {
		// w肵Command̏܂ĂȂ
		// ACommandContainerŏłꍇ
		if (! inCommand.isConsumed()) {
			processCommandImpl(inCommand);
		}
		
		// ̃vZXŏłȂƂA
		// ܂́AʂCommandContainerŎw肵CommandƂ
		if (! inCommand.isConsumed()) {
			if (inCommand instanceof AbstractTopDownCommand) {
				mDecorated.processCommand(inCommand);
			}
			else if (inCommand instanceof AbstractBottomUpCommand) {
				mParent.processCommand(inCommand);
			}
		}
	}
	
	/**
	 *	Command̎
	 */
	protected void processCommandImpl(Command inCommand) {
		final Class aClass = inCommand.getClass();
		
		if (aClass == PieceSizeCommand.class) {
			final int aSize = ((PieceSizeCommand)inCommand).getPieceSize();
			setPieceSizeSelf(aSize);
			inCommand.consume();
		}
		else if (aClass == BoardSizeCommand.class) {
			final int aWidth = ((BoardSizeCommand)inCommand).getWidth();
			final int aHeight = ((BoardSizeCommand)inCommand).getHeight();
			setComponentSizeSelf(aWidth, aHeight);
		}
	}
	
	/**
	 *	Boardɑ΂Ă1s[X̃TCYZbg
	 *
	 *	@param	inSize ZTCY
	 */
	protected int setPieceSizeSelf(final int inSize) {
		// Scroller̃XN[ʂύX
		
		ScrollPane aPane = (ScrollPane)getComponent();
		
		aPane.getHAdjustable().setUnitIncrement(inSize);
		aPane.getVAdjustable().setUnitIncrement(inSize);
		
		return inSize;
	}
	
	/**
	 *	R|[lg̃TCYύX
	 *	ƂēnĺAsubcomponent̃TCYłB
	 *	
	 *	@param	inWidth		subcomponent̕
	 *	@param	inHeight	subcomponent̍
	 *	@return	component̃TCY
	 */
	protected void setComponentSizeSelf(final int inWidth, final int inHeight) {
		ScrollPane aPane = (ScrollPane)getComponent();
		final int aHHeight = aPane.getHScrollbarHeight();
		final int aVWidth = aPane.getVScrollbarWidth();
		
		int aWidth = inWidth + aVWidth;
		int aHeight = inHeight + aHHeight;
		aPane.invalidate();		
		aPane.setSize(aWidth, aHeight);
	}
}