// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		BoardModel.java
//	DATE:		2003.5.8
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import java.awt.Point;

import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.NullModel;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;

/**
 *	pY̔ՖʂǗNX
 */
public class BoardModel extends AbstractDecoratedModel {
	/**
	 *	Ֆʂ̊eZǗNX
	 */
	private static class Cell {
		/** ݂̃Z̏ */
		private State mState;
		
		/**
		 *	RXgN^
		 *
		 *	@param	inID	ԂɑΉIDl
		 */
		Cell(final String inID) {
			StateManager amanager = StateManager.getInstance();
			
			try {
				Integer.parseInt(inID.trim());
				mState = amanager.createStateOf(inID);	
			}
			catch(NumberFormatException e) {
				mState = amanager.createDefaultState();
			}
		}
		
	
		/**
		 *	݂̏ԂAԂɖ߂
		 */
		void reset() {
			if (! isNumber()) {
				mState = StateManager.getInstance().createDefaultState();
			}
		}
		
		/**
		 *	݂̏Ԃł邩ǂmF
		 *
		 *	@return ̏ꍇAtrueԂ
		 */
		boolean isNumber() {
			return StateManager.getInstance().isNumberState(mState);
		}
		
		/**
		 *	݂̏Ԃ󔒂ł邩ǂmF
		 *
		 *	@return 󔒂̏ꍇAtrueԂ
		 */
		boolean isSpace() {
			return StateManager.getInstance().isSpaceState(mState);
		}
		
		/**
		 *	̃Zw肵StateEventCodeŎ̏ԋUɂł邩ǂmF
		 *
		 *	@return JڂłꍇAtrueԂ
		 */
		boolean isTransit(StateEventCode inEventCode) {
			return StateManager.getInstance().isTransit(mState, inEventCode);
		}
		
		/**
		 *	̃Ž݂̏ԂԂ
		 *
		 *	@return	̃Ž݂̏ԂԂB
		 */
		State getCurState() {
			return mState;
		}
		
		/**
		 *	̃Z̏Ԃw肵ԂɕύX
		 *
		 *	@param	inState	ύX̏
		 */
		void setCurState(State inState) {
			mState = inState;
		}
	}
	
	/** TCY0PointIuWFNg̔z */
	private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
	
	/** eZ̏W */
	private Cell[] mCells;
	
	// Board̕
	private int mWidth;
	
	// Board
	private int mHeight;
	
	/** ŌɏCZ̈ʒu */
	private Point[] mModifiedPos = NO_MODIFIED;
	
	/**
	 *	ftHgRXgN^
	 *	̎ł́AbvModelƂ
	 *	puzzle.framework.NullModelw肵Ă
	 */
	public BoardModel() {
		this(NullModel.getInstance());
	}
	
	/**
	 *	RXgN^
	 *	w肵ModelbvModelƂďLB
	 *	̃\bhāA
	 *	Model̉ɔzuꂽModelɑ΂āA\bh͓]Ȃ
	 */
	public BoardModel(Model inModel) {
		super(inModel);
	}
	
	/**
	 *	w肳ꂽTCỸ{[h쐬
	 *
	 *	@param	inWidth	̌
	 *	@param	inHeight	č
	 */
	public void createBoardSelf(final int inWidth, final int inHeight) {
		mWidth = inWidth;
		mHeight = inHeight;
		
		mCells = new Cell[inWidth * inHeight];
	}
	
	/**
	 *	ݒ肷B
	 *
	 * 	@param	inProblem	̏
	 */
	public void setProblem(ProblemInfo inInfo) {
		// ̏ƃTCYقȂĂ΃{[h쐬ȂB
		if (mWidth != inInfo.getWidth() || mHeight != inInfo.getHeight()) {
			createBoard(inInfo.getWidth(), inInfo.getHeight());
		}
		
		java.util.Set aSet = new java.util.HashSet();
		
		for (int y = 0, i = 0; y < mHeight; ++y) {
			for (int x = 0; x < mWidth; ++x) {
				mCells[y * mWidth + x] = new Cell((String)inInfo.getRecordAt(i++));
				
				aSet.add(new Point(x, y));
			}
		}
		
		mModifiedPos = (Point[])aSet.toArray(new Point[aSet.size()]);
	}
	
	/**
	 *	݂̏Ԃǂ`FbN
	 *
	 *	@return ȂtrueԂ
	 */
	public boolean check() {
		return false;
	}
	
	/**
	 *	Ԃɖ߂
	 */
	public void reset() {
		java.util.Set aSet = new java.util.HashSet();
		
		for (int y = 0, i = 0; y < getHeight(); ++y) {
			for (int x = 0; x < getWidth(); ++x) {
				Cell aCell = getCellAt(x, y);
				
				if (! (aCell.isSpace() ||  aCell.isNumber())) {
					aSet.add(new Point(x, y));
					aCell.reset();
				}
			}
		}
		
		mModifiedPos = (Point[])aSet.toArray(new Point[aSet.size()]);
	}
	
	
	/**
	 *	{[h̃TCYԂ 
	 *
	 *	@return TCY
	 */
	public java.awt.Dimension getSize() {
		return new java.awt.Dimension(mWidth, mHeight);
	}
	
	/**
	 *	{[h̕Ԃ
	 * 
	 *	@return 
	 */
	public int getWidth() {
		return mWidth;
	}
	
	/**
	 *	{[h̍ԂB
	 * 
	 *	@return 
	 */
	public int getHeight() {
		return mHeight;
	}
	
	/**
	 *	w肳ꂽʒu̖ʂ̏ԂԂB
	 *
	 *	@param inX	XW
	 *	@param	inY	YW
	 *	@return 
	 */
	public State getCurStateAt(final int inX, final int inY) {
		Cell aCell = getCellAt(inX, inY);
		return getCellAt(inX, inY).getCurState();
	}
	
	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1i߂B
	 *
	 *	@param inX	XW
	 *	@param	inY	YW
	 *
	 *	@throws	UnsupportedOperationException ̃\bhĂяoꍇ
	 */
	public void nextStateAt(final int inX, final int inY) {
		// nextԑJڂinEventKw肷B
		throw new UnsupportedOperationException("Needs to pass a arg inEvent for the method nextStateAt.");
	}

	/** 
	 *	w肳ꂽʒu̖ʂ̏ԂStateEventCodeɂ1i߂B
	 *	
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@param	inEvent	JڂɊւl
	 */
	public void nextStateAt(final int inX, final int inY, StateEventCode inEvent) {
		if (isNumberAt(inX, inY)) return;
		
		State aState = getCurStateAt(inX, inY);
		
		aState = StateManager.getInstance().getNextState(aState, inEvent);

		setCurStateAt(inX, inY, aState);
	}
	
	/** 
	 * w肳ꂽʒu̖ʂ̏Ԃ1߂B
	 *
	 * @param	inX	XW
	 * @param	inY	YW
	 *
	 *	@throws	UnsupportedOperationException ̃\bhĂяoꍇ
	 */
	public void prevStateAt(final int inX, final int inY) {
		throw new UnsupportedOperationException("Needs to pass a arg inEvent for the method prevStateAt.");
	}

	/** 
	 *	w肳ꂽʒu̖ʂ̏ԂinEventlɂ1߂B
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@param	inEvent	JڂɊւl
	 */
	public void prevStateAt(final int inX, final int inY, StateEventCode inEvent) {
		if (isNumberAt(inX, inY)) return;
		
		State aState = getCurStateAt(inX, inY);
		aState = StateManager.getInstance().getPrevState(aState, inEvent);
		
		setCurStateAt(inX, inY, aState);
	}
	
	/**
	 *	w肵ʒũZ̏Ԃw肵ԂɕύX
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@param	inState ύX̏
	 */
	private void setCurStateAt(final int inX, final int inY, State inState) {
		Cell aCell = getCellAt(inX, inY);
		
		aCell.setCurState(inState);
	}
	
	/** 
	 *	ŌɏCʂ̈ʒuԂB
	 *
	 *	@return ŌɏCʂ̈ʒu̔z
	 */
	protected java.awt.Point[] lastModifiedSelf() {
		return mModifiedPos;
	}
	
	/**
	 *	ModelύXꂽǂ𒲂ׂB
	 *
	 *	@return	ύXĂtrueԂB
	 */
	protected boolean isModifiedSelf() {
		return (mModifiedPos.length != 0);
	}
	
	/**
	 *	Model̕ύXNA
	 */
	protected void flushSelf() {
		mModifiedPos = NO_MODIFIED;
	}
	
	/**
	 *	w肳ꂽʒu̖ʂǂׂB
	 *	̎ł́ABoadOw肳ꂽꍇ́AfalseԂB
	 *
	 *	@param inX	XW
	 *	@param	inY	YW
	 *	@return	Ȃtrue
	 */
	public boolean isNumberAt(final int inX, final int inY) {
		if (! contains(inX, inY)) return false;
		
		return getCellAt(inX, inY).isNumber();
	}
	
	/**
	 *	w肳ꂽʒu̖ʂ󔒂ǂׂB
	 *	̎ł́ABoadOw肳ꂽꍇ́AfalseԂB
	 *
	 *	@param inX	XW
	 *	@param	inY	YW
	 *	@return	󔒂Ȃtrue
	 */
	public boolean isSpaceAt(final int inX, final int inY) {
		if (! contains(inX, inY)) return false;
		
		return getCellAt(inX, inY).isSpace();
	}

	/**
	 *	w肳ꂽʒu̖ʂJڂł邩ǂׂB
	 *	̎ł́ABoadOw肳ꂽꍇ́AfalseԂB
	 *
	 *	@param	inX XW
	 *	@param	inY YW
	 *	@param	inTransitCode JڂɊւl
	 *	@return	Jڂł̂ł΁AtrueԂB
	 */
	public boolean isTransitAt(
			final int inX, final int inY, 
			StateEventCode inTransitCode)
	{
		if (! contains(inX, inY)) return false;
		
		return getCellAt(inX, inY).isTransit(inTransitCode);
	}

	/**
	 *	w肳ꂽʒu̖ʂJڂł邩ǂׂB
	 *	̎ł́Ã\bhĂяoƂAɗO𑗏o
	 *
	 *	@param	inX XW
	 *	@param	inY YW
	 *	@return	Jڂł̂ł΁AtrueԂB
	 *
	 *	@throws	UnsupportedOperationException ̃\bhĂяoƂ
	 */
	public boolean isTransitAt(final int inX, final int inY) {
		throw new UnsupportedOperationException("the method isTransitAt(int, int) is unsupported");
	}

	/**
	 *	w肳ꂽStateEventCodẽfŏł邩ǂ`FbNB
	 *
	 *	@param	inCode`FbNStateEventCode
	 *	@return	̃fŏł̂ł΁AtrueԂ
	 */
	public boolean isAcceptableEvent(StateEventCode inCode) {
		return (inCode == HashikakeStateEventCode.createVerticalCode() ||
					inCode == HashikakeStateEventCode.createNoTransitCode());
	}
	

	/**
	 *	IԂύXꍇɌĂ΂郁\bh
	 *
	 *	@param	ύXɊւCxg
	 *	@return	ModelύXꂽȂtrueԂ
	 */
	public void selectionChanged(ModelChangeEvent inEvent) {
		if (NO_MODIFIED != mModifiedPos) mModifiedPos = NO_MODIFIED;
	}
	
	/**
	 *	IԂm肵ꍇɌĂ΂郁\bh
	 *
	 *	@param	ύXɊւCxg
	 *	@return	ModelύXꂽȂtrueԂ
	 */
	public void selectionDetermined(ModelChangeEvent inEvent) {
		StateEventCode aTransitCode = UtilityFuncs.resolveTransitCode(inEvent.getDirection());
		Point[] aPos = inEvent.lastModified();
		
		for (int i = 0; i < aPos.length; ++i) {
			// JڂłȂꍇ͖B
			if (! isTransitAt(aPos[i].x, aPos[i].y, aTransitCode)) continue;
			
			if (inEvent.isTransitNext()) {
				nextStateAt(aPos[i].x, aPos[i].y, aTransitCode);
			}
			else {
				prevStateAt(aPos[i].x, aPos[i].y, aTransitCode);
			}
		}
		
		mModifiedPos = aPos;
	}
	
	/**
	 *	w肳ꂽʒu{[ḧǂׂ 
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@return	{[ḧȂtrue
	 */
	public boolean contains(final int inX, final int inY) {
		return (inX >= 0 && inX < mWidth && inY >= 0 && inY < mHeight);
		
	}

	/**
	 *	w肵ʒũZ̐ԂԂB
	 *	̎ł́Ã\bh͎gpȂ
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *
	 *	@throws	UnsupportedOperationException ̃\bhĂяoƂ
	 */
	public State getCorrectStateAt(final int inX, final int inY) {
		throw new UnsupportedOperationException(
				"This model isnot supported getCorrectStateAt method."
		);
	}
	
	/**
	 *	w肵ʒuCellIuWFNgoB
	 *	w肵ʒuՊÔƂAO𑗏oB
	 *	ĂяoÓAKcontains\bhŔՊOł邩ǂ`FbN邱
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@return	w肵ʒuCellIuWFNgԂ
	 *
	 *	@throws	IndexOutOfBoundsException w肵ʒuՊÔƂ
	 */
	private Cell getCellAt(final int inX, final int inY) {
		if (inX < 0 || inY < 0 || inX >= mWidth || inY >= mHeight) {
			throw new IndexOutOfBoundsException(
				"0 < x <= " + mWidth + ", 0 < y <= " + mHeight + " (inX : " 
				+ inX + ", inY : " + inY + ")"
			);
		}
		
		return mCells[mWidth * inY + inX];
	}
}	
	