// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME	:	AbstractDecoratedModel.java.java
//	DATE	:	2003.5.9
//	CREATOR	:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.State;

/**
 *	Decoraterp^[ŎfB
 *	ł́AׂĂ͓̎qõ\bhĂԂB
 *	<code>AbstractDecoratedModel</code>gNXŁA
 *	KvɉāA\bhI[o[Ch邱
 */
public abstract class AbstractDecoratedModel 
						extends jp.gr.java_conf.ktz.puzzle.framework.AbstractDecoratedModel 
						implements ModelChangeDispatcher, ModelChangeListener
{
	/** Model̕ύXʒmIuWFNg */
	protected ModelChangeDispatcher mDecoratedDispatcher;
	
	/**
	 *	RXgN^
	 *	̎ł́AfR[g鑤ModelA
	 *	ModelChangeDispatcherĂꍇA
	 *	ModelChangeDispatcher̃CX^XƂďLB
	 *
	 *	@param	inModel	fR[g鑤Model
	 */
	protected AbstractDecoratedModel(Model inModel) {
		super(inModel);
		
		if (inModel instanceof ModelChangeDispatcher) {
			mDecoratedDispatcher = (ModelChangeDispatcher)inModel;
		}
	}
	
	/**
	 *	ModelChangeEventɏ]āAModelXVB
	 *
	 *	@param	inEvent ύXʒmCxg
	 */
	public void processModelChange(ModelChangeEvent inEvent) {
		switch (inEvent.getMode()) {
		case ModelChangeEvent.SELECT_MODE :
			selectionChanged(inEvent);
			break;
		
		case ModelChangeEvent.DETERMINE_MODE :
			selectionDetermined(inEvent);
			break;
		}
		
		if (null != mDecoratedDispatcher) {
			mDecoratedDispatcher.processModelChange(inEvent);
		}
	}
}	
	