// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME :		MainFrame.java
//	DATE :		2003.5.9
//	CREATOR	:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.app;


import java.awt.BorderLayout;
import java.awt.Frame;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.io.File;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.OpenProblemDialog;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.ComponentUsher;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.Usherable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ProblemUnmarshalable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ProblemInfoBean;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.GUIUtility;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.view.Board;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.HashikakeStateManagerImpl;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.view.experimental.*;

/**
 *	Ֆʂi[t[
 *	̃NX́Amain routinecāÂׂẴ\bh폜\ł
 *
 *		initialize\bh -- HashikakeRoot.javaɈڂ\
 *		createMenu\bh -- MenuManager̎NX쐬AɈڂ\
 */
public class MainFrame extends Frame {
	private static final int OFFSET_POS_PER_FRAME = 24;
	private static int sOffsetCount = 0;
	
	private Board mBoard;
	
	/**
	 *	main routine
	 *	
	 *	̃vOentrance point
	 */
	public static void main(String[] inArgs) {
		// ԑJڃ}l[W[̏
		StateManager.initialize(new HashikakeStateManagerImpl());
		
		MainFrame f = new MainFrame();
		f.initialize(); 

			
		HashikakeRoot aRoot = new HashikakeRoot(f);
		aRoot.initialize();
	
		f.show();
	}
	
	/**
	 *	Frame
	 */
	public void initialize() {
		// j[o[̏
		java.awt.MenuBar aMenuBar = createMenu();
		setMenuBar(aMenuBar);		
		
		// Frame̐ATCYɉĈʒu𒲐B
		int aPos = OFFSET_POS_PER_FRAME*sOffsetCount;
		
		++sOffsetCount;
		
		java.awt.Dimension aScreenSize
			 = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
			 
		if (aScreenSize.width < aPos + getWidth()
				 || aScreenSize.height < aPos + getHeight()) 
		{
			sOffsetCount = 0;
			aPos = 0;
		}
		
		setLocation(aPos, aPos);
	}
	
	/**
	 *	MenuBar\z
	 *
	 *	@return	\zMenuBar̃CX^X
	 */
	private java.awt.MenuBar createMenu() {
		java.awt.MenuBar aMenuBar = new java.awt.MenuBar();
	
		java.awt.Menu aFile = new java.awt.Menu("File");
		aMenuBar.add(aFile);
		
		{
			java.awt.MenuItem aItem;
			
			aItem = new java.awt.MenuItem("New");
			aItem.addActionListener(MenuDispatcher.getInstance());
			aFile.add(aItem);
			
			aItem = new java.awt.MenuItem("New Problem");
			aItem.addActionListener(MenuDispatcher.getInstance());
			aFile.add(aItem);
			
			aItem = new java.awt.MenuItem("Quit");
			aItem.addActionListener(MenuDispatcher.getInstance());
			aFile.add(aItem);
		}
		
		java.awt.Menu aOpetate = new java.awt.Menu("Operate");
		aMenuBar.add(aOpetate);
		{
			java.awt.MenuItem aItem;
			
			aItem = new java.awt.MenuItem("Reset");
			aItem.addActionListener(MenuDispatcher.getInstance());
			aOpetate.add(aItem);
			
			aItem = new java.awt.MenuItem("Check");
			aItem.addActionListener(MenuDispatcher.getInstance());
			aOpetate.add(aItem);
		}
		
		return aMenuBar;
	}
	
	/**
	 *	ftHgRXgN^
	 */
	public MainFrame() { 
	}
}

/**
 *	j[̃nhOsNX
 */
class MenuDispatcher implements ActionListener {
	/** ̃AvŗB̃CX^X */
	private static ActionListener sInstance = new MenuDispatcher();
	
	/** 
	 *	̃AvŗB̃CX^XԂ
	 *
	 *	@return	̃AvŗB̃CX^XԂ
	 */
	public static ActionListener getInstance() {
		return sInstance;
	}
	
	/**
	 *	w肵MenuItemɑ΂Actions
	 */
	public void actionPerformed(ActionEvent inEvent) {
		String aSignal = inEvent.getActionCommand();
		
		if (aSignal.equals("New")) {
			MainFrame f = new MainFrame();
			f.initialize();
			
			f.show();		
		}
		else if (aSignal.equals("New Problem")) {
			OpenProblemDialog.getInstance();
		}
		else if (aSignal.equals("Quit")) {
			System.exit(0);
		}
		else if (aSignal.equals("Reset")) {
			Usherable aUsher = ComponentUsher.getInstance().getActiveComponent();
			
			if (aUsher instanceof CommandContainer) {
				CommandContainer aCommander = (CommandContainer)aUsher;
				java.awt.AWTEvent aCommand = new ResetCommand(aCommander);

				java.awt.Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(aCommand);
			}
		}
		else if (aSignal.equals("Check")) { 
			Usherable aUsher = ComponentUsher.getInstance().getActiveComponent();
			
			if (aUsher instanceof CommandContainer) {
				CommandContainer aCommander = (CommandContainer)aUsher;
				java.awt.AWTEvent aCommand = new CheckCommand(aCommander);

				java.awt.Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(aCommand);
			}
		}
	}
}