//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//	NAME:		RenderEvent.java
//	DATE:		2003.5.24
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.framework;

import java.awt.Rectangle;
import java.awt.Graphics;

import jp.gr.java_conf.ktz.puzzle.framework.State;

/**
 *	RenderListenerɓnp[^
 */
public class RenderEvent {	
	private Renderer mRenderer;
	private Graphics mGraphics;
	private Rectangle mBounds;
	private State mState;
	
	/**
	 *	ftHgRXgN^
	 *	̎ł́AȂ
	 */
	public RenderEvent() {
	}
	
	/**
	 *	RXgN^
	 *
	 *	@param	inRenderer ĂяoB
	 *	@param	inGra ĕ`ΏۂƂȂGraphicsIuWFNgB
	 *	@param	inBounds ĕ`悷ׂՖʂ̗̈iscreenWnjB
	 *	@param	inState `悵ԁB
	 */
	public RenderEvent(Renderer inRenderer, Graphics inGra, Rectangle inBounds, State inState) {
		reset(inRenderer, inGra, inBounds, inState);
	}
	
	/**
	 *	w肵RenderEventZbgB
	 *
	 *	@param	inGra ĕ`ΏۂƂȂGraphicsIuWFNgB
	 *	@param	inBounds ĕ`悷ׂՖʂ̗̈iscreenWnjB
	 *	@param	inState `悵ԁB
	 */
	public final void reset(Renderer inRenderer, Graphics inGra, Rectangle inBounds, State inState) {
		mRenderer = inRenderer;
		mGraphics = inGra;
		mBounds = inBounds;
		mState = inState;
	}
	
	/**
	 *	p[^FĂяoAԂB
	 *
	 *	@return ĂяoB
	 */
	public Renderer getSource() {
		return mRenderer;
	}
	
	/**
	 *	p[^Fĕ`ΏۂƂȂGraphicsIuWFNgAԂB
	 *
	 *	@return	ĕ`ΏۂƂȂGraphicsIuWFNgB
	 */
	public Graphics getGraphics() {
		return mGraphics;
	}
	
	/**
	 *	p[^Fĕ`悷ׂՖʂ̗̈AԂ
	 *
	 *	@return	ĕ`悷ׂՖʂ̈ʒuB
	 */
	public Rectangle getBounds() {
		return mBounds;
	}
		
	/**
	 *	p[^F`悵ԁAԂB
	 *
	 *	@return	`悵ԁB
	 */
	public State getState() {
		return mState;
	}
}


