//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//	NAME:		ProblemInfo.java
//	DATE:		2003.6.18
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.framework;

import java.util.List;
/**
 *
 *	̏W񂷂C^[tF[X
 *
 */
public class ProblemInfo {
	/** Ֆʂɑ΂As[XʒũItZbg */
	private int mOffset;
	
	/**	̃s[X */
	private int mWidth;
	
	/** ̃s[X */
	private int mHeight;
	
	/** es[XRecordi[List */
	private List mPieceRecords;
	
	/**
	 *	RXgN^
	 *	
	 *	@param	inWidth ̃s[X
	 *	@param	inHeight ̃s[X
	 *	@param	inProblem eX̃s[X𕶎\ƂĒ
	 */
	public ProblemInfo(final int inWidth, final int inHeight, String[] inProblem) {
		this (0, inWidth, inHeight, java.util.Arrays.asList(inProblem));
	}
	
	/**
	 *	RXgN^
	 *	
	 *	@param	inOffset s[XʒũItZbg
	 *	@param	inWidth ̃s[X
	 *	@param	inHeight ̃s[X
	 *	@param	inRecords es[XRecordi[List
	 */
	public ProblemInfo(
				final int inOffset, 
				final int inWidth, final int inHeight, 
				List inRecords) 
	{
		mOffset = inOffset;
		mWidth = inWidth;
		mHeight = inHeight;
		mPieceRecords = inRecords;
	}
	
	/**
	 *	@return 蕶Ԃ
	 */
	public Object getRecordAt(final int inIndex) {
		return mPieceRecords.get(inIndex);
	}
	
	/**
	 *	@return	Ֆʂɑ΂As[XʒũItZbgԂ
	 */
	public int getOffset() {
		return mOffset;
	}
	
	/**
	 *	@return {[h̕Ԃ
	 */
	public int getWidth() {
		return mWidth;
	}
	
	/**
	 *	@return {[h̍Ԃ
	 */
	public int getHeight() {
		return mHeight;
	}
	
	public String toString() {
		return ProblemInfo.class + " [mWidth : " + mWidth + ", mHeight : " + mHeight
				+ ", record : " + mPieceRecords + "]";
	}
}
