/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.util.ArrayList;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.binding.classes.MarshalBuilder;
import org.jibx.binding.classes.MarshalUnmarshalBuilder;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.classes.UnmarshalBuilder;
import org.jibx.binding.def.BindingConstants;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.BoundClass;
import org.jibx.binding.def.DefinitionContext;
import org.jibx.binding.def.IAttribute;
import org.jibx.binding.def.IChildValue;
import org.jibx.binding.def.IElement;
import org.jibx.binding.def.IParent;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.StructureDefinition;
import org.jibx.binding.def.ValueDefinition;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.UnmarshallingContext;

public abstract class ObjectMapping
implements BindingConstants,
IChildValue,
IParent {
    protected static final String ACCESS_PUBLIC = "public";
    protected static final String ACCESS_PROTECTED = "protected";
    protected static final String ACCESS_PACKAGE = "package";
    protected static final String ACCESS_PRIVATE = "private";
    protected static final String UNMARSHAL_SUFFIX = "_unmarshal";
    protected static final String ISAT_SUFFIX = "_isat";
    protected static final String MARSHAL_SUFFIX = "_marshal";
    protected static final String ATTUNMARSHAL_SUFFIX = "_attunmarshal";
    protected static final String ATTMARSHAL_SUFFIX = "_attmarshal";
    protected static final String GETID_SUFFIX = "_getid";
    protected static final String ISAT_SIGNATURE = "(Lorg/jibx/runtime/impl/UnmarshallingContext;)Z";
    protected static final String MARSHAL_SIGNATURE = "(Lorg/jibx/runtime/impl/MarshallingContext;)V";
    protected static final String UNMARSHAL_SIGNATURE = "(Lorg/jibx/runtime/impl/UnmarshallingContext;)Ljava/lang/Object;";
    protected static final String MARSHAL_WRITESTARTNAMESPACES = "org.jibx.runtime.impl.MarshallingContext.startTagNamespaces";
    protected static final String MARSHAL_WRITESTARTATTRIBUTES = "org.jibx.runtime.impl.MarshallingContext.startTagAttributes";
    protected static final String MARSHAL_WRITESTARTNOATTRIBUTES = "org.jibx.runtime.impl.MarshallingContext.startTag";
    protected static final String MARSHAL_STARTNAMESPACESSIGNATURE = "(ILjava/lang/String;[I[Ljava/lang/String;)Lorg/jibx/runtime/impl/MarshallingContext;";
    protected static final String MARSHAL_WRITESTARTSIGNATURE = "(ILjava/lang/String;)Lorg/jibx/runtime/impl/MarshallingContext;";
    protected static final String MARSHAL_CLOSESTARTCONTENT = "org.jibx.runtime.impl.MarshallingContext.closeStartContent";
    protected static final String MARSHAL_CLOSESTARTEMPTY = "org.jibx.runtime.impl.MarshallingContext.closeStartEmpty";
    protected static final String MARSHAL_CLOSESTARTSIGNATURE = "()Lorg/jibx/runtime/impl/MarshallingContext;";
    protected static final String MARSHAL_WRITEENDMETHOD = "org.jibx.runtime.impl.MarshallingContext.endTag";
    protected static final String MARSHAL_WRITEENDSIGNATURE = "(ILjava/lang/String;)Lorg/jibx/runtime/impl/MarshallingContext;";
    protected static final String UNMARSHAL_PARSESTARTATTRIBUTES = "org.jibx.runtime.impl.UnmarshallingContext.parseToStartTag";
    protected static final String UNMARSHAL_PARSESTARTNOATTRIBUTES = "org.jibx.runtime.impl.UnmarshallingContext.parsePastStartTag";
    protected static final String UNMARSHAL_PARSEPASTSTART = "org.jibx.runtime.impl.UnmarshallingContext.parsePastStartTag";
    protected static final String UNMARSHAL_PARSESTARTSIGNATURE = "(Ljava/lang/String;Ljava/lang/String;)V";
    protected static final String UNMARSHAL_PARSEENDMETHOD = "org.jibx.runtime.impl.UnmarshallingContext.parsePastEndTag";
    protected static final String UNMARSHAL_PARSEENDSIGNATURE = "(Ljava/lang/String;Ljava/lang/String;)V";
    protected static final String UNMARSHAL_ISATMETHOD = "org.jibx.runtime.impl.UnmarshallingContext.isAt";
    protected static final String UNMARSHAL_ISATSIGNATURE = "(Ljava/lang/String;Ljava/lang/String;)Z";
    protected static final String JIBX_EXCEPTION = "org.jibx.runtime.JiBXException";
    protected static final String MARSHALLABLE_METHODNAME = "marshal";
    protected static final String MARSHALLABLE_SIGNATURE = "(Lorg/jibx/runtime/impl/MarshallingContext;)V";
    protected static final String GETMARSHALLER_METHOD = "org.jibx.runtime.impl.MarshallingContext.getMarshaller";
    protected static final String GETMARSHALLER_SIGNATURE = "(ILjava/lang/String;)Lorg/jibx/runtime/IMarshaller;";
    protected static final String MARSHALLERMARSHAL_METHOD = "org.jibx.runtime.IMarshaller.marshal";
    protected static final String MARSHALLERMARSHAL_SIGNATURE = "(Ljava/lang/Object;Lorg/jibx/runtime/impl/MarshallingContext;)V";
    protected static final String IMARSHALLABLE_INTERFACE = "org.jibx.runtime.IMarshallable";
    protected static final int ACC_PRIVATE = 0;
    protected static final int ACC_PACKAGE = 1;
    protected static final int ACC_PROTECTED = 2;
    protected static final int ACC_PUBLIC = 3;
    protected IParent m_parent;
    protected DefinitionContext m_defContext;
    protected BoundClass m_class;
    protected String m_variantSuffix;
    protected NameDefinition m_name;
    protected boolean m_isAsAttributes;
    protected int m_useAccess;
    protected ClassFile m_marshaller;
    protected ClassFile m_unmarshaller;
    protected int m_indexNumber;
    protected String m_factory;
    protected String m_preSetMethod;
    protected String m_postSetMethod;
    protected String m_preGetMethod;
    protected ArrayList m_attributes;
    protected ArrayList m_elements;
    private ClassItem m_unmarshalMethod;
    private ClassItem m_marshalMethod;
    private ClassItem m_unmarshalAttributes;
    private ClassItem m_marshalAttributes;
    private ClassItem m_isAtMethod;
    protected IChildValue m_idChild;

    public ObjectMapping(IParent iParent) {
        this.m_parent = iParent;
        this.m_defContext = iParent.getDefinitionContext();
        this.m_attributes = new ArrayList();
        this.m_elements = new ArrayList();
        this.m_isAsAttributes = iParent.isAttributeDefault();
    }

    protected void setClass(String string) throws JiBXException {
        this.m_class = BoundClass.getInstance(string);
        this.m_variantSuffix = Integer.toString(this.m_class.countBindingUse(this.m_parent.getBindingRoot().getIndex()));
    }

    public BoundClass getBoundClass() {
        BoundClass boundClass = this.m_class;
        if (boundClass == null) {
            return this.m_parent.getBoundClass();
        }
        return boundClass;
    }

    public boolean isAttributeDefault() {
        return this.m_isAsAttributes;
    }

    public DefinitionContext getDefinitionContext() {
        return this.m_defContext;
    }

    public BindingDefinition getBindingRoot() {
        return this.m_parent.getBindingRoot();
    }

    public boolean isSeparateElement() {
        return this.m_name != null;
    }

    protected void genMarshalAttributesCode(MarshalBuilder marshalBuilder) throws JiBXException {
        int n = 0;
        while (n < this.m_attributes.size()) {
            IAttribute iAttribute = (IAttribute)this.m_attributes.get(n);
            iAttribute.genAttributeMarshal(marshalBuilder);
            ++n;
        }
    }

    protected void genMarshalElementsCode(MarshalBuilder marshalBuilder) throws JiBXException {
        int n = 0;
        while (n < this.m_elements.size()) {
            IElement iElement = (IElement)this.m_elements.get(n);
            iElement.genElementMarshal(marshalBuilder);
            ++n;
        }
    }

    protected void genMarshalCode(MarshalBuilder marshalBuilder) throws JiBXException {
        marshalBuilder.loadContext();
        if (this.m_name != null) {
            this.m_name.genPushIndexPair(marshalBuilder);
            boolean bl = false;
            if (this.m_attributes.size() > 0 || this.hasNamespace()) {
                if (this.hasNamespace()) {
                    this.genLoadNamespaces(marshalBuilder);
                    marshalBuilder.appendCallVirtual(MARSHAL_WRITESTARTNAMESPACES, MARSHAL_STARTNAMESPACESSIGNATURE);
                } else {
                    marshalBuilder.appendCallVirtual(MARSHAL_WRITESTARTATTRIBUTES, "(ILjava/lang/String;)Lorg/jibx/runtime/impl/MarshallingContext;");
                }
                if (this.m_attributes.size() > 0) {
                    this.genMarshalAttributesCode(marshalBuilder);
                }
                if (this.m_elements.size() > 0) {
                    marshalBuilder.appendCallVirtual(MARSHAL_CLOSESTARTCONTENT, MARSHAL_CLOSESTARTSIGNATURE);
                } else {
                    marshalBuilder.appendCallVirtual(MARSHAL_CLOSESTARTEMPTY, MARSHAL_CLOSESTARTSIGNATURE);
                    bl = true;
                }
            } else {
                marshalBuilder.appendCallVirtual(MARSHAL_WRITESTARTNOATTRIBUTES, "(ILjava/lang/String;)Lorg/jibx/runtime/impl/MarshallingContext;");
            }
            if (!bl) {
                this.genMarshalElementsCode(marshalBuilder);
                this.m_name.genPushIndexPair(marshalBuilder);
                marshalBuilder.appendCallVirtual(MARSHAL_WRITEENDMETHOD, "(ILjava/lang/String;)Lorg/jibx/runtime/impl/MarshallingContext;");
            }
        } else {
            this.genMarshalElementsCode(marshalBuilder);
        }
    }

    protected MarshalBuilder genMarshalMethod() throws JiBXException {
        String string = this.m_parent.getBindingRoot().getPrefix() + MARSHAL_SUFFIX + this.m_variantSuffix;
        ClassFile classFile = this.m_class.getClassFile();
        MarshalBuilder marshalBuilder = new MarshalBuilder(string, classFile);
        String string2 = "(" + classFile.getSignature() + ")V";
        if (this.m_preGetMethod != null) {
            marshalBuilder.loadObject();
            marshalBuilder.appendCallVirtual(classFile.getMethod(this.m_preGetMethod, "()V"));
        }
        this.genMarshalCode(marshalBuilder);
        marshalBuilder.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        return marshalBuilder;
    }

    protected MarshalBuilder genAttMarshalMethod() throws JiBXException {
        String string = this.m_parent.getBindingRoot().getPrefix() + ATTMARSHAL_SUFFIX + this.m_variantSuffix;
        ClassFile classFile = this.m_class.getClassFile();
        MarshalBuilder marshalBuilder = new MarshalBuilder(string, classFile);
        String string2 = "(" + classFile.getSignature() + ")V";
        this.genMarshalAttributesCode(marshalBuilder);
        marshalBuilder.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        return marshalBuilder;
    }

    protected void genUnmarshalAttributesCode(UnmarshalBuilder unmarshalBuilder) throws JiBXException {
        int n = 0;
        while (n < this.m_attributes.size()) {
            IAttribute iAttribute = (IAttribute)this.m_attributes.get(n);
            iAttribute.genAttributeUnmarshal(unmarshalBuilder);
            ++n;
        }
    }

    protected void genUnmarshalElementsCode(UnmarshalBuilder unmarshalBuilder) throws JiBXException {
        int n = 0;
        while (n < this.m_elements.size()) {
            IElement iElement = (IElement)this.m_elements.get(n);
            iElement.genElementUnmarshal(unmarshalBuilder);
            ++n;
        }
    }

    protected void genUnmarshalCode(UnmarshalBuilder unmarshalBuilder) throws JiBXException {
        if (this.m_name != null) {
            unmarshalBuilder.loadContext();
            this.m_name.genPushUriPair(unmarshalBuilder);
            if (this.m_attributes.size() > 0) {
                unmarshalBuilder.appendCallVirtual(UNMARSHAL_PARSESTARTATTRIBUTES, "(Ljava/lang/String;Ljava/lang/String;)V");
                this.genUnmarshalAttributesCode(unmarshalBuilder);
                unmarshalBuilder.loadContext();
                this.m_name.genPushUriPair(unmarshalBuilder);
                unmarshalBuilder.appendCallVirtual("org.jibx.runtime.impl.UnmarshallingContext.parsePastStartTag", "(Ljava/lang/String;Ljava/lang/String;)V");
            } else {
                unmarshalBuilder.appendCallVirtual("org.jibx.runtime.impl.UnmarshallingContext.parsePastStartTag", "(Ljava/lang/String;Ljava/lang/String;)V");
            }
            this.genUnmarshalElementsCode(unmarshalBuilder);
            unmarshalBuilder.loadContext();
            this.m_name.genPushUriPair(unmarshalBuilder);
            unmarshalBuilder.appendCallVirtual(UNMARSHAL_PARSEENDMETHOD, "(Ljava/lang/String;Ljava/lang/String;)V");
        } else {
            this.genUnmarshalElementsCode(unmarshalBuilder);
        }
    }

    protected UnmarshalBuilder genAttUnmarshalMethod() throws JiBXException {
        String string = this.m_parent.getBindingRoot().getPrefix() + ATTUNMARSHAL_SUFFIX + this.m_variantSuffix;
        ClassFile classFile = this.m_class.getClassFile();
        UnmarshalBuilder unmarshalBuilder = new UnmarshalBuilder(string, classFile);
        String string2 = "(" + classFile.getSignature() + ")V";
        if (this.m_factory == null) {
            unmarshalBuilder.appendCreateNew(classFile.getName());
            unmarshalBuilder.append((Instruction)InstructionConstants.DUP);
            unmarshalBuilder.appendCallInit(classFile.getName(), "()V");
            unmarshalBuilder.setObject();
            if (this.m_preSetMethod != null) {
                unmarshalBuilder.append((Instruction)InstructionConstants.DUP);
                unmarshalBuilder.appendCallVirtual(this.m_preSetMethod, string2);
            }
        } else {
            unmarshalBuilder.appendCallStatic(this.m_factory, "()" + classFile.getSignature());
        }
        this.genUnmarshalAttributesCode(unmarshalBuilder);
        unmarshalBuilder.loadObject();
        unmarshalBuilder.append((Instruction)InstructionConstants.ARETURN);
        return unmarshalBuilder;
    }

    protected UnmarshalBuilder genUnmarshalMethod() throws JiBXException {
        String string = this.m_parent.getBindingRoot().getPrefix() + UNMARSHAL_SUFFIX + this.m_variantSuffix;
        ClassFile classFile = this.m_class.getClassFile();
        UnmarshalBuilder unmarshalBuilder = new UnmarshalBuilder(string, classFile);
        if (this.m_factory == null) {
            unmarshalBuilder.appendCreateNew(classFile.getName());
            unmarshalBuilder.append((Instruction)InstructionConstants.DUP);
            unmarshalBuilder.appendCallInit(classFile.getName(), "()V");
            unmarshalBuilder.setObject();
            if (this.m_preSetMethod != null) {
                unmarshalBuilder.loadObject();
                unmarshalBuilder.appendCallVirtual(classFile.getMethod(this.m_preSetMethod, "()V"));
            }
        } else {
            unmarshalBuilder.appendCallStatic(this.m_factory, "()" + classFile.getSignature());
        }
        this.genUnmarshalCode(unmarshalBuilder);
        if (this.m_postSetMethod != null) {
            unmarshalBuilder.loadObject();
            unmarshalBuilder.appendCallVirtual(classFile.getMethod(this.m_postSetMethod, "()V"));
        }
        unmarshalBuilder.loadObject();
        unmarshalBuilder.append((Instruction)InstructionConstants.ARETURN);
        return unmarshalBuilder;
    }

    protected MethodBuilder genIsAtMethod() throws JiBXException {
        if (this.m_name == null || this.m_unmarshaller != null) {
            return null;
        }
        String string = this.m_parent.getBindingRoot().getPrefix() + ISAT_SUFFIX + this.m_variantSuffix;
        ExceptionMethodBuilder exceptionMethodBuilder = new ExceptionMethodBuilder(string, ISAT_SIGNATURE, this.m_class.getClassFile(), 9);
        exceptionMethodBuilder.append((Instruction)InstructionConstants.ALOAD_0);
        this.m_name.genPushUriPair(exceptionMethodBuilder);
        exceptionMethodBuilder.appendCallVirtual(UNMARSHAL_ISATMETHOD, UNMARSHAL_ISATSIGNATURE);
        exceptionMethodBuilder.append((Instruction)InstructionFactory.createReturn((Type)Type.BOOLEAN));
        return exceptionMethodBuilder;
    }

    protected MethodBuilder genIMarshallableMethod() throws JiBXException {
        if (this.m_name == null || this.m_marshaller != null) {
            return null;
        }
        ClassFile classFile = this.m_class.getClassFile();
        ExceptionMethodBuilder exceptionMethodBuilder = new ExceptionMethodBuilder(MARSHALLABLE_METHODNAME, "(Lorg/jibx/runtime/impl/MarshallingContext;)V", classFile, 1);
        exceptionMethodBuilder.addException(JIBX_EXCEPTION);
        exceptionMethodBuilder.append((Instruction)InstructionConstants.ALOAD_1);
        int n = this.m_parent.getBindingRoot().getMappedClassIndex(classFile.getName());
        exceptionMethodBuilder.appendLoadConstant(n);
        exceptionMethodBuilder.appendLoadConstant(classFile.getName());
        exceptionMethodBuilder.appendCallVirtual(GETMARSHALLER_METHOD, GETMARSHALLER_SIGNATURE);
        exceptionMethodBuilder.append((Instruction)InstructionConstants.ALOAD_0);
        exceptionMethodBuilder.append((Instruction)InstructionConstants.ALOAD_1);
        exceptionMethodBuilder.appendCallInterface(MARSHALLERMARSHAL_METHOD, MARSHALLERMARSHAL_SIGNATURE);
        exceptionMethodBuilder.append((Instruction)InstructionConstants.RETURN);
        return exceptionMethodBuilder;
    }

    public void addBindingMethods() throws JiBXException {
        MethodBuilder methodBuilder;
        MarshalUnmarshalBuilder marshalUnmarshalBuilder;
        BindingDefinition bindingDefinition = this.m_parent.getBindingRoot();
        if (bindingDefinition.isInput() && this.m_unmarshaller == null) {
            marshalUnmarshalBuilder = this.genUnmarshalMethod();
            this.m_unmarshalMethod = this.m_class.getUniqueMethod(marshalUnmarshalBuilder).getItem();
            if (this.m_name != null) {
                methodBuilder = this.genIsAtMethod();
                this.m_isAtMethod = this.m_class.getUniqueMethod(methodBuilder).getItem();
            }
        }
        if (bindingDefinition.isOutput() && this.m_marshaller == null) {
            marshalUnmarshalBuilder = this.genMarshalMethod();
            this.m_marshalMethod = this.m_class.getUniqueMethod(marshalUnmarshalBuilder).getItem();
            if (this.m_name != null) {
                methodBuilder = this.genIMarshallableMethod();
                this.m_class.getUniqueMethod(methodBuilder);
                this.m_class.getClassFile().addInterface(IMARSHALLABLE_INTERFACE);
            }
        }
    }

    protected boolean hasNamespace() {
        return false;
    }

    protected void genLoadNamespaces(MethodBuilder methodBuilder) throws JiBXException {
    }

    public ClassItem getUnmarshalMethod() throws JiBXException {
        if (this.m_unmarshalMethod == null) {
            UnmarshalBuilder unmarshalBuilder = this.genUnmarshalMethod();
            this.m_unmarshalMethod = this.m_class.getUniqueMethod(unmarshalBuilder).getItem();
        }
        return this.m_unmarshalMethod;
    }

    public ClassItem getUnmarshalAttributes() throws JiBXException {
        if (this.m_unmarshalAttributes == null) {
            UnmarshalBuilder unmarshalBuilder = this.genAttUnmarshalMethod();
            this.m_unmarshalAttributes = this.m_class.getUniqueMethod(unmarshalBuilder).getItem();
        }
        return this.m_unmarshalAttributes;
    }

    public ClassItem getIsAtMethod() throws JiBXException {
        if (this.m_isAtMethod == null) {
            MethodBuilder methodBuilder = this.genIsAtMethod();
            this.m_isAtMethod = this.m_class.getUniqueMethod(methodBuilder).getItem();
        }
        return this.m_isAtMethod;
    }

    public ClassItem getMarshalMethod() throws JiBXException {
        if (this.m_marshalMethod == null) {
            MarshalBuilder marshalBuilder = this.genMarshalMethod();
            this.m_marshalMethod = this.m_class.getUniqueMethod(marshalBuilder).getItem();
        }
        return this.m_marshalMethod;
    }

    public ClassItem getMarshalAttributes() throws JiBXException {
        if (this.m_marshalAttributes == null) {
            MarshalBuilder marshalBuilder = this.genAttMarshalMethod();
            this.m_marshalAttributes = this.m_class.getUniqueMethod(marshalBuilder).getItem();
        }
        return this.m_marshalAttributes;
    }

    public boolean hasAttribute() {
        return this.m_name == null && this.m_attributes.size() > 0;
    }

    public boolean hasElement() {
        return this.m_name != null || this.m_elements.size() > 0;
    }

    public void unmarshalStartTagAttributes(UnmarshallingContext unmarshallingContext) throws JiBXException {
        String string;
        if (NameDefinition.isNamePresent(unmarshallingContext)) {
            this.m_name = new NameDefinition(false);
            this.m_name.unmarshal(unmarshallingContext);
        }
        if (ACCESS_PRIVATE.equals(string = unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "access-level", ACCESS_PRIVATE))) {
            this.m_useAccess = 0;
        } else if (ACCESS_PACKAGE.equals(string)) {
            this.m_useAccess = 1;
        } else if (ACCESS_PROTECTED.equals(string)) {
            this.m_useAccess = 2;
        } else if (ACCESS_PUBLIC.equals(string)) {
            this.m_useAccess = 3;
        } else {
            unmarshallingContext.throwStartTagException("Illegal value for \"access-level\" attribute");
        }
        Boolean bl = BindingDefinition.checkStyleAttribute(unmarshallingContext);
        if (bl != null) {
            this.m_isAsAttributes = bl;
        }
        this.m_factory = unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "factory", null);
        this.m_preSetMethod = unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "pre-set", null);
        this.m_postSetMethod = unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "post-set", null);
        this.m_preGetMethod = unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "pre-get", null);
        String string2 = unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "marshaller", null);
        if (string2 != null) {
            this.m_marshaller = ClassCache.getInstance().getClass(string2, false);
        }
        if ((string2 = unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "unmarshaller", null)) != null) {
            this.m_unmarshaller = ClassCache.getInstance().getClass(string2, false);
        }
    }

    protected void unmarshalChildDefinitions(UnmarshallingContext unmarshallingContext) throws JiBXException {
        while (true) {
            BindingConstants bindingConstants;
            if (unmarshallingContext.isAt(BindingConstants.URI_ELEMENTS, "value")) {
                bindingConstants = new ValueDefinition(this);
            } else {
                if (!unmarshallingContext.isAt(BindingConstants.URI_ELEMENTS, "structure")) break;
                bindingConstants = new StructureDefinition(this);
            }
            bindingConstants.unmarshal(unmarshallingContext);
            if (bindingConstants.hasAttribute()) {
                this.m_attributes.add(bindingConstants);
            }
            if (!bindingConstants.hasElement()) continue;
            this.m_elements.add(bindingConstants);
        }
    }

    public abstract void unmarshal(UnmarshallingContext var1) throws JiBXException;

    public void setLinkages() throws JiBXException {
        int n = 0;
        while (n < this.m_elements.size()) {
            ((IChildValue)this.m_elements.get(n)).setLinkages();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.m_attributes.size()) {
            IChildValue iChildValue = (IChildValue)this.m_attributes.get(n2);
            if (!iChildValue.hasElement()) {
                iChildValue.setLinkages();
            }
            ++n2;
        }
    }
}

