/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.apache.bcel.generic.InstructionConstants;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.def.BindingConstants;
import org.jibx.binding.def.DefinitionContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.UnmarshallingContext;

public class NameDefinition
implements BindingConstants {
    protected String m_name;
    protected String m_namespace;
    protected int m_namespaceIndex;
    protected boolean m_isAttribute;

    public NameDefinition(boolean bl) {
        this.m_isAttribute = bl;
    }

    public boolean isNullUri() {
        return this.m_namespace == null;
    }

    public void genPushUri(MethodBuilder methodBuilder) throws JiBXException {
        if (this.m_namespace == null) {
            methodBuilder.append(InstructionConstants.ACONST_NULL);
        } else {
            methodBuilder.appendLoadConstant(this.m_namespace);
        }
    }

    public void genPushName(MethodBuilder methodBuilder) throws JiBXException {
        methodBuilder.appendLoadConstant(this.m_name);
    }

    public void genPushUriPair(MethodBuilder methodBuilder) throws JiBXException {
        this.genPushUri(methodBuilder);
        this.genPushName(methodBuilder);
    }

    public void genPushIndexPair(MethodBuilder methodBuilder) throws JiBXException {
        methodBuilder.appendLoadConstant(this.m_namespaceIndex);
        this.genPushName(methodBuilder);
    }

    public void fixNamespace(DefinitionContext definitionContext) throws JiBXException {
        if (this.m_namespace == null) {
            this.m_namespace = definitionContext.getDefaultURI(this.m_isAttribute);
            this.m_namespaceIndex = definitionContext.getDefaultIndex(this.m_isAttribute);
        } else {
            try {
                this.m_namespaceIndex = definitionContext.getNamespaceIndex(this.m_namespace, this.m_isAttribute);
            }
            catch (JiBXException jiBXException) {
                throw new JiBXException("Undefined or unusable namespace \"" + this.m_namespace + '\"');
            }
        }
    }

    public void unmarshal(UnmarshallingContext unmarshallingContext) throws JiBXException {
        this.m_name = unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "name");
        this.m_namespace = unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "ns", null);
    }

    public static boolean isNamePresent(UnmarshallingContext unmarshallingContext) throws JiBXException {
        return unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "name", null) != null;
    }
}

