/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.binding.classes.MarshalBuilder;
import org.jibx.binding.classes.MarshalUnmarshalBuilder;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.classes.UnmarshalBuilder;
import org.jibx.binding.def.BindingConstants;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.DefinitionContext;
import org.jibx.binding.def.IChildValue;
import org.jibx.binding.def.IParent;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.ObjectMapping;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.UnmarshallingContext;

public class MappingDefinition
extends ObjectMapping
implements BindingConstants {
    protected static final String ACCESSCLASS_SUFFIX = "Access";
    protected static final String UNMARSHALLER_INTERFACE = "org.jibx.runtime.IUnmarshaller";
    protected static final String MARSHALLER_INTERFACE = "org.jibx.runtime.IMarshaller";
    protected static final String EXCEPTION_CONSTRUCTOR_SIGNATURE = "(Ljava/lang/String;Ljava/lang/Exception;)V";
    protected static final String[] UNMARSHALLER_INTERFACES = new String[]{"org.jibx.runtime.IUnmarshaller"};
    protected static final String[] MARSHALLER_INTERFACES = new String[]{"org.jibx.runtime.IMarshaller"};
    protected static final String[] BOTH_INTERFACES = new String[]{"org.jibx.runtime.IUnmarshaller", "org.jibx.runtime.IMarshaller"};
    protected static final Type[] UNMARSHAL_METHOD_ARGS = new Type[]{new ObjectType("org.jibx.runtime.impl.UnmarshallingContext")};
    protected static final Type[] MARSHAL_METHOD_ARGS = new Type[]{Type.OBJECT, new ObjectType("org.jibx.runtime.impl.MarshallingContext")};
    protected static final String FRAMEWORK_EXCEPTION_CLASS = "org.jibx.runtime.JiBXException";
    protected static final String ISAT_METHODNAME = "isAt";
    protected static final String UNMARSHAL_METHODNAME = "unmarshal";
    protected static final String MARSHAL_METHODNAME = "marshal";
    protected int m_classIndex;
    protected ClassFile m_adaptorClass;

    public MappingDefinition(IParent iParent) {
        super(iParent);
    }

    public String getClassName() {
        return this.m_class.getClassFile().getName();
    }

    public String getPackage() {
        return this.m_class.getClassFile().getPackage();
    }

    public NameDefinition getName() {
        return this.m_name;
    }

    public ClassFile getMarshaller() {
        if (this.m_marshaller != null) {
            return this.m_marshaller;
        }
        return this.m_adaptorClass;
    }

    public ClassFile getUnmarshaller() {
        if (this.m_unmarshaller != null) {
            return this.m_unmarshaller;
        }
        return this.m_adaptorClass;
    }

    public boolean setIdChild(IChildValue iChildValue) {
        if (this.m_idChild == null) {
            this.m_idChild = iChildValue;
            if (this.m_name == null) {
                return this.m_parent.setIdChild(this);
            }
            return true;
        }
        return false;
    }

    public void genAttributeUnmarshal(UnmarshalBuilder unmarshalBuilder) throws JiBXException {
        this.genUnmarshalAttributesCode(unmarshalBuilder);
    }

    public void genAttributeMarshal(MarshalBuilder marshalBuilder) throws JiBXException {
        this.genMarshalAttributesCode(marshalBuilder);
    }

    public void genElementUnmarshal(UnmarshalBuilder unmarshalBuilder) throws JiBXException {
        this.genUnmarshalCode(unmarshalBuilder);
    }

    public void genElementMarshal(MarshalBuilder marshalBuilder) throws JiBXException {
        this.genMarshalCode(marshalBuilder);
    }

    public void genLoadId(MarshalUnmarshalBuilder marshalUnmarshalBuilder) throws JiBXException {
        this.m_idChild.genLoadId(marshalUnmarshalBuilder);
    }

    protected boolean hasNamespace() {
        return this.m_defContext.hasNamespace(this.m_parent == this.m_parent.getBindingRoot());
    }

    protected void genLoadNamespaces(MethodBuilder methodBuilder) throws JiBXException {
        this.m_defContext.genLoadNamespaces(methodBuilder, this.m_parent == this.m_parent.getBindingRoot());
    }

    public void generateCode() throws JiBXException {
        boolean bl;
        this.m_defContext.generateCode();
        this.addBindingMethods();
        BindingDefinition bindingDefinition = this.m_parent.getBindingRoot();
        boolean bl2 = bindingDefinition.isInput() && this.m_unmarshaller == null;
        boolean bl3 = bl = bindingDefinition.isOutput() && this.m_marshaller == null;
        if (this.m_name != null && (bl2 || bl)) {
            ClassFile classFile = this.m_class.getClassFile();
            String string = "";
            String string2 = classFile.getName();
            int n = string2.lastIndexOf(46);
            if (n >= 0) {
                string = string2.substring(0, n + 1);
                string2 = string2.substring(n + 1);
            }
            String string3 = string + bindingDefinition.getPrefix() + string2 + ACCESSCLASS_SUFFIX + this.m_variantSuffix;
            String[] stringArray = bl2 && bl ? BOTH_INTERFACES : (bl2 ? UNMARSHALLER_INTERFACES : MARSHALLER_INTERFACES);
            ClassFile classFile2 = ClassCache.getInstance().getClass("java.lang.Object", false);
            ClassFile classFile3 = new ClassFile(string3, classFile.getRoot(), classFile2, stringArray);
            ExceptionMethodBuilder exceptionMethodBuilder = new ExceptionMethodBuilder("<init>", (Type)Type.VOID, new Type[0], classFile3, 1);
            exceptionMethodBuilder.append((Instruction)InstructionConstants.ALOAD_0);
            exceptionMethodBuilder.appendCallInit("java.lang.Object", "()V");
            exceptionMethodBuilder.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
            exceptionMethodBuilder.codeComplete();
            exceptionMethodBuilder.addMethod();
            if (bl2) {
                exceptionMethodBuilder = new ExceptionMethodBuilder(ISAT_METHODNAME, (Type)Type.BOOLEAN, UNMARSHAL_METHOD_ARGS, classFile3, 1);
                exceptionMethodBuilder.addException(FRAMEWORK_EXCEPTION_CLASS);
                exceptionMethodBuilder.append((Instruction)InstructionConstants.ALOAD_1);
                exceptionMethodBuilder.appendCallStatic(this.getIsAtMethod());
                exceptionMethodBuilder.append((Instruction)InstructionFactory.createReturn((Type)Type.BOOLEAN));
                exceptionMethodBuilder.codeComplete();
                exceptionMethodBuilder.addMethod();
                exceptionMethodBuilder = new ExceptionMethodBuilder(UNMARSHAL_METHODNAME, (Type)Type.OBJECT, UNMARSHAL_METHOD_ARGS, classFile3, 1);
                exceptionMethodBuilder.addException(FRAMEWORK_EXCEPTION_CLASS);
                exceptionMethodBuilder.append((Instruction)InstructionConstants.ALOAD_1);
                exceptionMethodBuilder.appendCallStatic(this.getUnmarshalMethod());
                exceptionMethodBuilder.append((Instruction)InstructionFactory.createReturn((Type)Type.OBJECT));
                exceptionMethodBuilder.codeComplete();
                exceptionMethodBuilder.addMethod();
            }
            if (bl) {
                exceptionMethodBuilder = new ExceptionMethodBuilder(MARSHAL_METHODNAME, (Type)Type.VOID, MARSHAL_METHOD_ARGS, classFile3, 1);
                exceptionMethodBuilder.addException(FRAMEWORK_EXCEPTION_CLASS);
                exceptionMethodBuilder.append((Instruction)InstructionConstants.ALOAD_1);
                exceptionMethodBuilder.appendCreateCast(classFile.getName());
                exceptionMethodBuilder.append((Instruction)InstructionConstants.ALOAD_2);
                exceptionMethodBuilder.appendCallVirtual(this.getMarshalMethod());
                exceptionMethodBuilder.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
                exceptionMethodBuilder.codeComplete();
                exceptionMethodBuilder.addMethod();
            }
            this.m_adaptorClass = this.getBoundClass().getUniqueSupportClass(classFile3);
        }
    }

    public void unmarshal(UnmarshallingContext unmarshallingContext) throws JiBXException {
        super.unmarshalStartTagAttributes(unmarshallingContext);
        this.setClass(unmarshallingContext.attributeText(BindingConstants.URI_ATTRIBUTES, "class"));
        unmarshallingContext.parsePastStartTag(BindingConstants.URI_ELEMENTS, "mapping");
        if (this.m_name == null) {
            this.m_defContext = new DefinitionContext(this, this.m_parent.getDefinitionContext(), false);
        } else {
            this.m_defContext = new DefinitionContext(this, this.m_parent.getDefinitionContext(), true);
            BindingDefinition bindingDefinition = this.m_parent.getBindingRoot();
            this.m_classIndex = bindingDefinition.getMappedClassIndex(this.m_class.getClassFile().getName());
        }
        this.m_defContext.unmarshal(unmarshallingContext);
        if (this.m_name != null) {
            this.m_name.fixNamespace(this.m_defContext);
        }
        super.unmarshalChildDefinitions(unmarshallingContext);
        unmarshallingContext.parsePastEndTag(BindingConstants.URI_ELEMENTS, "mapping");
    }

    public void setLinkages() throws JiBXException {
        this.m_defContext.setLinkages();
        super.setLinkages();
    }
}

