/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.BindingMethod;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.binding.classes.ExistingMethod;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.runtime.JiBXException;

public class BoundClass {
    protected static final String ACCESS_PREFIX = "JiBX_access_";
    protected static final Type[] EMPTY_TYPE_ARGS = new Type[0];
    protected static final ClassFile[] EMPTY_CLASSFILE_ARRAY = new ClassFile[0];
    protected static final String BINDING_LISTNAME = "JiBX_bindingList";
    protected static final String[] EXTRA_METHODS_MATCHES = new String[]{"marshal", "(Lorg/jibx/runtime/impl/MarshallingContext;)V"};
    protected static ArrayList s_classes = new ArrayList();
    protected static HashMap s_classMap = new HashMap();
    protected static HashMap s_directories = new HashMap();
    protected static HashMap s_nameMap = new HashMap();
    protected ClassFile m_classFile;
    protected String m_variantText;
    protected HashMap m_methodMap;
    protected ExistingMethod[] m_existingMethods;
    protected HashMap m_loadMap;
    protected HashMap m_storeMap;
    protected int[] m_mappingCounts;
    protected String m_factoryList;

    private BoundClass(ClassFile classFile, int n) {
        this.m_classFile = classFile;
        this.m_variantText = "_" + n;
        this.m_methodMap = new HashMap();
        this.m_mappingCounts = new int[4];
        ExistingMethod[] existingMethodArray = classFile.getBindingMethods("JiBX_", EXTRA_METHODS_MATCHES);
        if (existingMethodArray != null) {
            int n2 = 0;
            while (n2 < existingMethodArray.length) {
                this.m_methodMap.put(existingMethodArray[n2], existingMethodArray[n2]);
                ++n2;
            }
        }
        this.m_existingMethods = existingMethodArray;
    }

    public ClassFile getClassFile() {
        return this.m_classFile;
    }

    public void addFactory(String string) {
        this.m_factoryList = this.m_factoryList == null ? "|" + string + "|" : this.m_factoryList + string + "|";
    }

    public void purgeUnusedMethods() throws JiBXException {
        if (this.m_existingMethods != null) {
            int n = 0;
            while (n < this.m_existingMethods.length) {
                ExistingMethod existingMethod = this.m_existingMethods[n];
                if (!existingMethod.isUsed()) {
                    existingMethod.delete();
                }
                ++n;
            }
        }
    }

    public void setFactoryList() throws JiBXException {
        if (this.m_factoryList != null) {
            int n = 25;
            this.m_classFile.updateField("java.lang.String", BINDING_LISTNAME, n, this.m_factoryList);
        }
    }

    public BindingMethod getUniqueMethod(MethodBuilder methodBuilder) throws JiBXException {
        if (methodBuilder.getClassFile() != this.m_classFile) {
            throw new IllegalStateException("Wrong class for call");
        }
        methodBuilder.codeComplete();
        BindingMethod bindingMethod = (BindingMethod)this.m_methodMap.get(methodBuilder);
        if (bindingMethod == null) {
            methodBuilder.addMethod();
            this.m_methodMap.put(methodBuilder, methodBuilder);
            return methodBuilder;
        }
        if (bindingMethod instanceof ExistingMethod) {
            ((ExistingMethod)bindingMethod).setUsed();
        }
        return bindingMethod;
    }

    public ClassItem getLoadMethod(ClassItem classItem, ClassFile classFile) throws JiBXException {
        BindingMethod bindingMethod;
        if (this.m_loadMap == null) {
            this.m_loadMap = new HashMap();
        }
        if ((bindingMethod = (BindingMethod)this.m_loadMap.get(classItem)) == null) {
            String string = "JiBX_access_load_" + classItem.getName();
            ClassFile classFile2 = classItem.getClassFile();
            Type type = Type.getType((String)Utility.getSignature((String)classItem.getTypeName()));
            ExceptionMethodBuilder exceptionMethodBuilder = new ExceptionMethodBuilder(string, type, EMPTY_TYPE_ARGS, classFile2, 0);
            exceptionMethodBuilder.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
            if (classItem.isMethod()) {
                exceptionMethodBuilder.addMethodExceptions(classItem);
                exceptionMethodBuilder.appendCallVirtual(classItem);
            } else {
                exceptionMethodBuilder.appendGetField(classItem);
            }
            exceptionMethodBuilder.append((Instruction)InstructionFactory.createReturn((Type)type));
            bindingMethod = this.getUniqueMethod(exceptionMethodBuilder);
            this.m_loadMap.put(classItem, bindingMethod);
        }
        bindingMethod.makeAccessible(classFile);
        return bindingMethod.getItem();
    }

    public ClassItem getStoreMethod(ClassItem classItem, ClassFile classFile) throws JiBXException {
        BindingMethod bindingMethod;
        if (this.m_storeMap == null) {
            this.m_storeMap = new HashMap();
        }
        if ((bindingMethod = (BindingMethod)this.m_loadMap.get(classItem)) == null) {
            Type type;
            Object object;
            String string = "JiBX_access_store_" + classItem.getName();
            ClassFile classFile2 = classItem.getClassFile();
            if (classItem.isMethod()) {
                object = classItem.getSignature();
                int n = ((String)object).indexOf(40);
                int n2 = ((String)object).indexOf(41);
                type = Type.getType((String)((String)object).substring(n + 1, n2));
            } else {
                type = Type.getType((String)Utility.getSignature((String)classItem.getTypeName()));
            }
            object = new ExceptionMethodBuilder(string, type, EMPTY_TYPE_ARGS, classFile2, 0);
            ((MethodBuilder)object).append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
            ((MethodBuilder)object).append((Instruction)InstructionFactory.createLoad((Type)type, (int)1));
            if (classItem.isMethod()) {
                ((MethodBuilder)object).addMethodExceptions(classItem);
                ((MethodBuilder)object).appendCallVirtual(classItem);
            } else {
                ((MethodBuilder)object).appendPutField(classItem);
            }
            ((MethodBuilder)object).append((Instruction)InstructionConstants.RETURN);
            bindingMethod = this.getUniqueMethod((MethodBuilder)object);
            this.m_loadMap.put(classItem, bindingMethod);
        }
        bindingMethod.makeAccessible(classFile);
        return bindingMethod.getItem();
    }

    public int countBindingUse(int n) {
        if (n >= this.m_mappingCounts.length) {
            int n2 = n * 3 / 2;
            int[] nArray = this.m_mappingCounts;
            this.m_mappingCounts = new int[n2];
            System.arraycopy(nArray, 0, this.m_mappingCounts, 0, nArray.length);
        }
        int n3 = n;
        int n4 = this.m_mappingCounts[n3] + 1;
        this.m_mappingCounts[n3] = n4;
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFile getUniqueSupportClass(ClassFile classFile) throws JiBXException {
        classFile.codeComplete();
        ArrayList arrayList = s_classes;
        synchronized (arrayList) {
            Object v = s_classMap.get(classFile);
            if (v == null) {
                s_classes.add(classFile);
                s_classMap.put(classFile, classFile);
                return classFile;
            }
            ClassFile classFile2 = (ClassFile)v;
            classFile2.incrementUseCount();
            return classFile2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkDirectory(File file, String string) throws JiBXException {
        ArrayList arrayList = s_classes;
        synchronized (arrayList) {
            try {
                File file2 = new File(file, string.replace('.', File.separatorChar));
                String string2 = file2.getCanonicalPath();
                if (s_directories.get(string2) == null) {
                    File[] fileArray = new File(string2).listFiles(new JiBXFilter());
                    int n = 0;
                    while (n < fileArray.length) {
                        File file3 = fileArray[n];
                        String string3 = file3.getName();
                        int n2 = string3.indexOf(46);
                        if (n2 >= 0) {
                            string3 = string3.substring(0, n2);
                        }
                        ClassFile classFile = ClassCache.getInstance().getClass(string + '.' + string3, true);
                        s_classes.add(classFile);
                        s_classMap.put(classFile, classFile);
                        ++n;
                    }
                    s_directories.put(string2, string2);
                }
            }
            catch (IOException iOException) {
                throw new JiBXException("Error loading class file", (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassFile getUniqueStandaloneClass(ClassFile classFile) throws JiBXException {
        classFile.codeComplete();
        ArrayList arrayList = s_classes;
        synchronized (arrayList) {
            Object v = s_classMap.get(classFile);
            if (v == null) {
                s_classes.add(classFile);
                s_classMap.put(classFile, classFile);
                return classFile;
            }
            ClassFile classFile2 = (ClassFile)v;
            classFile2.incrementUseCount();
            return classFile2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BoundClass getInstance(String string) throws JiBXException {
        ArrayList arrayList = s_classes;
        synchronized (arrayList) {
            BoundClass boundClass = (BoundClass)s_nameMap.get(string);
            if (boundClass == null) {
                ClassFile classFile = ClassCache.getInstance().getClass(string, true);
                boundClass = new BoundClass(classFile, s_nameMap.size());
                s_nameMap.put(string, boundClass);
                if (s_classMap.get(classFile) != null) {
                    throw new IllegalStateException("Existing class conflicts with load");
                }
                s_classes.add(boundClass);
                s_classMap.put(classFile, classFile);
                String string2 = classFile.getPackage();
                BoundClass.checkDirectory(classFile.getRoot(), string2);
            }
            boundClass.m_classFile.incrementUseCount();
            return boundClass;
        }
    }

    public static ClassFile[][] writeFiles() throws JiBXException {
        HashMap hashMap = s_nameMap;
        synchronized (hashMap) {
            try {
                Object object;
                ArrayList<ClassFile> arrayList = new ArrayList<ClassFile>();
                ArrayList<ClassFile> arrayList2 = new ArrayList<ClassFile>();
                ArrayList<ClassFile> arrayList3 = new ArrayList<ClassFile>();
                int n = 0;
                while (n < s_classes.size()) {
                    ClassFile classFile;
                    object = s_classes.get(n);
                    if (object instanceof BoundClass) {
                        BoundClass boundClass = (BoundClass)object;
                        boundClass.purgeUnusedMethods();
                        boundClass.setFactoryList();
                        classFile = boundClass.getClassFile();
                    } else {
                        classFile = (ClassFile)object;
                    }
                    if (classFile.isModified()) {
                        classFile.writeFile();
                        arrayList.add(classFile);
                    } else if (classFile.getUseCount() > 0) {
                        arrayList2.add(classFile);
                    } else {
                        classFile.delete();
                        arrayList3.add(classFile);
                    }
                    ++n;
                }
                object = new ClassFile[][]{arrayList.toArray(EMPTY_CLASSFILE_ARRAY), arrayList2.toArray(EMPTY_CLASSFILE_ARRAY), arrayList3.toArray(EMPTY_CLASSFILE_ARRAY)};
                return object;
            }
            catch (IOException iOException) {
                throw new JiBXException("Error writing to file", (Throwable)iOException);
            }
        }
    }

    protected static class JiBXFilter
    implements FileFilter {
        protected JiBXFilter() {
        }

        public boolean accept(File file) {
            String string = file.getName();
            return string.startsWith("JiBX_") && string.endsWith(".class");
        }
    }
}

