/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.ClassPath;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ExistingMethod;
import org.jibx.binding.classes.InstructionBuilder;
import org.jibx.runtime.JiBXException;

public class ClassFile {
    protected static final int PRIVATEFIELD_ACCESS = 2;
    protected static final int PUBLICCLASS_ACCESS = 1;
    protected static final ExistingMethod[] EMPTY_METHOD_ARRAY = new ExistingMethod[0];
    protected static final ClassPath s_loader = new ClassPath();
    protected String m_name;
    protected String m_signature;
    protected Type m_type;
    protected File m_root;
    protected File m_file;
    protected boolean m_isSamePackage;
    protected boolean m_isWritable;
    protected ClassFile m_superClass;
    protected String[] m_interfaces;
    protected String[] m_instanceOfs;
    protected JavaClass m_curClass;
    protected ClassGen m_genClass;
    protected ConstantPoolGen m_genPool;
    protected InstructionBuilder m_instBuilder;
    protected HashMap m_itemMap;
    protected boolean m_isModified;
    protected int m_useCount;
    protected boolean m_isHashCurrent;
    protected int m_hashCode;

    public ClassFile(String string, String string2, InputStream inputStream) throws JiBXException {
        this.init(string, string2, inputStream);
    }

    public ClassFile(String string, File file, File file2) throws IOException, JiBXException {
        this.init(string, file.getPath(), new FileInputStream(file2));
        this.m_root = file;
        this.m_file = file2;
        this.m_isWritable = file2.canWrite();
    }

    public ClassFile(String string) throws IOException, JiBXException {
        ClassPath.ClassFile classFile = s_loader.getClassFile(string);
        if (classFile == null) {
            throw new JiBXException("Class " + string + " not found in classpath");
        }
        this.init(string, classFile.getPath(), classFile.getInputStream());
    }

    public ClassFile(String string, File file, ClassFile classFile, String[] stringArray) throws JiBXException {
        String string2 = string.replace('.', File.separatorChar) + ".class";
        File file2 = new File(file, string2);
        this.m_name = string;
        this.m_signature = Utility.getSignature((String)string);
        this.m_type = new ObjectType(string);
        this.m_root = file;
        this.m_superClass = classFile;
        this.m_interfaces = stringArray;
        this.m_file = file2;
        this.m_isWritable = true;
        this.m_genClass = new ClassGen(string, classFile.getName(), "", 1, stringArray);
        this.m_genPool = this.m_genClass.getConstantPool();
        this.m_instBuilder = new InstructionBuilder(this.m_genClass, this.m_genPool);
        this.m_itemMap = new HashMap();
    }

    private void init(String string, String string2, InputStream inputStream) throws JiBXException {
        this.m_name = string;
        this.m_signature = Utility.getSignature((String)string);
        this.m_type = new ObjectType(string);
        this.m_itemMap = new HashMap();
        String string3 = string.replace('.', File.separatorChar) + ".class";
        ClassParser classParser = new ClassParser(inputStream, string3);
        try {
            this.m_curClass = classParser.parse();
            this.m_interfaces = this.m_curClass.getInterfaceNames();
        }
        catch (Exception exception) {
            throw new JiBXException("Error reading path " + string2 + " for class " + string);
        }
    }

    public boolean isModifiable() {
        return this.m_isWritable;
    }

    public String getName() {
        return this.m_name;
    }

    public String getSignature() {
        return this.m_signature;
    }

    public Type getType() {
        return this.m_type;
    }

    public String getPackage() {
        int n = this.m_name.lastIndexOf(46);
        if (n >= 0) {
            return this.m_name.substring(0, n);
        }
        return "";
    }

    public File getRoot() {
        return this.m_root;
    }

    public File getFile() {
        return this.m_file;
    }

    public String getSuperName() {
        return this.m_curClass.getSuperclassName();
    }

    public void setSuperFile(ClassFile classFile) {
        this.m_superClass = classFile;
        this.m_isSamePackage = this.getPackage().equals(classFile.getPackage());
    }

    public ClassFile getSuperFile() {
        return this.m_superClass;
    }

    public String[] getInterfaces() {
        return this.m_interfaces;
    }

    public boolean addInterface(String string) throws JiBXException {
        ClassGen classGen = this.getClassGen();
        String[] stringArray = classGen.getInterfaceNames();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return false;
            }
            ++n;
        }
        classGen.addInterface(string);
        this.m_isModified = true;
        return true;
    }

    protected void accumulateInterfaces(String[] stringArray, HashMap hashMap, ArrayList arrayList) throws JiBXException {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (hashMap.get(string) == null) {
                ClassFile classFile = ClassCache.getInstance().getClass(string, false);
                String string2 = classFile.getSignature();
                hashMap.put(string, string2);
                arrayList.add(string2);
                String[] stringArray2 = classFile.m_curClass.getInterfaceNames();
                this.accumulateInterfaces(stringArray2, hashMap, arrayList);
            }
            ++n;
        }
    }

    public String[] getInstanceSigs() throws JiBXException {
        if (this.m_instanceOfs == null) {
            String[] stringArray;
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            ClassFile classFile = this;
            while (classFile != null) {
                stringArray = classFile.getSignature();
                hashMap.put(classFile.getName(), stringArray);
                arrayList.add(stringArray);
                this.accumulateInterfaces(classFile.getInterfaces(), hashMap, arrayList);
                classFile = classFile.getSuperFile();
            }
            stringArray = new String[arrayList.size()];
            this.m_instanceOfs = arrayList.toArray(stringArray);
        }
        return this.m_instanceOfs;
    }

    public boolean isImplements(String string) throws JiBXException {
        String[] stringArray = this.getInstanceSigs();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isSuperclass(String string) throws JiBXException {
        ClassFile classFile = this;
        while (classFile != null) {
            if (classFile.getName().equals(string)) {
                return true;
            }
            classFile = classFile.getSuperFile();
        }
        return false;
    }

    protected Field getDefinedField(String string) {
        Field[] fieldArray = this.m_curClass.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            if (fieldArray[n].getName().equals(string)) {
                return fieldArray[n];
            }
            ++n;
        }
        return null;
    }

    protected Field getAccessibleField(String string) {
        Field field = this.getDefinedField(string);
        if (!(field != null || this.m_superClass == null || (field = this.m_superClass.getAccessibleField(string)) == null || this.m_isSamePackage && !field.isPrivate() || field.isPublic() || field.isProtected())) {
            field = null;
        }
        return field;
    }

    public ClassItem getDirectField(String string) throws JiBXException {
        Field field = this.getAccessibleField(string);
        if (field == null) {
            return null;
        }
        ClassItem classItem = (ClassItem)this.m_itemMap.get(field);
        if (classItem == null) {
            classItem = new ClassItem(string, this, (FieldOrMethod)field);
            this.m_itemMap.put(field, classItem);
        }
        return classItem;
    }

    public ClassItem getField(String string) throws JiBXException {
        Field field = this.getAccessibleField(string);
        if (field == null) {
            throw new JiBXException("Field " + string + " not found in class " + this.m_name);
        }
        ClassItem classItem = (ClassItem)this.m_itemMap.get(field);
        if (classItem == null) {
            classItem = new ClassItem(string, this, (FieldOrMethod)field);
            this.m_itemMap.put(field, classItem);
        }
        return classItem;
    }

    protected Method getAccessibleMethod(String string, String string2) {
        Method method;
        Method[] methodArray = this.m_curClass.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            method = methodArray[n];
            if (method.getName().equals(string) && method.getSignature().startsWith(string2)) {
                return method;
            }
            ++n;
        }
        if (this.m_superClass != null && (method = this.m_superClass.getAccessibleMethod(string, string2)) != null && (this.m_isSamePackage && !method.isPrivate() || method.isPublic() || method.isProtected())) {
            return method;
        }
        return null;
    }

    public ClassItem getMethod(String string, String string2) throws JiBXException {
        Method method = this.getAccessibleMethod(string, string2);
        if (method == null) {
            throw new JiBXException("Method " + string + " not found in class " + this.m_name);
        }
        ClassItem classItem = (ClassItem)this.m_itemMap.get(method);
        if (classItem == null) {
            classItem = new ClassItem(string, this, (FieldOrMethod)method);
            this.m_itemMap.put(method, classItem);
        }
        return classItem;
    }

    public ClassItem getInitializerMethod(String string) {
        Method[] methodArray = this.m_curClass.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            if (method.getName().equals("<init>") && method.getSignature().startsWith(string)) {
                ClassItem classItem = (ClassItem)this.m_itemMap.get(method);
                if (classItem == null) {
                    classItem = new ClassItem("<init>", this, (FieldOrMethod)method);
                    this.m_itemMap.put(method, classItem);
                }
                return classItem;
            }
            ++n;
        }
        return null;
    }

    public ClassItem getStaticMethod(String string, String string2) {
        Method[] methodArray = this.m_curClass.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            if (method.getName().equals(string) && method.isStatic() && method.getSignature().startsWith(string2)) {
                ClassItem classItem = (ClassItem)this.m_itemMap.get(method);
                if (classItem == null) {
                    classItem = new ClassItem(string, this, (FieldOrMethod)method);
                    this.m_itemMap.put(method, classItem);
                }
                return classItem;
            }
            ++n;
        }
        return null;
    }

    public ExistingMethod[] getBindingMethods(String string, String[] stringArray) {
        ExistingMethod[] existingMethodArray;
        Method[] methodArray = this.m_curClass.getMethods();
        int n = 0;
        int n2 = 0;
        while (n2 < methodArray.length) {
            existingMethodArray = methodArray[n2];
            String string2 = existingMethodArray.getName();
            if (string2.startsWith(string)) {
                ++n;
            } else {
                String string3 = existingMethodArray.getSignature();
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (string2.equals(stringArray[n3]) && string3.equals(stringArray[n3 + 1])) {
                        ++n;
                        break;
                    }
                    n3 += 2;
                }
            }
            ++n2;
        }
        if (n == 0) {
            return EMPTY_METHOD_ARRAY;
        }
        existingMethodArray = new ExistingMethod[n];
        int n4 = 0;
        int n5 = 0;
        while (n5 < methodArray.length) {
            Object object;
            Method method = methodArray[n5];
            String string4 = method.getName();
            boolean bl = string4.startsWith(string);
            if (!bl) {
                object = method.getSignature();
                int n6 = 0;
                while (n6 < stringArray.length) {
                    if (string4.equals(stringArray[n6]) && ((String)object).equals(stringArray[n6 + 1])) {
                        bl = true;
                        break;
                    }
                    n6 += 2;
                }
            }
            if (bl) {
                object = (ClassItem)this.m_itemMap.get(method);
                if (object == null) {
                    object = new ClassItem(string4, this, (FieldOrMethod)method);
                    this.m_itemMap.put(method, object);
                }
                existingMethodArray[n4++] = new ExistingMethod(method, (ClassItem)object, this);
            }
            ++n5;
        }
        return existingMethodArray;
    }

    public boolean isAccessible(ClassItem classItem) {
        if (classItem.getClassFile() == this) {
            return true;
        }
        int n = classItem.getAccessFlags();
        if ((n & 1) != 0) {
            return true;
        }
        if ((n & 2) != 0) {
            return false;
        }
        if (this.getPackage().equals(classItem.getClassFile().getPackage())) {
            return true;
        }
        if ((n & 4) != 0) {
            ClassFile classFile = classItem.getClassFile();
            ClassFile classFile2 = this;
            while ((classFile2 = classFile2.getSuperFile()) != null) {
                if (classFile2 != classFile) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public ClassGen getClassGen() throws JiBXException {
        if (this.m_genClass == null) {
            if (this.m_isWritable) {
                this.m_genClass = new ClassGen(this.m_curClass);
                this.m_genPool = this.m_genClass.getConstantPool();
                this.m_instBuilder = new InstructionBuilder(this.m_genClass, this.m_genPool);
                this.m_isHashCurrent = false;
            } else {
                throw new JiBXException("Cannot modify class " + this.m_name);
            }
        }
        return this.m_genClass;
    }

    public ConstantPoolGen getConstPoolGen() throws JiBXException {
        if (this.m_genPool == null) {
            this.getClassGen();
        }
        return this.m_genPool;
    }

    public InstructionBuilder getInstructionBuilder() throws JiBXException {
        if (this.m_instBuilder == null) {
            this.getClassGen();
        }
        return this.m_instBuilder;
    }

    public ClassItem addField(String string, String string2, int n, String string3) throws JiBXException {
        this.deleteField(string2);
        FieldGen fieldGen = new FieldGen(n, Type.getType((String)Utility.getSignature((String)string)), string2, this.getConstPoolGen());
        fieldGen.setInitValue(string3);
        Field field = fieldGen.getField();
        this.getClassGen().addField(field);
        this.m_isModified = true;
        this.m_isHashCurrent = false;
        return new ClassItem(string2, this, (FieldOrMethod)field);
    }

    public ClassItem updateField(String string, String string2, int n, String string3) throws JiBXException {
        String string4;
        Field field;
        Field[] fieldArray = this.m_curClass.getFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            ConstantValue constantValue;
            field = fieldArray[n2];
            if (field.getName().equals(string2) && field.getAccessFlags() == n && string.equals(Utility.signatureToString((String)(string4 = field.getSignature()), (boolean)false)) && (constantValue = field.getConstantValue()) != null) {
                Object object;
                int n3 = constantValue.getConstantValueIndex();
                ConstantPool constantPool = this.m_curClass.getConstantPool();
                Constant constant = constantPool.getConstant(n3);
                if (constant instanceof ConstantString && string3.equals(object = ((ConstantString)constant).getConstantValue(constantPool))) {
                    return new ClassItem(string2, this, (FieldOrMethod)field);
                }
            }
            ++n2;
        }
        this.deleteField(string2);
        field = new FieldGen(n, Type.getType((String)Utility.getSignature((String)string)), string2, this.getConstPoolGen());
        field.setInitValue(string3);
        string4 = field.getField();
        this.getClassGen().addField((Field)string4);
        this.m_isModified = true;
        this.m_isHashCurrent = false;
        return new ClassItem(string2, this, (FieldOrMethod)string4);
    }

    public ClassItem addField(String string, String string2, int n) throws JiBXException {
        this.deleteField(string2);
        FieldGen fieldGen = new FieldGen(n, Type.getType((String)Utility.getSignature((String)string)), string2, this.getConstPoolGen());
        Field field = fieldGen.getField();
        this.getClassGen().addField(field);
        this.m_isModified = true;
        this.m_isHashCurrent = false;
        return new ClassItem(string2, this, (FieldOrMethod)field);
    }

    public ClassItem addPrivateField(String string, String string2) throws JiBXException {
        return this.addField(string, string2, 2);
    }

    public boolean deleteField(String string) throws JiBXException {
        ClassGen classGen = this.getClassGen();
        Field field = classGen.containsField(string);
        if (field == null) {
            return false;
        }
        classGen.removeField(field);
        this.m_isModified = true;
        this.m_isHashCurrent = false;
        return true;
    }

    public int getUseCount() {
        return this.m_useCount;
    }

    public int incrementUseCount() {
        return ++this.m_useCount;
    }

    public boolean isModified() {
        return this.m_isModified;
    }

    public void setModified() {
        this.m_isModified = true;
    }

    protected int computeHashCode() {
        int n = this.getPackage().hashCode();
        ClassFile classFile = this.getSuperFile();
        if (classFile != null) {
            n += classFile.getName().hashCode();
        }
        String[] stringArray = this.getInterfaces();
        int n2 = 0;
        while (n2 < stringArray.length) {
            n += stringArray[n2].hashCode();
            ++n2;
        }
        n += this.m_curClass.getAccessFlags();
        Field[] fieldArray = this.m_curClass.getFields();
        int n3 = 0;
        while (n3 < fieldArray.length) {
            n = n * 49 + fieldArray[n3].getName().hashCode();
            ++n3;
        }
        Method[] methodArray = this.m_curClass.getMethods();
        int n4 = 0;
        while (n4 < methodArray.length) {
            n = n * 49 + methodArray[n4].getName().hashCode();
            ++n4;
        }
        Constant[] constantArray = this.m_curClass.getConstantPool().getConstantPool();
        int n5 = this.m_curClass.getClassNameIndex() + 1;
        while (n5 < constantArray.length) {
            Constant constant = constantArray[n5];
            if (constant != null) {
                int n6 = 0;
                switch (constant.getTag()) {
                    case 6: {
                        n6 = (int)Double.doubleToRawLongBits(((ConstantDouble)constant).getBytes());
                        break;
                    }
                    case 4: {
                        n6 = Float.floatToRawIntBits(((ConstantFloat)constant).getBytes());
                        break;
                    }
                    case 3: {
                        n6 = ((ConstantInteger)constant).getBytes();
                        break;
                    }
                    case 5: {
                        n6 = (int)((ConstantLong)constant).getBytes();
                        break;
                    }
                    case 1: {
                        String string = ((ConstantUtf8)constant).getBytes();
                        if (string.equals(this.m_signature)) break;
                        n6 = string.hashCode();
                        break;
                    }
                }
                n = n * 49 + n6;
            }
            ++n5;
        }
        return n;
    }

    public void codeComplete() {
        if (this.m_genClass != null) {
            this.m_curClass = this.m_genClass.getJavaClass();
            this.m_genClass = null;
        }
    }

    public int hashCode() {
        if (!this.m_isHashCurrent) {
            if (this.m_genClass != null) {
                throw new IllegalStateException("Class still being constructed");
            }
            this.m_hashCode = this.computeHashCode();
            this.m_isHashCurrent = true;
        }
        return this.m_hashCode;
    }

    public static boolean equalFieldOrMethods(FieldOrMethod fieldOrMethod, FieldOrMethod fieldOrMethod2) {
        return fieldOrMethod.getName().equals(fieldOrMethod2.getName()) && fieldOrMethod.getSignature().equals(fieldOrMethod2.getSignature());
    }

    public static boolean equalMethods(Method method, Method method2) {
        CodeException[] codeExceptionArray;
        Code code;
        Code code2;
        ExceptionTable exceptionTable = method.getExceptionTable();
        ExceptionTable exceptionTable2 = method2.getExceptionTable();
        if (exceptionTable != null && exceptionTable2 != null ? !Arrays.equals((Object[])(code2 = exceptionTable.getExceptionNames()), (Object[])(code = exceptionTable2.getExceptionNames())) : exceptionTable != null || exceptionTable2 != null) {
            return false;
        }
        code2 = method.getCode();
        code = method2.getCode();
        CodeException[] codeExceptionArray2 = code2.getExceptionTable();
        if (codeExceptionArray2.length == (codeExceptionArray = code.getExceptionTable()).length) {
            int n = 0;
            while (n < codeExceptionArray2.length) {
                CodeException codeException = codeExceptionArray2[n];
                CodeException codeException2 = codeExceptionArray[n];
                if (codeException.getCatchType() != codeException2.getCatchType() || codeException.getStartPC() != codeException2.getStartPC() || codeException.getEndPC() != codeException2.getEndPC() || codeException.getHandlerPC() != codeException2.getHandlerPC()) {
                    return false;
                }
                ++n;
            }
        }
        return Arrays.equals(code2.getCode(), code.getCode());
    }

    public boolean equals(Object object) {
        if (object instanceof ClassFile && object.hashCode() == this.hashCode()) {
            Method method;
            Method method2;
            Method[] methodArray;
            Field[] fieldArray;
            ClassFile classFile = (ClassFile)object;
            if (!org.jibx.runtime.Utility.isEqual((Object)this.getPackage(), (Object)classFile.getPackage()) || this.getSuperFile() != classFile.getSuperFile() || !Arrays.equals(this.getInterfaces(), classFile.getInterfaces())) {
                return false;
            }
            JavaClass javaClass = this.m_curClass;
            JavaClass javaClass2 = classFile.m_curClass;
            if (javaClass.getAccessFlags() != javaClass2.getAccessFlags()) {
                return false;
            }
            Field[] fieldArray2 = javaClass.getFields();
            if (fieldArray2.length != (fieldArray = javaClass2.getFields()).length) {
                return false;
            }
            int n = 0;
            while (n < fieldArray2.length) {
                if (!ClassFile.equalFieldOrMethods((FieldOrMethod)fieldArray2[n], (FieldOrMethod)fieldArray[n])) {
                    return false;
                }
                ++n;
            }
            Method[] methodArray2 = javaClass.getMethods();
            if (methodArray2.length != (methodArray = javaClass2.getMethods()).length) {
                return false;
            }
            int n2 = 0;
            while (n2 < methodArray2.length) {
                method2 = methodArray2[n2];
                method = methodArray[n2];
                if (!ClassFile.equalFieldOrMethods((FieldOrMethod)method2, (FieldOrMethod)method) || !ClassFile.equalMethods(method2, method)) {
                    return false;
                }
                ++n2;
            }
            method2 = javaClass.getConstantPool().getConstantPool();
            if (((Method)method2).length != ((Method)(method = javaClass2.getConstantPool().getConstantPool())).length) {
                return false;
            }
            int n3 = javaClass.getClassNameIndex() + 1;
            while (n3 < ((Method)method2).length) {
                Method method3 = method2[n3];
                Method method4 = method[n3];
                if (method3 != null && method4 != null) {
                    byte by = method3.getTag();
                    if (by != method4.getTag()) {
                        return false;
                    }
                    boolean bl = true;
                    switch (by) {
                        case 6: {
                            bl = ((ConstantDouble)method3).getBytes() == ((ConstantDouble)method4).getBytes();
                            break;
                        }
                        case 4: {
                            bl = ((ConstantFloat)method3).getBytes() == ((ConstantFloat)method4).getBytes();
                            break;
                        }
                        case 3: {
                            bl = ((ConstantInteger)method3).getBytes() == ((ConstantInteger)method4).getBytes();
                            break;
                        }
                        case 5: {
                            bl = ((ConstantLong)method3).getBytes() == ((ConstantLong)method4).getBytes();
                            break;
                        }
                        case 1: {
                            String string = ((ConstantUtf8)method3).getBytes();
                            String string2 = ((ConstantUtf8)method4).getBytes();
                            if (string.equals(this.m_signature)) {
                                bl = string2.equals(classFile.m_signature);
                                break;
                            }
                            bl = string.equals(string2);
                            break;
                        }
                    }
                    if (!bl) {
                        return false;
                    }
                } else if (method3 != null || method4 != null) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    public void delete() throws IOException {
        if (this.m_file.exists()) {
            this.m_file.delete();
        }
    }

    public void writeFile(OutputStream outputStream) throws IOException {
        this.codeComplete();
        this.m_curClass.dump(outputStream);
        outputStream.close();
    }

    public void writeFile() throws IOException {
        if (this.m_isModified) {
            FileOutputStream fileOutputStream = new FileOutputStream(this.m_file);
            this.writeFile(fileOutputStream);
        }
    }
}

