/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.jibx.binding.classes.ClassFile;
import org.jibx.runtime.JiBXException;

public class ClassCache {
    protected static ClassCache s_instance;
    protected String[] m_paths;
    protected File[] m_roots;
    protected HashMap m_classMap;

    private ClassCache(String[] stringArray) {
        this.m_paths = new String[stringArray.length];
        this.m_roots = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            int n2 = string.length();
            if (n2 > 0 && string.charAt(n2 - 1) != File.separatorChar) {
                string = string + File.separator;
            }
            this.m_paths[n] = string;
            this.m_roots[n] = new File(string);
            ++n;
        }
        this.m_classMap = new HashMap();
    }

    public ClassFile getClass(String string, boolean bl) throws JiBXException {
        Object v = this.m_classMap.get(string);
        if (v != null) {
            if (bl && !((ClassFile)v).isModifiable()) {
                throw new JiBXException("Can't write class file for class " + string);
            }
            return (ClassFile)v;
        }
        try {
            Object object;
            ClassFile classFile = null;
            String string2 = string.replace('.', File.separatorChar) + ".class";
            int n = 0;
            while (n < this.m_paths.length) {
                object = new File(this.m_paths[n], string2);
                if (((File)object).exists()) {
                    classFile = new ClassFile(string, this.m_roots[n], (File)object);
                    if (!bl || classFile.isModifiable()) break;
                    throw new JiBXException("Can't write class file " + ((File)object).getPath() + " for class " + string);
                }
                ++n;
            }
            if (classFile == null && !bl) {
                classFile = new ClassFile(string);
            }
            if (classFile == null) {
                throw new JiBXException("Can't find class file for class " + string);
            }
            object = classFile.getSuperName();
            if (!string.equals(object)) {
                classFile.setSuperFile(this.getClass((String)object, false));
            }
            this.m_classMap.put(string, classFile);
            return classFile;
        }
        catch (IOException iOException) {
            throw new JiBXException("Unable to load class " + string);
        }
    }

    public static ClassCache getInstance() {
        return s_instance;
    }

    public static void setPaths(String[] stringArray) {
        s_instance = new ClassCache(stringArray);
    }
}

