/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.framework;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import jp.gr.java_conf.ktz.puzzle.framework.RenderEvent;
import jp.gr.java_conf.ktz.puzzle.framework.RenderListener;
import jp.gr.java_conf.ktz.puzzle.framework.Renderer;
import jp.gr.java_conf.ktz.puzzle.framework.State;

public final class DefaultRenderer
implements Renderer {
    private static final int DEFAULT_PIECE_SIZE = 24;
    private static Map sTable;
    private BufferedImage mDoubleBuffer;
    private Graphics mGraphics;
    private int mPieceUnit = 24;
    private Dimension mPieceSize = new Dimension(this.mPieceUnit, this.mPieceUnit);
    private RenderEvent mEvent = new RenderEvent();
    private RenderListener mDefaultListener = new RenderListener(){

        public void render(RenderEvent inEvent) {
            Rectangle aBounds = inEvent.getBounds();
            DefaultRenderer.this.mGraphics.setColor(Color.white);
            DefaultRenderer.this.mGraphics.fillRect(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
        }
    };

    public DefaultRenderer() {
    }

    public DefaultRenderer(int inWidth, int inHeight) {
        this.setSize(inWidth, inHeight);
    }

    public void render(int inX, int inY, State inState) {
        if (null == this.mGraphics) {
            throw new IllegalStateException("The Graphics object is not initialized. \nCalling DefaultRenderer.setSize(...) method, lead to initialize the graphics object. ");
        }
        Rectangle aBounds = new Rectangle(inX * this.mPieceUnit, inY * this.mPieceUnit, this.mPieceUnit, this.mPieceUnit);
        this.mEvent.reset(this, this.mGraphics, aBounds, inState);
        this.mDefaultListener.render(this.mEvent);
        this.lookup(inState).render(this.mEvent);
    }

    public RenderListener lookup(State inState) {
        if (sTable.containsKey(inState.getClass())) {
            return (RenderListener)sTable.get(inState.getClass());
        }
        return this.mDefaultListener;
    }

    public void addRenderListener(Class inClass, RenderListener inListenr) {
        sTable.put(inClass, inListenr);
    }

    public void setDefaultRenderListener(RenderListener inListenr) {
        this.mDefaultListener = inListenr;
    }

    public void setSize(int inWidth, int inHeight) {
        if (null == this.mDoubleBuffer || inWidth * this.mPieceUnit + 1 != this.mDoubleBuffer.getWidth() || inHeight * this.mPieceUnit + 1 != this.mDoubleBuffer.getHeight()) {
            this.mDoubleBuffer = new BufferedImage(inWidth * this.mPieceUnit + 1, inHeight * this.mPieceUnit + 1, 1);
            this.mGraphics = this.mDoubleBuffer.getGraphics();
        }
    }

    public Dimension getBoardSize() {
        return new Dimension(this.mDoubleBuffer.getWidth(), this.mDoubleBuffer.getHeight());
    }

    public void setPieceSize(Dimension inSize) {
        if (inSize.width != inSize.height) {
            throw new IllegalArgumentException("inSize.width != inSize.height");
        }
        this.mPieceUnit = inSize.width;
        this.mPieceSize.setSize(this.mPieceUnit, this.mPieceUnit);
    }

    public Dimension getPieceSize() {
        return this.mPieceSize;
    }

    public Point calcPortToBoardPos(int inX, int inY) {
        return new Point((int)Math.floor((double)inX / (double)this.mPieceUnit), (int)Math.floor((double)inY / (double)this.mPieceUnit));
    }

    public Image getImage() {
        return this.mDoubleBuffer;
    }

    public Rectangle getClipBounds(Point[] inPos) {
        Area aArea = new Area();
        Rectangle aBounds = new Rectangle();
        int i = 0;
        while (i < inPos.length) {
            aBounds.setBounds(inPos[i].x * this.mPieceUnit, inPos[i].y * this.mPieceUnit, this.mPieceUnit, this.mPieceUnit);
            aArea.add(new Area(aBounds));
            ++i;
        }
        return aArea.getBounds();
    }

    static {
        DEFAULT_PIECE_SIZE = 24;
        sTable = new HashMap();
    }
}

