/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ComponentUsher;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ProblemUnmarshalable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.SaveCanceledException;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.Usherable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.GUIUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.TerminateManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;

public abstract class RootBoardContainer
implements BoardView,
Usherable,
ProblemUnmarshalable {
    private static String sInitialTitle = "<untitled>";
    protected BoardView mDecorated;
    private Frame mComponent;
    private boolean mFocused;

    protected RootBoardContainer(Frame inComponent) {
        this.mComponent = inComponent;
    }

    public final void initialize() {
        this.initializeSelf();
        this.throwIfUninitialized();
        this.mDecorated.initialize();
        this.mComponent.pack();
    }

    protected abstract void initializeSelf();

    protected final void addBoard(BoardView inSubBoard) {
        this.mComponent.add(inSubBoard.getComponent());
        this.mDecorated = inSubBoard;
        inSubBoard.setParent(this);
    }

    public void setParent(BoardView inParent) {
        throw new UnsupportedOperationException("The Parent of root board is no existance.");
    }

    public final void createBoard(int inWidth, int inHeight) {
        this.throwIfUninitialized();
        this.mDecorated.createBoard(inWidth, inHeight);
    }

    public final int getBoardWidth() {
        this.throwIfUninitialized();
        return this.mDecorated.getBoardWidth();
    }

    public final int getBoardHeight() {
        this.throwIfUninitialized();
        return this.mDecorated.getBoardHeight();
    }

    public final boolean isModified() {
        this.throwIfUninitialized();
        return this.mDecorated.isModified();
    }

    public final void save(File inFile) throws SaveCanceledException {
        if (inFile.getName().equals(sInitialTitle)) {
            this.saveAs();
            this.repaint();
        } else {
            this.throwIfUninitialized();
            this.mDecorated.save(inFile);
        }
    }

    public final void saveAs() throws SaveCanceledException {
        JFileChooser aChooser = GUIUtility.createFileChooser();
        int aSignal = aChooser.showSaveDialog(this.mComponent);
        if (aSignal == 1) {
            throw new SaveCanceledException("The save operation is canceled.");
        }
        if (aSignal == 0) {
            this.mDecorated.save(aChooser.getSelectedFile());
        }
    }

    public final void load(ProblemInfo inInfo) {
        this.throwIfUninitialized();
        this.mDecorated.load(inInfo);
    }

    public final void loadProblem(File inFile, ProblemInfo inInfo) {
        if (this != ComponentUsher.getInstance().getActiveComponent()) {
            ComponentUsher.getInstance().setActiveComponent(this);
        }
        this.setTitle(inFile.getAbsolutePath());
        this.load(inInfo);
    }

    public final void clear() {
        this.throwIfUninitialized();
        this.mDecorated.clear();
    }

    public final Component getComponent() {
        return this.mComponent;
    }

    public final void setTitle(String inTitle) {
        this.mComponent.setTitle(this.modifiyTitleString(inTitle));
    }

    protected abstract String modifiyTitleString(String var1);

    public final String getTitle() {
        return this.mComponent.getTitle();
    }

    public final void repaint() {
        this.throwIfUninitialized();
        this.mDecorated.repaint();
    }

    public final void setPieceSize(int inSize) {
    }

    public int getPieceSize() {
        return this.mDecorated.getPieceSize();
    }

    public final void setComponentSize(int inWidth, int inHeight) {
        this.mComponent.pack();
        Dimension aScreenSize = GUIUtility.getEffectiveScreenSize();
        int aWidth = this.mComponent.getWidth();
        int aHeight = this.mComponent.getHeight();
        if (aWidth > aScreenSize.width) {
            aWidth = aScreenSize.width;
        }
        if (aHeight > aScreenSize.height) {
            aHeight = aScreenSize.height;
        }
        if (new Dimension(aWidth, aHeight).equals(this.mComponent.getSize())) {
            return;
        }
        this.mComponent.setSize(aWidth, aHeight);
    }

    protected final void dispose() {
        this.mComponent.dispose();
    }

    public final boolean isFocused() {
        return this.mFocused;
    }

    public final void setFocus(boolean inFocused) {
        this.mFocused = inFocused;
    }

    protected final void saveCanceled() {
        TerminateManager aManager = TerminateManager.getInstance();
        if (aManager.isTerminateThread()) {
            aManager.cancel();
        }
    }

    private void throwIfUninitialized() {
        if (null == this.mDecorated) {
            throw new IllegalStateException("The subcompoment is initialized.To Call with addBoard() method lead to register it.");
        }
    }

    public void show() {
        this.mComponent.show();
    }
}

