/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.view;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.SaveCanceledException;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;

public abstract class BoardContainer
implements BoardView {
    private BoardView mParent;
    private BoardView mDecorated;
    private Container mContainer;

    public BoardContainer(Container inContainer) {
        this.mContainer = inContainer;
    }

    public final void initialize() {
        this.initializeSelf();
        this.mDecorated.initialize();
    }

    protected abstract void initializeSelf();

    public final void createBoard(int inWidth, int inHeight) {
        this.mDecorated.createBoard(inWidth, inHeight);
    }

    public final int getBoardWidth() {
        return this.mDecorated.getBoardWidth();
    }

    public final int getBoardHeight() {
        return this.mDecorated.getBoardHeight();
    }

    public final boolean isModified() {
        return this.mDecorated.isModified();
    }

    public final void save(File inFile) throws SaveCanceledException {
        this.mDecorated.save(inFile);
    }

    public final void load(ProblemInfo inInfo) {
        this.mDecorated.load(inInfo);
    }

    public final void clear() {
        this.mDecorated.clear();
    }

    public void addBoard(BoardView inSubBoard) {
        this.mContainer.add(inSubBoard.getComponent());
        this.mDecorated = inSubBoard;
        inSubBoard.setParent(this);
    }

    public void setParent(BoardView inParentBoard) {
        this.mParent = inParentBoard;
    }

    public final Component getComponent() {
        return this.mContainer;
    }

    public final void setTitle(String inTitle) {
        this.mParent.setTitle(inTitle);
    }

    public final String getTitle() {
        return this.mParent.getTitle();
    }

    public final void repaint() {
        this.mDecorated.repaint();
    }

    public final void setPieceSize(int inSize) {
        int aSize = this.setPieceSizeSelf(inSize);
        this.mParent.setPieceSize(aSize);
    }

    protected abstract int setPieceSizeSelf(int var1);

    public final int getPieceSize() {
        return this.mDecorated.getPieceSize();
    }

    public final void setComponentSize(int inWidth, int inHeight) {
        this.setComponentSizeSelf(inWidth, inHeight);
        int aWidth = this.getComponent().getWidth();
        int aHeight = this.getComponent().getHeight();
        this.mParent.setComponentSize(aWidth, aHeight);
    }

    protected abstract void setComponentSizeSelf(int var1, int var2);

    public void setFocus(boolean inFocused) {
        this.mParent.setFocus(inFocused);
    }

    public final boolean isFocused() {
        return this.mParent.isFocused();
    }
}

