/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.hashikake.io.ProblemReader;
import jp.gr.java_conf.ktz.puzzle.hashikake.io.XMLProblemReader;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ComponentUsher;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ProblemUnmarshalable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.TextUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.GUIUtility;

public class OpenProblemDialog
extends JFrame {
    private ProblemUnmarshalable mLoadOwner;
    private ProblemReader mReader = new XMLProblemReader();
    private JList mList;
    private JLabel mPathLabel;
    private File mCurPath = new File(new File("problem").getAbsolutePath());

    public static void getInstance() {
        InitHolder.sDialog.show();
    }

    void init() {
        this.setTitle("Open Problem");
        Container aPane = this.getContentPane();
        JPanel aPathPanel = new JPanel();
        aPane.add((Component)aPathPanel, "North");
        aPathPanel.setPreferredSize(new Dimension(250, 45));
        aPathPanel.setBackground(Color.white);
        JPanel aPanel = new JPanel();
        aPane.add((Component)aPanel, "Center");
        aPanel.setPreferredSize(new Dimension(250, 190));
        aPanel.setBackground(Color.white);
        this.setResizable(false);
        this.pack();
        SpringLayout aLayout = new SpringLayout();
        aPathPanel.setLayout(aLayout);
        this.mPathLabel = new JLabel(this.mCurPath.getAbsolutePath());
        this.mPathLabel.setSize(210, 35);
        this.mPathLabel.setBorder(new TitledBorder("File path"));
        aPathPanel.add((Component)this.mPathLabel, new SpringLayout.Constraints(Spring.constant(5), Spring.constant(5), Spring.constant(210), Spring.constant(35)));
        Insets aInsets = this.mPathLabel.getInsets();
        int aWidth = this.mPathLabel.getWidth() - aInsets.left - aInsets.right;
        String aText = TextUtility.truncText(this.mPathLabel.getFontMetrics(this.mPathLabel.getFont()), aWidth, this.mCurPath.getAbsolutePath(), 1);
        this.mPathLabel.setText(aText);
        JButton aChangePath = new JButton("...");
        aChangePath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent inEvent) {
                if (!OpenProblemDialog.this.mCurPath.isDirectory()) {
                    OpenProblemDialog.this.mCurPath = new File(OpenProblemDialog.this.mCurPath.getParent());
                }
                JFileChooser aChooser = new JFileChooser(OpenProblemDialog.this.mCurPath);
                aChooser.setFileFilter(new FileFilter(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public boolean accept(File inFile) {
                        if (inFile.isDirectory()) {
                            return true;
                        }
                        int aIndex = inFile.getName().toLowerCase().indexOf(".xml");
                        return 0 < aIndex;
                    }

                    public String getDescription() {
                        return "XML file (version 1.0)";
                    }
                });
                int aSel = aChooser.showOpenDialog(OpenProblemDialog.this);
                if (aSel == 0) {
                    OpenProblemDialog.this.mCurPath = aChooser.getSelectedFile();
                    Insets aInsets = OpenProblemDialog.this.mPathLabel.getInsets();
                    int aWidth = OpenProblemDialog.this.mPathLabel.getWidth() - aInsets.left - aInsets.right;
                    String aText = TextUtility.truncText(OpenProblemDialog.this.mPathLabel.getFontMetrics(OpenProblemDialog.this.mPathLabel.getFont()), aWidth, OpenProblemDialog.this.mCurPath.getAbsolutePath(), 1);
                    OpenProblemDialog.this.mPathLabel.setText(aText);
                }
            }
        });
        aPathPanel.add((Component)aChangePath, new SpringLayout.Constraints(Spring.constant(225), Spring.constant(15), Spring.constant(20), Spring.constant(20)));
        aPanel.setLayout(aLayout);
        this.mList = new JList();
        this.mList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setComponentOrientation(list.getComponentOrientation());
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                ProblemInfo aInfo = (ProblemInfo)value;
                this.setText("Q. " + (index + 1) + " (" + aInfo.getWidth() + " X " + aInfo.getHeight() + ")");
                this.setEnabled(list.isEnabled());
                this.setFont(list.getFont());
                this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : DefaultListCellRenderer.noFocusBorder);
                return this;
            }
        });
        this.mList.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent inEvent) {
                if (2 != inEvent.getClickCount()) {
                    return;
                }
                int aIndex = OpenProblemDialog.this.mList.locationToIndex(inEvent.getPoint());
                if (aIndex < 0) {
                    return;
                }
                OpenProblemDialog.this.setVisible(false);
                ProblemInfo aInfo = OpenProblemDialog.this.mReader.getProblemAt(aIndex);
                OpenProblemDialog.this.mLoadOwner.loadProblem(OpenProblemDialog.this.mCurPath, aInfo);
            }

            public void mousePressed(MouseEvent inEvent) {
            }

            public void mouseReleased(MouseEvent inEvent) {
            }

            public void mouseEntered(MouseEvent inEvent) {
            }

            public void mouseExited(MouseEvent inEvent) {
            }
        });
        aPanel.add((Component)new JScrollPane(this.mList, 22, 31), new SpringLayout.Constraints(Spring.constant(5), Spring.constant(5), Spring.constant(150), Spring.constant(180)));
        JButton aLoad = new JButton("Load");
        aLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent inEvent) {
                if (OpenProblemDialog.this.mPathLabel.getText().equals("")) {
                    return;
                }
                try {
                    OpenProblemDialog.this.mReader.load(new File(OpenProblemDialog.this.mCurPath.getAbsolutePath()));
                    ProblemInfo[] aInfos = OpenProblemDialog.this.mReader.getAllProblems();
                    OpenProblemDialog.this.mList.setListData(aInfos);
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException e) {
                    System.out.println("the specified file is not a problem file");
                    OpenProblemDialog.this.mList.setListData(new ProblemInfo[0]);
                }
            }
        });
        aPanel.add((Component)aLoad, new SpringLayout.Constraints(Spring.constant(165), Spring.constant(10), Spring.constant(75), Spring.constant(25)));
        JButton aOK = new JButton("OK");
        aOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent inEvent) {
                int aIndex = OpenProblemDialog.this.mList.getSelectedIndex();
                if (aIndex < 0) {
                    return;
                }
                OpenProblemDialog.this.setVisible(false);
                ProblemInfo aInfo = OpenProblemDialog.this.mReader.getProblemAt(aIndex);
                OpenProblemDialog.this.mLoadOwner.loadProblem(OpenProblemDialog.this.mCurPath, aInfo);
            }
        });
        aPanel.add((Component)aOK, new SpringLayout.Constraints(Spring.constant(165), Spring.constant(45), Spring.constant(75), Spring.constant(25)));
        JButton aCancel = new JButton("Cancel");
        aCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent inEvent) {
                OpenProblemDialog.this.setLoadOwner(null);
                OpenProblemDialog.this.setVisible(false);
            }
        });
        aPanel.add((Component)aCancel, new SpringLayout.Constraints(Spring.constant(165), Spring.constant(75), Spring.constant(75), Spring.constant(25)));
    }

    void toCenter() {
        GUIUtility.LayoutToCenter(this);
    }

    public void show() {
        this.setLoadOwner((ProblemUnmarshalable)((Object)ComponentUsher.getInstance().getActiveComponent()));
        this.toCenter();
        super.show();
    }

    private void setLoadOwner(ProblemUnmarshalable inLoader) {
        this.mLoadOwner = inLoader;
    }

    private OpenProblemDialog() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent inEvent) {
                OpenProblemDialog.this.setVisible(false);
            }
        });
    }

    private static class InitHolder {
        static OpenProblemDialog sDialog = new OpenProblemDialog();

        private InitHolder() {
        }

        static {
            sDialog.init();
            sDialog.toCenter();
        }
    }
}

