/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.util;

import java.util.HashMap;
import java.util.Map;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

public class HashikakeStateEventCode
implements StateEventCode {
    public static final String VERTICAL_ID = "vert";
    public static final String HORIZONTAL_ID = "horiz";
    public static final String SPACE_ID = "s";
    public static final String NS_BRIDGE_ID = "i";
    public static final String BIG_NS_BRIDGE_ID = "ii";
    public static final String WE_BRIDGE_ID = "-";
    public static final String BIG_WE_BRIDGE_ID = "=";
    public static final String NULL_ID = "";
    public static final String NO_INTERNAL_TRANSIT = "";
    private static Map aTable;
    private String mValue;

    public static StateEventCode valueOf(String inValue) {
        HashikakeStateEventCode aCode = null;
        if (!aTable.containsKey(inValue)) {
            aCode = new HashikakeStateEventCode(inValue);
            aTable.put(inValue, aCode);
        } else {
            aCode = (StateEventCode)aTable.get(inValue);
        }
        return aCode;
    }

    public static StateEventCode createSpaceCode() {
        return HashikakeStateEventCode.valueOf(SPACE_ID);
    }

    public static StateEventCode createHorizontalCode() {
        return HashikakeStateEventCode.valueOf(HORIZONTAL_ID);
    }

    public static StateEventCode createVerticalCode() {
        return HashikakeStateEventCode.valueOf(VERTICAL_ID);
    }

    public static StateEventCode createParallelCode(Direction inDirection) {
        if (Direction.NORTH == inDirection || Direction.SOUTH == inDirection) {
            return HashikakeStateEventCode.createVerticalCode();
        }
        if (Direction.EAST == inDirection || Direction.WEST == inDirection) {
            return HashikakeStateEventCode.createHorizontalCode();
        }
        return HashikakeStateEventCode.createNoTransitCode();
    }

    public static StateEventCode createNoTransitCode() {
        return HashikakeStateEventCode.valueOf("");
    }

    public String getValue() {
        return this.mValue;
    }

    private HashikakeStateEventCode(String inValue) {
        this.mValue = inValue;
    }

    static {
        VERTICAL_ID = VERTICAL_ID;
        HORIZONTAL_ID = HORIZONTAL_ID;
        SPACE_ID = SPACE_ID;
        NS_BRIDGE_ID = NS_BRIDGE_ID;
        BIG_NS_BRIDGE_ID = BIG_NS_BRIDGE_ID;
        WE_BRIDGE_ID = WE_BRIDGE_ID;
        BIG_WE_BRIDGE_ID = BIG_WE_BRIDGE_ID;
        NULL_ID = "";
        NO_INTERNAL_TRANSIT = "";
        aTable = new HashMap();
    }
}

