/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.creator.view;

import java.awt.CheckboxMenuItem;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.SizeChangeDialog;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.HashiCreatorRoot;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ComponentUsher;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.SaveCanceledException;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.Usherable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.GUIUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.OpenProblemDialog;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.TerminateManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;

class MenuManager {
    public static final String MENU_FILE = "File";
    public static final String ITEM_NEW = "New";
    public static final String ITEM_LOAD = "Load";
    public static final String ITEM_SAVE = "Save";
    public static final String ITEM_ARCHIVE = "Archive";
    public static final String ITEM_QUIT = "Quit";
    public static final String MENU_EDIT = "Edit";
    public static final String ITEM_CLEAR = "Clear";
    public static final String ITEM_RESIZE = "Resize...";
    private static final String MENU_INFO_PROPERTY = "property/menu_info.xml";
    private static Map sLookupManager;
    private static MenuDispatcher sDispatcher;
    private Map mLookupMenu = new HashMap();
    private MenuBar mMenuBar;

    MenuManager() {
    }

    public static MenuManager currentMenuManager() {
        BoardView aComp = (BoardView)((Object)ComponentUsher.getInstance().getActiveComponent());
        if (!sLookupManager.containsKey(aComp.getComponent())) {
            throw new IllegalStateException("The MenuManager for the specified frame isnot registered.\nCalling MenuManager.createMenuManager() leads to register the manager for specified the frame .");
        }
        return (MenuManager)sLookupManager.get(aComp.getComponent());
    }

    public static MenuBar createMenuManager(Frame inFrame) {
        MenuManager aManager = null;
        if (sLookupManager.containsKey(inFrame)) {
            aManager = (MenuManager)sLookupManager.get(inFrame);
        } else {
            aManager = new MenuManager();
            aManager.initialize();
            sLookupManager.put(inFrame, aManager);
        }
        return aManager.getMenuBar();
    }

    protected void initialize() {
        if (!sDispatcher.isInit()) {
            sDispatcher.initialize();
        }
        this.mMenuBar = new MenuBar();
        Menu aMenu = new Menu(MENU_FILE);
        this.mMenuBar.add(aMenu);
        this.mLookupMenu.put(MENU_FILE, aMenu);
        MenuItem aItem = new MenuItem(ITEM_NEW);
        aItem.addActionListener(sDispatcher);
        aItem.setShortcut(new MenuShortcut(78));
        aMenu.add(aItem);
        this.mLookupMenu.put(ITEM_NEW, aItem);
        aItem = new MenuItem(ITEM_LOAD);
        aItem.addActionListener(sDispatcher);
        aItem.setShortcut(new MenuShortcut(79));
        aMenu.add(aItem);
        this.mLookupMenu.put(ITEM_LOAD, aItem);
        aItem = new MenuItem(ITEM_SAVE);
        aItem.addActionListener(sDispatcher);
        aItem.setShortcut(new MenuShortcut(83));
        aItem.setEnabled(false);
        aMenu.add(aItem);
        this.mLookupMenu.put(ITEM_SAVE, aItem);
        aItem = new MenuItem(ITEM_ARCHIVE);
        aItem.addActionListener(sDispatcher);
        aMenu.add(aItem);
        this.mLookupMenu.put(ITEM_ARCHIVE, aItem);
        aItem = new MenuItem(ITEM_QUIT);
        aItem.addActionListener(sDispatcher);
        aItem.setShortcut(new MenuShortcut(81));
        aMenu.add(aItem);
        this.mLookupMenu.put(ITEM_QUIT, aItem);
        aMenu = new Menu(MENU_EDIT);
        this.mMenuBar.add(aMenu);
        this.mLookupMenu.put(MENU_EDIT, aMenu);
        aItem = new MenuItem(ITEM_CLEAR);
        aItem.addActionListener(sDispatcher);
        aMenu.add(aItem);
        this.mLookupMenu.put(ITEM_CLEAR, aItem);
        aItem = new MenuItem(ITEM_RESIZE);
        aItem.addActionListener(sDispatcher);
        aMenu.add(aItem);
        this.mLookupMenu.put(ITEM_RESIZE, aItem);
    }

    public MenuBar getMenuBar() {
        return this.mMenuBar;
    }

    public void setEnabledFor(String inMenuID, boolean inEnabled) {
        if (!this.mLookupMenu.containsKey(inMenuID)) {
            throw new IllegalArgumentException("The Menu with the specified ID is no existance.");
        }
        MenuItem aItem = (MenuItem)this.mLookupMenu.get(inMenuID);
        aItem.setEnabled(inEnabled);
    }

    public void setCheckMark(String inMenuID, boolean inChecked) {
        if (!this.mLookupMenu.containsKey(inMenuID)) {
            throw new IllegalArgumentException("The Menu with the specified ID is no existance.");
        }
        MenuItem aItem = (MenuItem)this.mLookupMenu.get(inMenuID);
        if (aItem instanceof CheckboxMenuItem) {
            ((CheckboxMenuItem)aItem).setState(inChecked);
        }
    }

    static {
        MENU_FILE = MENU_FILE;
        ITEM_NEW = ITEM_NEW;
        ITEM_LOAD = ITEM_LOAD;
        ITEM_SAVE = ITEM_SAVE;
        ITEM_ARCHIVE = ITEM_ARCHIVE;
        ITEM_QUIT = ITEM_QUIT;
        MENU_EDIT = MENU_EDIT;
        ITEM_CLEAR = ITEM_CLEAR;
        ITEM_RESIZE = ITEM_RESIZE;
        MENU_INFO_PROPERTY = MENU_INFO_PROPERTY;
        sLookupManager = new HashMap();
        sDispatcher = new MenuDispatcher();
    }

    private static class MenuDispatcher
    implements ActionListener {
        private boolean mInitialized = false;
        Map mRealListenerMap = new HashMap();

        private MenuDispatcher() {
        }

        boolean isInit() {
            return this.mInitialized;
        }

        public void actionPerformed(ActionEvent inEvent) {
            new Thread(new MenuDispatchThread(inEvent)).start();
        }

        void initialize() {
            this.mInitialized = true;
            this.mRealListenerMap.put(MenuManager.ITEM_NEW, new ActionListener(){

                public void actionPerformed(ActionEvent inEvent) {
                    HashiCreatorRoot.showRootBoard();
                }
            });
            this.mRealListenerMap.put(MenuManager.ITEM_LOAD, new ActionListener(this){
                private final /* synthetic */ MenuDispatcher this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent inEvent) {
                    BoardView aComp = (BoardView)((Object)ComponentUsher.getInstance().getActiveComponent());
                    if (aComp.isModified()) {
                        String aFileName = "<untitled>";
                        int aIndex = aComp.getTitle().lastIndexOf(" - hashicreator");
                        if (0 < aIndex) {
                            aFileName = aComp.getTitle().substring(0, aIndex);
                        }
                        int aSignal = GUIUtility.showBoardModifiedNotice(aComp.getComponent(), aFileName, false);
                        try {
                            if (aSignal == 0) {
                                aComp.save(new File(aFileName));
                            } else if (aSignal == 2) {
                                throw new SaveCanceledException("load process is canceled");
                            }
                        }
                        catch (SaveCanceledException e) {
                            aComp.repaint();
                            return;
                        }
                    }
                    OpenProblemDialog.getInstance();
                }
            });
            this.mRealListenerMap.put(MenuManager.ITEM_SAVE, new ActionListener(this){
                private final /* synthetic */ MenuDispatcher this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent inEvent) {
                    BoardView aComp = (BoardView)((Object)ComponentUsher.getInstance().getActiveComponent());
                    try {
                        String aFileName = "<untitled>";
                        int aIndex = aComp.getTitle().lastIndexOf(" - hashicreator");
                        if (0 < aIndex) {
                            aFileName = aComp.getTitle().substring(0, aIndex);
                        }
                        aComp.save(new File(aFileName));
                        MenuManager.currentMenuManager().setEnabledFor("Save", false);
                    }
                    catch (SaveCanceledException e) {
                        System.out.println(e);
                    }
                }
            });
            this.mRealListenerMap.put(MenuManager.ITEM_ARCHIVE, new ActionListener(this){
                private final /* synthetic */ MenuDispatcher this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent inEvent) {
                }
            });
            this.mRealListenerMap.put(MenuManager.ITEM_QUIT, new ActionListener(this){
                private final /* synthetic */ MenuDispatcher this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent inEvent) {
                    TerminateManager aManager = TerminateManager.getInstance();
                    aManager.start();
                    Usherable[] allFrames = ComponentUsher.getInstance().getAllComponents();
                    int i = 0;
                    while (i < allFrames.length) {
                        Frame aFrame = (Frame)((BoardView)((Object)allFrames[i])).getComponent();
                        aManager.pushEvent(new WindowEvent(aFrame, 201));
                        ++i;
                    }
                    aManager.waitTermination();
                    BoardView aComp = (BoardView)((Object)ComponentUsher.getInstance().getActiveComponent());
                    aComp.repaint();
                }
            });
            this.mRealListenerMap.put(MenuManager.ITEM_CLEAR, new ActionListener(this){
                private final /* synthetic */ MenuDispatcher this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent inEvent) {
                    System.out.println("clear : initialized board");
                    BoardView aComp = (BoardView)((Object)ComponentUsher.getInstance().getActiveComponent());
                    aComp.clear();
                }
            });
            this.mRealListenerMap.put(MenuManager.ITEM_RESIZE, new ActionListener(this){
                private final /* synthetic */ MenuDispatcher this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent inEvent) {
                    System.out.println("size changed");
                    BoardView aComp = (BoardView)((Object)ComponentUsher.getInstance().getActiveComponent());
                    int aWidth = aComp.getBoardWidth();
                    int aHeight = aComp.getBoardHeight();
                    SizeChangeDialog.showDialog(aComp, aWidth, aHeight);
                }
            });
        }

        private class MenuDispatchThread
        implements Runnable {
            private ActionEvent mEvent;

            MenuDispatchThread(ActionEvent inEvent) {
                this.mEvent = inEvent;
            }

            public void run() {
                String aCommand = ((MenuItem)this.mEvent.getSource()).getActionCommand();
                ActionListener aListener = (ActionListener)MenuDispatcher.this.mRealListenerMap.get(aCommand);
                aListener.actionPerformed(this.mEvent);
            }
        }
    }
}

