/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.creator.view;

import java.awt.Frame;
import java.awt.MenuBar;
import java.awt.ScrollPane;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.BoardScroller;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.MenuManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ComponentUsher;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.SaveCanceledException;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.GUIUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.TerminateManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.RootBoardContainer;

public class HashiCreatorRoot
extends RootBoardContainer {
    private static final int DEFAULT_BOARD_WIDTH = 9;
    private static final int DEFAULT_BOARD_HEIGHT = 9;
    static final String INITIAL_TITLE = "<untitled>";
    static final String APP_NAME = "hashicreator";

    public static void showRootBoard() {
        HashiCreatorRoot aRoot = new HashiCreatorRoot(new Frame());
        aRoot.initialize();
        aRoot.createBoard(9, 9);
        aRoot.show();
    }

    private HashiCreatorRoot(Frame inComponent) {
        super(inComponent);
    }

    protected void initializeSelf() {
        this.setTitle(INITIAL_TITLE);
        Frame aComponent = (Frame)this.getComponent();
        MenuBar aMenuBar = MenuManager.createMenuManager(aComponent);
        aComponent.setMenuBar(aMenuBar);
        WindowHandler aHandler = new WindowHandler();
        aComponent.addWindowListener(aHandler);
        ComponentUsher.getInstance().install(this);
        ScrollPane aScroller = new ScrollPane(1);
        BoardScroller aContainer = new BoardScroller(aScroller);
        this.addBoard(aContainer);
    }

    protected String modifiyTitleString(String inOldTitle) {
        return inOldTitle + " - " + APP_NAME;
    }

    static {
        DEFAULT_BOARD_WIDTH = 9;
        DEFAULT_BOARD_HEIGHT = 9;
        INITIAL_TITLE = INITIAL_TITLE;
        APP_NAME = APP_NAME;
    }

    private class WindowHandler
    implements WindowListener {
        private WindowHandler() {
        }

        public void windowClosing(WindowEvent inEvent) {
            if (HashiCreatorRoot.this.isModified()) {
                try {
                    int aSignal;
                    String aFileName = HashiCreatorRoot.INITIAL_TITLE;
                    String aTitle = HashiCreatorRoot.this.getTitle();
                    int aIndex = aTitle.lastIndexOf(" - hashicreator");
                    if (0 < aIndex) {
                        aFileName = aTitle.substring(0, aIndex);
                    }
                    if (0 == (aSignal = GUIUtility.showBoardModifiedNotice(HashiCreatorRoot.this.getComponent(), aFileName, true))) {
                        HashiCreatorRoot.this.save(new File(aFileName));
                    } else if (2 == aSignal) {
                        throw new SaveCanceledException("frame closing process is canceled");
                    }
                }
                catch (SaveCanceledException e) {
                    TerminateManager.getInstance().cancel();
                    return;
                }
            }
            ComponentUsher.getInstance().uninstall(HashiCreatorRoot.this);
            HashiCreatorRoot.super.dispose();
            if (0 == ComponentUsher.getInstance().getComponentCount()) {
                System.out.println("all frame is closed");
                System.exit(0);
            }
        }

        public void windowActivated(WindowEvent inEvent) {
            ComponentUsher.getInstance().setActiveComponent(HashiCreatorRoot.this.getComponent());
        }

        public void windowDeactivated(WindowEvent inEvent) {
            ComponentUsher.getInstance().setActiveComponent();
        }

        public void windowOpened(WindowEvent inEvent) {
        }

        public void windowClosed(WindowEvent inEvent) {
        }

        public void windowIconified(WindowEvent inEvent) {
        }

        public void windowDeiconified(WindowEvent inEvent) {
        }
    }
}

