/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.creator.view;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.Board;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.KeyScrollEvent;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardContainer;

class BoardScroller
extends BoardContainer {
    BoardScroller(Container inContainer) {
        super(inContainer);
    }

    protected void initializeSelf() {
        Board aBoard = new Board();
        this.addBoard(aBoard);
    }

    protected int setPieceSizeSelf(int inSize) {
        ScrollPane aPane = (ScrollPane)this.getComponent();
        aPane.getHAdjustable().setUnitIncrement(inSize);
        aPane.getVAdjustable().setUnitIncrement(inSize);
        return inSize;
    }

    protected void setComponentSizeSelf(int inWidth, int inHeight) {
        ScrollPane aPane = (ScrollPane)this.getComponent();
        int aHHeight = aPane.getHScrollbarHeight();
        int aVWidth = aPane.getVScrollbarWidth();
        int aWidth = inWidth + aVWidth;
        int aHeight = inHeight + aHHeight;
        Dimension aSize = new Dimension(aWidth, aHeight);
        aPane.invalidate();
        aPane.setSize(aSize);
    }

    public void processKeyScroll(KeyScrollEvent inEvent) {
        ScrollPane aPane = (ScrollPane)this.getComponent();
        Insets aInsets = aPane.getInsets();
        Rectangle aViewBounds = new Rectangle(aPane.getViewportSize());
        aViewBounds.grow(1, 1);
        if (aViewBounds.contains(inEvent.mBounds)) {
            return;
        }
        int aVUnit = aPane.getVAdjustable().getUnitIncrement();
        int aHUnit = aPane.getHAdjustable().getUnitIncrement();
        Point aDiff = inEvent.mDirection.getDifference();
        Point aPos = aPane.getScrollPosition();
        aPane.setScrollPosition(aPos.x + aDiff.x * aHUnit, aPos.y + aDiff.y * aVUnit);
        this.repaint();
    }

    private static int toAdjustmentEventType(Direction inDirection) {
        if (inDirection == Direction.EAST || inDirection == Direction.SOUTH) {
            return 1;
        }
        if (inDirection == Direction.WEST || inDirection == Direction.NORTH) {
            return 2;
        }
        return -1;
    }
}

