/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.creator.view;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import jp.gr.java_conf.ktz.puzzle.framework.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.DefaultRenderer;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.NullModel;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppColors;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.model.BoardModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.model.CellActivationModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.KeyScrollEvent;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.MenuManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.RendererFactory;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ProblemCollection;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ProblemInfoBean;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ProblemMarshalable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.SaveDiscompletedException;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;

public class Board
extends Canvas
implements BoardView,
ProblemMarshalable {
    private DefaultRenderer mRenderer;
    private Model mModel = NullModel.getInstance();
    private BoardView mParent;
    private boolean mIsModified = false;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$util$ProblemCollection;

    public void initialize() {
        this.mRenderer = RendererFactory.create();
        this.addModel((Model)new BoardModel());
        this.addModel((Model)new CellActivationModel());
        this.mModel.nextStateAt(0, 0);
        this.setBackground(AppColors.BACK_COLOR);
        this.setPieceSize(this.getPieceSize());
        FocusEvent aEvent = new FocusEvent(this, 1004);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(aEvent);
        MouseHandler aHandler = new MouseHandler(new Point(0, 0));
        this.addKeyListener(aHandler);
        this.addMouseListener(aHandler);
    }

    public void addModel(Model inModel) {
        if (inModel instanceof AbstractDecoratedModel) {
            ((AbstractDecoratedModel)inModel).addModel(this.mModel);
        }
        this.mModel = inModel;
    }

    public void createBoard(int inWidth, int inHeight) {
        if (inWidth == this.getBoardWidth() && inHeight == this.getBoardHeight()) {
            return;
        }
        this.mModel.createBoard(inWidth, inHeight);
        this.mRenderer.setSize(inWidth, inHeight);
        Dimension aSize = this.mRenderer.getBoardSize();
        this.setComponentSize(aSize.width, aSize.height);
        Point aInitialPos = new Point(0, 0);
        this.mModel.nextStateAt(aInitialPos.x, aInitialPos.y);
    }

    public int getBoardWidth() {
        return this.mModel.getWidth();
    }

    public int getBoardHeight() {
        return this.mModel.getHeight();
    }

    public Rectangle getClipBounds() {
        Insets aInsets = this.getInsets();
        Rectangle aBounds = this.mRenderer.getClipBounds(this.mModel.lastModified());
        aBounds.translate(aInsets.left, aInsets.top);
        return aBounds;
    }

    public Point calcPortToBoardPos(int inX, int inY) {
        Insets aInsets = this.getInsets();
        return this.mRenderer.calcPortToBoardPos(inX - aInsets.left, inY - aInsets.top);
    }

    public boolean isModified() {
        return this.mIsModified;
    }

    public void update(Graphics inGra) {
        this.paint(inGra);
    }

    public void paint(Graphics inGra) {
        Rectangle aBounds = new Rectangle();
        inGra.getClipBounds(aBounds);
        Insets aInsets = this.getInsets();
        aBounds.translate(-aInsets.left, -aInsets.top);
        inGra.translate(aInsets.left, aInsets.top);
        if (this.mModel.isModified()) {
            Point[] aPos = this.mModel.lastModified();
            int i = 0;
            while (i < aPos.length) {
                this.mRenderer.render(aPos[i].x, aPos[i].y, this.mModel.getCurStateAt(aPos[i].x, aPos[i].y));
                ++i;
            }
        }
        inGra.drawImage(this.mRenderer.getImage(), aBounds.x, aBounds.y, aBounds.x + aBounds.width, aBounds.y + aBounds.height, aBounds.x, aBounds.y, aBounds.x + aBounds.width, aBounds.y + aBounds.height, this);
        inGra.translate(-aInsets.left, -aInsets.top);
        this.mModel.flush();
    }

    public void save(File inOutFile) {
        File aOutFile = inOutFile;
        String aExt = ".xml";
        String aFileName = aOutFile.getAbsolutePath();
        if (aFileName.length() != aFileName.toLowerCase().lastIndexOf(aExt) + aExt.length()) {
            aOutFile = new File(aFileName + aExt);
        }
        ProblemCollection aCollection = this.createProblemCollection();
        try {
            this.saveProblem(aOutFile, aCollection);
            this.setTitle(aOutFile.getAbsolutePath());
            this.mIsModified = false;
            System.out.println("save complete");
        }
        catch (SaveDiscompletedException e) {
            System.out.println(e);
        }
    }

    private ProblemCollection createProblemCollection() {
        int aWidth = this.mModel.getWidth();
        int aHeight = this.mModel.getHeight();
        StateManager aManager = StateManager.getInstance();
        int aBufSize = aWidth * aHeight * 3;
        StringBuffer aBuf = new StringBuffer(aBufSize);
        int y = 0;
        while (y < aHeight) {
            int x = 0;
            while (x < aWidth) {
                String aStr = aManager.findIdentityOf(this.mModel.getCurStateAt(x, y));
                aBuf.append(aStr).append(',');
                ++x;
            }
            ++y;
        }
        String aProblem = aBuf.substring(0, aBuf.length() - 1);
        ProblemCollection aCollection = new ProblemCollection();
        aCollection.addProblem(new ProblemInfoBean(aWidth, aHeight, aProblem));
        return aCollection;
    }

    public void saveProblem(File inFile, ProblemCollection inCollection) throws SaveDiscompletedException {
        try {
            IBindingFactory aFactory = BindingDirectory.getFactory((Class)(class$jp$gr$java_conf$ktz$puzzle$hashikake$util$ProblemCollection == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$util$ProblemCollection = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.util.ProblemCollection")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$util$ProblemCollection));
            IMarshallingContext aContext = aFactory.createMarshallingContext();
            aContext.setIndent(4);
            aContext.marshalDocument((Object)inCollection, "utf-8", null, (OutputStream)new FileOutputStream(inFile));
        }
        catch (Exception e) {
            throw new SaveDiscompletedException("save discomplete");
        }
    }

    public void load(ProblemInfo inInfo) {
        this.createBoard(inInfo.getWidth(), inInfo.getHeight());
        this.mModel.nextStateAt(0, 0);
        this.mModel.setProblem(inInfo);
        MenuManager.currentMenuManager().setEnabledFor("Save", false);
        this.mIsModified = false;
        if (this.mModel.isModified()) {
            Rectangle aBounds = this.getClipBounds();
            this.repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
        }
    }

    public void clear() {
        this.mModel.reset();
        if (this.mModel.isModified()) {
            Rectangle aBounds = this.getClipBounds();
            this.repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
        }
    }

    public void setParent(BoardView inParentBoard) {
        this.mParent = inParentBoard;
    }

    public int getPieceSize() {
        return this.mRenderer.getPieceSize().height;
    }

    public void setPieceSize(int inSize) {
        this.mParent.setPieceSize(inSize);
    }

    public Component getComponent() {
        return this;
    }

    public void setTitle(String inTitle) {
        this.mParent.setTitle(inTitle);
    }

    public String getTitle() {
        return this.mParent.getTitle();
    }

    public Insets getInsets() {
        int aPiece = this.getPieceSize();
        return new Insets(aPiece, aPiece, 0, 0);
    }

    public void setComponentSize(int inWidth, int inHeight) {
        Insets aInsets = this.getInsets();
        int aWidth = inWidth + aInsets.left + aInsets.right;
        int aHeight = inHeight + aInsets.top + aInsets.bottom;
        this.setSize(aWidth, aHeight);
        this.mParent.setComponentSize(aWidth, aHeight);
    }

    public void setFocus(boolean inFocused) {
        this.mParent.setFocus(inFocused);
    }

    public boolean isFocused() {
        return this.mParent.isFocused();
    }

    private void enableMenu(String inMenuID, boolean inEnabled) {
        if (!this.mIsModified) {
            if (this.mModel.isModified()) {
                MenuManager.currentMenuManager().setEnabledFor(inMenuID, inEnabled);
            }
            this.mIsModified = true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MouseHandler
    implements KeyListener,
    MouseListener {
        private final Point ILLEGAL = ModelConstants.ILLEGAL_POS;
        private Point mActivePiece;

        MouseHandler(Point inInitPos) {
            this.mActivePiece = inInitPos;
        }

        public void keyPressed(KeyEvent inEvent) {
            if (0 < inEvent.getModifiers()) {
                return;
            }
            int aPressedCode = inEvent.getKeyCode();
            if (aPressedCode == 127 || aPressedCode == 8) {
                StateEventCode aCode = HashikakeStateEventCode.createSpaceCode();
                Board.this.mModel.nextStateAt(this.ILLEGAL.x, this.ILLEGAL.y, aCode);
                Board.this.enableMenu("Save", true);
            } else if (aPressedCode == 37 || aPressedCode == 39 || aPressedCode == 38 || aPressedCode == 40) {
                Direction aDirection = UtilityFuncs.resolveDirectionOf(aPressedCode);
                Point aDif = aDirection.getDifference();
                StateEventCode aCode = UtilityFuncs.getSelectionEventCode();
                Board.this.mModel.nextStateAt(aDif.x, aDif.y, aCode);
                if (Board.this.mModel.isModified()) {
                    this.mActivePiece.translate(aDif.x, aDif.y);
                    int aPieceSize = Board.this.getPieceSize();
                    Rectangle aBounds = new Rectangle(Board.this.getX() + this.mActivePiece.x * aPieceSize, Board.this.getY() + this.mActivePiece.y * aPieceSize, aPieceSize, aPieceSize);
                    KeyScrollEvent aEvent = new KeyScrollEvent(Board.this.mParent, aDirection, aBounds);
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(aEvent);
                }
            } else {
                try {
                    int aVal = Integer.parseInt(KeyEvent.getKeyText(aPressedCode));
                    if (aVal > 0 && aVal < 9) {
                        StateEventCode aCode = HashikakeStateEventCode.valueOf(String.valueOf(aVal));
                        Board.this.mModel.nextStateAt(this.ILLEGAL.x, this.ILLEGAL.y, aCode);
                        Board.this.enableMenu("Save", true);
                    }
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
            if (Board.this.mModel.isModified()) {
                Rectangle aBounds = Board.this.getClipBounds();
                Board.this.repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
            }
        }

        public void mousePressed(MouseEvent inEvent) {
            if (!Board.this.isFocused()) {
                return;
            }
            int aX = inEvent.getX();
            int aY = inEvent.getY();
            Point aPos = Board.this.calcPortToBoardPos(aX, aY);
            Board.this.mModel.nextStateAt(aPos.x, aPos.y);
            if (Board.this.mModel.isModified()) {
                this.mActivePiece = aPos;
                Rectangle aBounds = Board.this.getClipBounds();
                Board.this.repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
            }
        }

        public void keyReleased(KeyEvent inEvent) {
        }

        public void keyTyped(KeyEvent inEvent) {
        }

        public void mouseClicked(MouseEvent inEvent) {
        }

        public void mouseReleased(MouseEvent inEvent) {
        }

        public void mouseEntered(MouseEvent inEvent) {
        }

        public void mouseExited(MouseEvent inEvent) {
        }
    }
}

