/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.creator.model;

import java.awt.Dimension;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import jp.gr.java_conf.ktz.puzzle.framework.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.NullState;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;

public class BoardModel
extends AbstractDecoratedModel {
    private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private static final State NULL_STATE = new NullState();
    private Cell[] mCells;
    private int mWidth;
    private int mHeight;
    private Set mLastModified = new HashSet();

    public void createBoardSelf(int inWidth, int inHeight) {
        this.mWidth = inWidth;
        this.mHeight = inHeight;
        this.mCells = new Cell[inWidth * inHeight];
        int y = 0;
        while (y < this.mHeight) {
            int x = 0;
            while (x < this.mWidth) {
                this.mCells[this.toIndex((int)x, (int)y)] = new Cell();
                this.mLastModified.add(new Point(x, y));
                ++x;
            }
            ++y;
        }
    }

    private int toIndex(int inX, int inY) {
        return inY * this.mWidth + inX;
    }

    public void setProblem(ProblemInfo inProblem) {
        if (this.mWidth != inProblem.getWidth() || this.mHeight != inProblem.getHeight()) {
            this.createBoard(inProblem.getWidth(), inProblem.getHeight());
        }
        int y = 0;
        int i = 0;
        while (y < this.mHeight) {
            int x = 0;
            while (x < this.mWidth) {
                this.getCellAt(x, y).setCurState((String)inProblem.getRecordAt(i++));
                this.mLastModified.add(new Point(x, y));
                ++x;
            }
            ++y;
        }
    }

    public boolean check() {
        return false;
    }

    public void reset() {
        int y = 0;
        while (y < this.mHeight) {
            int x = 0;
            while (x < this.mWidth) {
                if (!this.isSpaceAt(x, y)) {
                    this.getCellAt(x, y).reset();
                    this.mLastModified.add(new Point(x, y));
                }
                ++x;
            }
            ++y;
        }
    }

    public Dimension getSize() {
        return new Dimension(this.mWidth, this.mHeight);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public State getCurStateAt(int inX, int inY) {
        return this.getCellAt(inX, inY).getCurState();
    }

    public State getCorrectStateAt(int inX, int inY) {
        return NULL_STATE;
    }

    public boolean isAcceptableEvent(StateEventCode inCode) {
        if (inCode == HashikakeStateEventCode.createSpaceCode()) {
            return true;
        }
        try {
            int aVal = Integer.parseInt(inCode.getValue());
            if (aVal > 0 && aVal < 9) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public void nextStateAt(int inX, int inY) {
    }

    public void nextStateAt(int inX, int inY, StateEventCode inCode) {
        if (!this.isAcceptableEvent(inCode)) {
            return;
        }
        if (inCode != HashikakeStateEventCode.createSpaceCode() && !this.checkSpaceForNeighborAt(inX, inY)) {
            return;
        }
        if (!this.contains(inX, inY)) {
            return;
        }
        if (!this.isTransitAt(inX, inY, inCode)) {
            return;
        }
        State aState = this.getCurStateAt(inX, inY);
        aState = StateManager.getInstance().getNextState(aState, inCode);
        this.getCellAt(inX, inY).setCurState(aState);
        this.mLastModified.add(new Point(inX, inY));
    }

    public void prevStateAt(int inX, int inY) {
    }

    public void prevStateAt(int inX, int inY, StateEventCode inCode) {
        if (!this.isAcceptableEvent(inCode)) {
            return;
        }
        if (inCode != HashikakeStateEventCode.createSpaceCode() && !this.checkSpaceForNeighborAt(inX, inY)) {
            return;
        }
        State aState = this.getCurStateAt(inX, inY);
        aState = StateManager.getInstance().getPrevState(aState, inCode);
        this.getCellAt(inX, inY).setCurState(aState);
        this.mLastModified.add(new Point(inX, inY));
    }

    private boolean checkSpaceForNeighborAt(int inX, int inY) {
        StateManager aManager = StateManager.getInstance();
        int i = 0;
        while (i < DIRECTIONS.length) {
            State aState;
            Point aPos = new Point(inX, inY);
            Point aDiff = DIRECTIONS[i].getDifference();
            aPos.translate(aDiff.x, aDiff.y);
            if (this.contains(aPos.x, aPos.y) && !aManager.isSpaceState(aState = this.getCellAt(aPos.x, aPos.y).getCurState())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Point[] lastModifiedSelf() {
        return this.mLastModified.toArray(new Point[this.mLastModified.size()]);
    }

    public boolean contains(int inX, int inY) {
        return inX < this.mWidth && inX >= 0 && inY < this.mHeight && inY >= 0;
    }

    private Cell getCellAt(int inX, int inY) {
        if (inX > this.mWidth || inX < 0 || inY > this.mHeight || inY < 0) {
            throw new IllegalArgumentException("Must be 0 <= inX < " + this.mWidth + ", 0 <= inY < " + this.mHeight + " (was inX = " + inX + ", inY = " + inY + ")");
        }
        return this.mCells[this.toIndex(inX, inY)];
    }

    public boolean isNumberAt(int inX, int inY) {
        if (!this.contains(inX, inY)) {
            return false;
        }
        return this.getCellAt(inX, inY).isNumber();
    }

    public boolean isSpaceAt(int inX, int inY) {
        if (!this.contains(inX, inY)) {
            return false;
        }
        return this.getCellAt(inX, inY).isSpace();
    }

    public boolean isTransitAt(int inX, int inY) {
        return false;
    }

    public boolean isTransitAt(int inX, int inY, StateEventCode inCode) {
        if (!this.checkSpaceForNeighborAt(inX, inY)) {
            return false;
        }
        State aState = this.getCurStateAt(inX, inY);
        return StateManager.getInstance().isTransit(aState, inCode);
    }

    protected boolean isModifiedSelf() {
        return this.mLastModified.size() > 0;
    }

    protected void flushSelf() {
        this.mLastModified = new HashSet();
    }

    private static class Cell {
        State mState;

        Cell() {
            this.reset();
        }

        void reset() {
            this.mState = StateManager.getInstance().createDefaultState();
        }

        boolean isSpace() {
            return StateManager.getInstance().isSpaceState(this.mState);
        }

        boolean isNumber() {
            return StateManager.getInstance().isNumberState(this.mState);
        }

        State getCurState() {
            return this.mState;
        }

        void setCurState(State inState) {
            this.mState = inState;
        }

        void setCurState(String inStateID) {
            this.mState = StateManager.getInstance().createStateOf(inStateID);
        }
    }
}

